/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.cldcplatform.customwizard;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.html.HTMLEditorKit;
import org.netbeans.modules.mobility.cldcplatform.ArchiveFilter;
import org.netbeans.modules.mobility.cldcplatform.J2MEPlatform;
import org.netbeans.modules.mobility.cldcplatform.UEIEmulatorConfiguratorImpl;
import org.netbeans.modules.mobility.cldcplatform.customwizard.WizardPanel;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClasspathPanel
extends JPanel
implements WizardPanel.ComponentDescriptor {
    private static final String PROP_CLASSPATH = "Classpath";
    private final DefaultListModel classpathListModel = new DefaultListModel();
    private WizardPanel wizardPanel;
    private J2MEPlatform.J2MEProfile[] profiles;
    private JButton addButton;
    private JList classpathList;
    private JTextPane infoPanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JButton removeButton;

    public ClasspathPanel() {
        this.initComponents();
        this.infoPanel.setEditorKitForContentType("text/html", new HTMLEditorKit());
        this.infoPanel.setContentType("text/html;charset=UTF-8");
        this.classpathList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                Object[] objectArray = ClasspathPanel.this.classpathList.getSelectedValues();
                ClasspathPanel.this.removeButton.setEnabled(objectArray != null && objectArray.length > 0);
            }
        });
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.classpathList = new JList();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.jLabel2 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.infoPanel = new JTextPane();
        this.setName(NbBundle.getMessage(ClasspathPanel.class, (String)"Title_CPPanel_Bootstrap_Libraries"));
        this.setPreferredSize(new Dimension(600, 400));
        this.setLayout(new GridBagLayout());
        this.jLabel1.setLabelFor(this.classpathList);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(ClasspathPanel.class, (String)"LBL_CPPanel_Classpath"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ClasspathPanel.class, (String)"ACSD_CPPanel_Classpath"));
        this.jLabel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClasspathPanel.class, (String)"ACSD_CPPanel_Classpath"));
        this.classpathList.setModel(this.classpathListModel);
        this.jScrollPane1.setViewportView(this.classpathList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 4.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(ClasspathPanel.class, (String)"LBL_CPPanel_Add"));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClasspathPanel.this.addButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.addButton, gridBagConstraints);
        this.addButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ClasspathPanel.class, (String)"ACSD_CPPanel_Add"));
        this.addButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClasspathPanel.class, (String)"ACSD_CPPanel_Add"));
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(ClasspathPanel.class, (String)"LBL_CPPanel_Remove"));
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClasspathPanel.this.removeButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.add((Component)this.removeButton, gridBagConstraints);
        this.removeButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ClasspathPanel.class, (String)"ACSD_CPPanel_Remove"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClasspathPanel.class, (String)"ACSD_CPPanel_Remove"));
        this.jLabel2.setLabelFor(this.infoPanel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(ClasspathPanel.class, (String)"LBL_CPPanel_Detected_APIs"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel2.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ClasspathPanel.class, (String)"ACSD_CPPanel_Detected_APIs"));
        this.jLabel2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClasspathPanel.class, (String)"ACSD_CPPanel_Detected_APIs"));
        this.infoPanel.setBackground(UIManager.getDefaults().getColor("Panel.background"));
        this.infoPanel.setEditable(false);
        this.jScrollPane2.setViewportView(this.infoPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 12);
        this.add((Component)this.jScrollPane2, gridBagConstraints);
    }

    private void addButtonActionPerformed(ActionEvent actionEvent) {
        File[] fileArray = this.browse(NbBundle.getMessage(ClasspathPanel.class, (String)"TITLE_ClasspathPanel_SelectClasspath"));
        if (fileArray == null) {
            return;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            String string = fileArray[i].getAbsolutePath();
            if (this.classpathListModel.contains(string)) continue;
            this.classpathListModel.addElement(string);
        }
        this.updateStatus();
    }

    private void removeButtonActionPerformed(ActionEvent actionEvent) {
        Object[] objectArray = this.classpathList.getSelectedValues();
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                this.classpathListModel.removeElement(objectArray[i]);
            }
        }
        this.updateStatus();
    }

    @Override
    public void setWizardPanel(WizardPanel wizardPanel) {
        this.wizardPanel = wizardPanel;
    }

    @Override
    public void readSettings(WizardDescriptor wizardDescriptor) {
        J2MEPlatform j2MEPlatform = (J2MEPlatform)((Object)wizardDescriptor.getProperty("Platform"));
        J2MEPlatform.Device device = j2MEPlatform.getDevices()[0];
        J2MEPlatform.J2MEProfile[] j2MEProfileArray = device.getProfiles();
        if (j2MEProfileArray.length > 0) {
            List list = (List)wizardDescriptor.getProperty(PROP_CLASSPATH);
            this.stringsToModel(list);
        } else {
            ArrayList<String> arrayList = new ArrayList<String>();
            this.searchForClasspath(arrayList, new File(j2MEPlatform.getHomePath()), 6);
            this.stringsToModel(arrayList);
        }
    }

    @Override
    public void storeSettings(WizardDescriptor wizardDescriptor) {
        J2MEPlatform j2MEPlatform = (J2MEPlatform)((Object)wizardDescriptor.getProperty("Platform"));
        J2MEPlatform.Device device = j2MEPlatform.getDevices()[0];
        J2MEPlatform.Device device2 = new J2MEPlatform.Device(device.getName(), null, null, this.profiles, null);
        j2MEPlatform.setDevices(new J2MEPlatform.Device[]{device2});
        wizardDescriptor.putProperty(PROP_CLASSPATH, this.modelToStrings());
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public boolean isPanelValid() {
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < this.profiles.length; ++i) {
            J2MEPlatform.J2MEProfile j2MEProfile = this.profiles[i];
            if ("profile".equals(j2MEProfile.getType())) {
                bl = true;
                continue;
            }
            if (!"configuration".equals(j2MEProfile.getType())) continue;
            bl2 = true;
        }
        if (!bl) {
            this.wizardPanel.setErrorMessage(ClasspathPanel.class, "ERR_NoProfile");
        } else if (!bl2) {
            this.wizardPanel.setErrorMessage(ClasspathPanel.class, "ERR_NoConfiguration");
        } else {
            this.wizardPanel.setErrorMessage(ClasspathPanel.class, null);
        }
        return bl && bl2;
    }

    @Override
    public boolean isFinishPanel() {
        return true;
    }

    private void updateStatus() {
        J2MEPlatform j2MEPlatform = (J2MEPlatform)((Object)this.wizardPanel.getProperty("Platform"));
        String string = this.stringsToString(Arrays.asList(this.classpathListModel.toArray()));
        List<J2MEPlatform.J2MEProfile> list = UEIEmulatorConfiguratorImpl.analyzePath(new File(j2MEPlatform.getHomePath()), string, string);
        this.profiles = list.toArray(new J2MEPlatform.J2MEProfile[list.size()]);
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        for (int i = 0; i < this.profiles.length; ++i) {
            J2MEPlatform.J2MEProfile j2MEProfile = this.profiles[i];
            if (j2MEProfile.isNameIsJarFileName()) continue;
            if ("profile".equals(j2MEProfile.getType())) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(NbBundle.getMessage(ClasspathPanel.class, (String)"MSG_OutputTextBold", (Object)j2MEProfile.getName(), (Object)j2MEProfile.getVersion()));
                continue;
            }
            if ("configuration".equals(j2MEProfile.getType())) {
                if (stringBuffer2.length() > 0) {
                    stringBuffer2.append(", ");
                }
                stringBuffer2.append(NbBundle.getMessage(ClasspathPanel.class, (String)"MSG_OutputTextBold", (Object)j2MEProfile.getName(), (Object)j2MEProfile.getVersion()));
                continue;
            }
            if (!"optional".equals(j2MEProfile.getType())) continue;
            if (stringBuffer3.length() > 0) {
                stringBuffer3.append(", ");
            }
            stringBuffer3.append(NbBundle.getMessage(ClasspathPanel.class, (String)"MSG_OutputText", (Object)j2MEProfile.getName(), (Object)j2MEProfile.getVersion()));
        }
        StringBuffer stringBuffer4 = new StringBuffer(200);
        stringBuffer4.append("<html><font face=\"dialog\" size=\"-1\">");
        boolean bl = false;
        if (stringBuffer.length() > 0) {
            stringBuffer4.append(NbBundle.getMessage(ClasspathPanel.class, (String)"LBL_CPPanel_Profiles")).append(stringBuffer).append("<br>");
            bl = true;
        }
        if (stringBuffer2.length() > 0) {
            stringBuffer4.append(NbBundle.getMessage(ClasspathPanel.class, (String)"LBL_CPPanel_Configurations")).append(stringBuffer2).append("<br>");
            bl = true;
        }
        if (stringBuffer3.length() > 0) {
            stringBuffer4.append(NbBundle.getMessage(ClasspathPanel.class, (String)"LBL_CPPanle_Optional_APIs")).append(stringBuffer3).append("<br>");
            bl = true;
        }
        stringBuffer4.append(bl ? "<font size=\"-2\">" + NbBundle.getMessage(ClasspathPanel.class, (String)"MSG_CPPanel_Recognized_Packages_Shown_Only") : NbBundle.getMessage(ClasspathPanel.class, (String)"MSG_CPPanel_Details_Not_Available"));
        this.infoPanel.setText(stringBuffer4.toString());
        this.infoPanel.setCaretPosition(0);
        this.wizardPanel.fireChanged();
    }

    private void stringsToModel(List<String> list) {
        this.classpathListModel.clear();
        for (String string : list) {
            this.classpathListModel.addElement(string);
        }
        this.updateStatus();
    }

    private List<String> modelToStrings() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.classpathListModel.size(); ++i) {
            arrayList.add((String)this.classpathListModel.get(i));
        }
        return arrayList;
    }

    private String stringsToString(List<Object> list) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(list.get(i));
        }
        return stringBuffer.toString();
    }

    private void searchForClasspath(ArrayList<String> arrayList, File file, int n) {
        File[] fileArray = file.listFiles();
        if (fileArray != null && fileArray.length < 40 && arrayList.size() < 100) {
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                String string = file2.getName().toLowerCase();
                if (n > 0 && file2.isDirectory()) {
                    this.searchForClasspath(arrayList, file2, n - 1);
                    continue;
                }
                if (!file2.isFile() || !string.endsWith(".jar") && !string.endsWith(".zip")) continue;
                arrayList.add(file2.getAbsolutePath());
            }
        }
    }

    private File[] browse(String string) {
        return new FileChooserBuilder(ClasspathPanel.class).setTitle(string).setFileFilter((FileFilter)new ArchiveFilter()).showMultiOpenDialog();
    }
}

