/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.freeform;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.project.Project;
import org.netbeans.modules.ant.freeform.spi.HelpIDFragmentProvider;
import org.netbeans.modules.ant.freeform.spi.ProjectAccessor;
import org.netbeans.modules.ant.freeform.spi.support.Util;
import org.netbeans.modules.web.freeform.WebFreeFormActionProvider;
import org.netbeans.modules.web.freeform.WebModules;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.LookupProvider;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.ui.PrivilegedTemplates;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.netbeans.spi.project.ui.RecommendedTemplates;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class LookupProviderImpl
implements LookupProvider {
    private static final String HELP_ID_FRAGMENT = "web";

    public Lookup createAdditionalLookup(Lookup lookup) {
        Project project = (Project)lookup.lookup(Project.class);
        ProjectAccessor projectAccessor = (ProjectAccessor)lookup.lookup(ProjectAccessor.class);
        AuxiliaryConfiguration auxiliaryConfiguration = (AuxiliaryConfiguration)lookup.lookup(AuxiliaryConfiguration.class);
        assert (auxiliaryConfiguration != null);
        assert (project != null);
        assert (projectAccessor != null);
        return new ProjectLookup(project, projectAccessor.getHelper(), projectAccessor.getEvaluator(), auxiliaryConfiguration);
    }

    private static Lookup initLookup(Project project, AntProjectHelper antProjectHelper, PropertyEvaluator propertyEvaluator, AuxiliaryConfiguration auxiliaryConfiguration) {
        WebClasspath webClasspath = new WebClasspath(antProjectHelper, propertyEvaluator, auxiliaryConfiguration, project);
        return Lookups.fixed((Object[])new Object[]{new ProjectOpenedHookImpl(webClasspath), new PrivilegedTemplatesImpl(), new WebModules(project, antProjectHelper, propertyEvaluator, auxiliaryConfiguration), new WebFreeFormActionProvider(project, antProjectHelper, auxiliaryConfiguration), new HelpIDFragmentProviderImpl()});
    }

    public static boolean isMyProject(AuxiliaryConfiguration auxiliaryConfiguration) {
        return auxiliaryConfiguration.getConfigurationFragment("web-data", "http://www.netbeans.org/ns/freeform-project-web/1", true) != null || auxiliaryConfiguration.getConfigurationFragment("web-data", "http://www.netbeans.org/ns/freeform-project-web/2", true) != null;
    }

    static Element upgradeSchema(Element element) {
        Document document = element.getOwnerDocument();
        Element element2 = document.createElementNS("http://www.netbeans.org/ns/freeform-project-web/2", "web-data");
        LookupProviderImpl.copyXMLTree(document, element, element2, "http://www.netbeans.org/ns/freeform-project-web/2");
        return element2;
    }

    private static void copyXMLTree(Document document, Element element, Element element2, String string) {
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node;
            Node node2 = nodeList.item(i);
            switch (node2.getNodeType()) {
                case 1: {
                    Element element3 = (Element)node2;
                    node = document.createElementNS(string, element3.getTagName());
                    NamedNodeMap namedNodeMap = element3.getAttributes();
                    int n2 = namedNodeMap.getLength();
                    for (int j = 0; j < n2; ++j) {
                        Attr attr = (Attr)namedNodeMap.item(j);
                        ((Element)node).setAttributeNS(attr.getNamespaceURI(), attr.getName(), attr.getValue());
                    }
                    LookupProviderImpl.copyXMLTree(document, element3, (Element)node, string);
                    break;
                }
                case 3: {
                    node = document.createTextNode(((Text)node2).getData());
                    break;
                }
                case 8: {
                    node = document.createComment(((Comment)node2).getData());
                    break;
                }
                default: {
                    throw new AssertionError(node2);
                }
            }
            element2.appendChild(node);
        }
    }

    private static final class PrivilegedTemplatesImpl
    implements PrivilegedTemplates,
    RecommendedTemplates {
        private static final String[] PRIVILEGED_NAMES = new String[]{"Templates/JSP_Servlet/JSP.jsp", "Templates/JSP_Servlet/Html.html", "Templates/JSP_Servlet/Servlet.java"};
        private static final String[] RECOMENDED_TYPES = new String[]{"java-classes", "java-main-class", "java-beans", "oasis-XML-catalogs", "XML", "wsdl", "ant-script", "ant-task", "servlet-types", "web-types", "j2ee-types", "junit", "simple-files"};

        private PrivilegedTemplatesImpl() {
        }

        public String[] getPrivilegedTemplates() {
            return PRIVILEGED_NAMES;
        }

        public String[] getRecommendedTypes() {
            return RECOMENDED_TYPES;
        }
    }

    private static final class ProjectLookup
    extends ProxyLookup
    implements AntProjectListener {
        private AntProjectHelper helper;
        private PropertyEvaluator evaluator;
        private Project project;
        private AuxiliaryConfiguration aux;
        private boolean isMyProject;

        public ProjectLookup(Project project, AntProjectHelper antProjectHelper, PropertyEvaluator propertyEvaluator, AuxiliaryConfiguration auxiliaryConfiguration) {
            super(new Lookup[0]);
            this.project = project;
            this.helper = antProjectHelper;
            this.evaluator = propertyEvaluator;
            this.aux = new UpgradingAuxiliaryConfiguration(auxiliaryConfiguration);
            this.isMyProject = LookupProviderImpl.isMyProject(auxiliaryConfiguration);
            this.updateLookup();
            antProjectHelper.addAntProjectListener((AntProjectListener)this);
        }

        private void updateLookup() {
            Lookup lookup = Lookup.EMPTY;
            if (this.isMyProject) {
                lookup = LookupProviderImpl.initLookup(this.project, this.helper, this.evaluator, this.aux);
            }
            this.setLookups(new Lookup[]{lookup});
        }

        public void configurationXmlChanged(AntProjectEvent antProjectEvent) {
            if (LookupProviderImpl.isMyProject(this.aux) != this.isMyProject) {
                this.isMyProject = !this.isMyProject;
                this.updateLookup();
            }
        }

        public void propertiesChanged(AntProjectEvent antProjectEvent) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class WebClasspath
    implements AntProjectListener,
    PropertyChangeListener {
        private ClassPath[] registeredCP = new ClassPath[0];
        private List<FileObject> registeredRoots = Collections.emptyList();
        private PropertyEvaluator evaluator;
        private AuxiliaryConfiguration aux;
        private Project project;
        private PropertyChangeSupport pcs;
        private boolean prjClosed = false;

        public WebClasspath(AntProjectHelper antProjectHelper, PropertyEvaluator propertyEvaluator, AuxiliaryConfiguration auxiliaryConfiguration, Project project) {
            this.evaluator = propertyEvaluator;
            this.aux = auxiliaryConfiguration;
            this.project = project;
            antProjectHelper.addAntProjectListener((AntProjectListener)this);
            propertyEvaluator.addPropertyChangeListener((PropertyChangeListener)this);
            this.pcs = new PropertyChangeSupport(this);
        }

        public void prjOpened() {
            this.registeredRoots = this.getWebRoots(this.aux, this.project, this.evaluator);
            FileObject[] fileObjectArray = this.registeredRoots.toArray(new FileObject[this.registeredRoots.size()]);
            ClassPath classPath = ClassPathSupport.createClassPath((FileObject[])fileObjectArray);
            this.registeredCP = new ClassPath[]{classPath};
            GlobalPathRegistry.getDefault().register("classpath/source", this.registeredCP);
            this.prjClosed = false;
        }

        public void prjClosed() {
            if (!this.registeredRoots.isEmpty()) {
                GlobalPathRegistry.getDefault().unregister("classpath/source", this.registeredCP);
            }
            this.registeredRoots = Collections.emptyList();
            this.prjClosed = true;
        }

        public void configurationXmlChanged(AntProjectEvent antProjectEvent) {
            this.updateClasspath();
        }

        public void propertiesChanged(AntProjectEvent antProjectEvent) {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.updateClasspath();
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.pcs.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.pcs.removePropertyChangeListener(propertyChangeListener);
        }

        private synchronized void updateClasspath() {
            List<FileObject> list;
            if (!this.prjClosed && (list = this.getWebRoots(this.aux, this.project, this.evaluator)) != null && !((Object)list).equals(this.registeredRoots)) {
                FileObject[] fileObjectArray = list.toArray(new FileObject[list.size()]);
                ClassPath classPath = ClassPathSupport.createClassPath((FileObject[])fileObjectArray);
                GlobalPathRegistry.getDefault().unregister("classpath/source", this.registeredCP);
                this.registeredCP = new ClassPath[]{classPath};
                this.registeredRoots = list;
                GlobalPathRegistry.getDefault().register("classpath/source", this.registeredCP);
                this.pcs.firePropertyChange("resources", null, null);
            }
        }

        private List<FileObject> getWebRoots(AuxiliaryConfiguration auxiliaryConfiguration, Project project, PropertyEvaluator propertyEvaluator) {
            Element element = auxiliaryConfiguration.getConfigurationFragment("web-data", "http://www.netbeans.org/ns/freeform-project-web/2", true);
            if (element == null) {
                return null;
            }
            List list = Util.findSubElements((Element)element);
            ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
            for (Element element2 : list) {
                assert (element2.getLocalName().equals("web-module")) : element2;
                arrayList.add(FileUtil.toFileObject((File)this.getFile(element2, "doc-root", project, propertyEvaluator)));
            }
            return arrayList;
        }

        private File getFile(Element element, String string, Project project, PropertyEvaluator propertyEvaluator) {
            Element element2 = Util.findElement((Element)element, (String)string, (String)"http://www.netbeans.org/ns/freeform-project-web/2");
            return Util.resolveFile((PropertyEvaluator)propertyEvaluator, (File)FileUtil.toFile((FileObject)project.getProjectDirectory()), (String)Util.findText((Element)element2));
        }
    }

    static final class UpgradingAuxiliaryConfiguration
    implements AuxiliaryConfiguration {
        private final AuxiliaryConfiguration delegate;

        public UpgradingAuxiliaryConfiguration(AuxiliaryConfiguration auxiliaryConfiguration) {
            this.delegate = auxiliaryConfiguration;
        }

        public Element getConfigurationFragment(String string, String string2, boolean bl) {
            if (string.equals("web-data") && string2.equals("http://www.netbeans.org/ns/freeform-project-web/2") && bl) {
                Element element;
                Element element2 = this.delegate.getConfigurationFragment("web-data", "http://www.netbeans.org/ns/freeform-project-web/2", true);
                if (element2 == null && (element = this.delegate.getConfigurationFragment("web-data", "http://www.netbeans.org/ns/freeform-project-web/1", true)) != null) {
                    element2 = LookupProviderImpl.upgradeSchema(element);
                }
                return element2;
            }
            return this.delegate.getConfigurationFragment(string, string2, bl);
        }

        public void putConfigurationFragment(Element element, boolean bl) throws IllegalArgumentException {
            this.delegate.putConfigurationFragment(element, bl);
        }

        public boolean removeConfigurationFragment(String string, String string2, boolean bl) throws IllegalArgumentException {
            return this.delegate.removeConfigurationFragment(string, string2, bl);
        }
    }

    private static class ProjectOpenedHookImpl
    extends ProjectOpenedHook {
        private final WebClasspath webcp;

        public ProjectOpenedHookImpl(WebClasspath webClasspath) {
            this.webcp = webClasspath;
        }

        protected void projectOpened() {
            this.webcp.prjOpened();
        }

        protected void projectClosed() {
            this.webcp.prjClosed();
        }
    }

    private static final class HelpIDFragmentProviderImpl
    implements HelpIDFragmentProvider {
        private HelpIDFragmentProviderImpl() {
        }

        public String getHelpIDFragment() {
            return LookupProviderImpl.HELP_ID_FRAGMENT;
        }
    }
}

