/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.wizards;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URISyntaxException;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.mercurial.ui.repository.HgURL;
import org.netbeans.modules.mercurial.ui.repository.Repository;
import org.netbeans.modules.mercurial.ui.wizards.ClonePathsPanel;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotificationLineSupport;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ClonePathsWizardPanel
implements WizardDescriptor.Panel {
    private ClonePathsPanel component;
    private HgURL repositoryOrig;
    private Listener listener;
    private HgURL pullUrl;
    private HgURL pushUrl;
    private HgURL defaultUrl;
    private String defaultUrlString;

    public Component getComponent() {
        if (this.component == null) {
            this.component = new ClonePathsPanel();
            this.initInteraction();
        }
        return this.component;
    }

    private void initInteraction() {
        this.listener = new Listener();
        this.component.defaultValuesButton.addActionListener(this.listener);
        this.component.changePullPathButton.addActionListener(this.listener);
        this.component.changePushPathButton.addActionListener(this.listener);
    }

    private HgURL changeUrl(String string) {
        int n = 36;
        String string2 = ClonePathsWizardPanel.getMessage(string);
        final JButton jButton = new JButton();
        JButton jButton2 = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)jButton, (String)ClonePathsWizardPanel.getMessage("changePullPushPath.Set"));
        Mnemonics.setLocalizedText((AbstractButton)jButton2, (String)ClonePathsWizardPanel.getMessage("changePullPushPath.Clear"));
        final Repository repository = new Repository(n, string2, true);
        jButton.setEnabled(repository.isValid());
        jButton2.setDefaultCapable(false);
        final DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)HgUtils.addContainerBorder(repository.getPanel()), string2, true, new Object[]{jButton, jButton2, NotifyDescriptor.CANCEL_OPTION}, (Object)jButton, 0, new HelpCtx(ClonePathsWizardPanel.class.getName() + ".change"), null);
        dialogDescriptor.setClosingOptions(new Object[]{jButton2, NotifyDescriptor.CANCEL_OPTION});
        final NotificationLineSupport notificationLineSupport = dialogDescriptor.createNotificationLineSupport();
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class RepositoryChangeListener
        implements ChangeListener,
        ActionListener {
            private Dialog dialog;

            RepositoryChangeListener() {
            }

            public void setDialog(Dialog dialog) {
                this.dialog = dialog;
            }

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                assert (changeEvent.getSource() == repository);
                boolean bl = repository.isValid();
                dialogDescriptor.setValid(bl);
                jButton.setEnabled(bl);
                if (bl) {
                    notificationLineSupport.clearMessages();
                } else {
                    String string = repository.getMessage();
                    if (string != null && string.length() != 0) {
                        notificationLineSupport.setErrorMessage(string);
                    } else {
                        notificationLineSupport.clearMessages();
                    }
                }
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() != jButton) {
                    return;
                }
                try {
                    dialogDescriptor.setValue((Object)repository.getUrl());
                    this.dialog.setVisible(false);
                    this.dialog.dispose();
                }
                catch (URISyntaxException uRISyntaxException) {
                    repository.setInvalid();
                    notificationLineSupport.setErrorMessage(uRISyntaxException.getMessage());
                }
            }
        }
        RepositoryChangeListener repositoryChangeListener = new RepositoryChangeListener();
        repository.addChangeListener(repositoryChangeListener);
        dialogDescriptor.setButtonListener((ActionListener)repositoryChangeListener);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        repositoryChangeListener.setDialog(dialog);
        dialog.pack();
        dialog.setVisible(true);
        Object object = dialogDescriptor.getValue();
        assert (object instanceof HgURL || object == jButton2 || object == NotifyDescriptor.CANCEL_OPTION || object == NotifyDescriptor.CLOSED_OPTION);
        if (object instanceof HgURL) {
            return (HgURL)object;
        }
        if (object == jButton2) {
            return HgURL.NO_URL;
        }
        return null;
    }

    public boolean isValid() {
        return true;
    }

    public HelpCtx getHelp() {
        return new HelpCtx(ClonePathsWizardPanel.class);
    }

    public final void addChangeListener(ChangeListener changeListener) {
    }

    public final void removeChangeListener(ChangeListener changeListener) {
    }

    private void setDefaultValues() {
        this.setDefaultValues(true, true);
    }

    private void setDefaultValues(boolean bl, boolean bl2) {
        if (bl) {
            this.component.defaultPullPathField.setText(this.getDefaultPath());
            this.pullUrl = this.repositoryOrig;
        }
        if (bl2) {
            this.component.defaultPushPathField.setText(this.getDefaultPath());
            this.pushUrl = this.repositoryOrig;
        }
    }

    private String getDefaultPath() {
        if (this.defaultUrlString == null) {
            this.defaultUrlString = this.repositoryOrig.toHgCommandUrlStringWithoutUserInfo();
        }
        return this.defaultUrlString;
    }

    public void readSettings(Object object) {
        assert (object instanceof WizardDescriptor);
        this.defaultUrl = (HgURL)((WizardDescriptor)object).getProperty("repository");
        HgURL hgURL = this.defaultUrl;
        boolean bl = !hgURL.equals(this.repositoryOrig);
        this.repositoryOrig = hgURL;
        this.defaultUrlString = null;
        boolean bl2 = bl || this.pullUrl == null;
        boolean bl3 = bl || this.pushUrl == null;
        this.setDefaultValues(bl2, bl3);
    }

    public void storeSettings(Object object) {
        if (object instanceof WizardDescriptor) {
            ((WizardDescriptor)object).putProperty("defaultPullPath", (Object)this.pullUrl);
            ((WizardDescriptor)object).putProperty("defaultPushPath", (Object)this.pushUrl);
        }
    }

    private static String getMessage(String string) {
        return NbBundle.getMessage(ClonePathsWizardPanel.class, (String)string);
    }

    final class Listener
    implements ActionListener {
        Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == ((ClonePathsWizardPanel)ClonePathsWizardPanel.this).component.defaultValuesButton) {
                ClonePathsWizardPanel.this.setDefaultValues();
            } else if (object == ((ClonePathsWizardPanel)ClonePathsWizardPanel.this).component.changePullPathButton) {
                HgURL hgURL = ClonePathsWizardPanel.this.changeUrl("changePullPath.Title");
                if (hgURL != null) {
                    ((ClonePathsWizardPanel)ClonePathsWizardPanel.this).component.defaultPullPathField.setText(hgURL.toHgCommandStringWithMaskedPassword());
                    ClonePathsWizardPanel.this.pullUrl = hgURL != HgURL.NO_URL ? hgURL : null;
                }
            } else if (object == ((ClonePathsWizardPanel)ClonePathsWizardPanel.this).component.changePushPathButton) {
                HgURL hgURL = ClonePathsWizardPanel.this.changeUrl("changePushPath.Title");
                if (hgURL != null) {
                    ((ClonePathsWizardPanel)ClonePathsWizardPanel.this).component.defaultPushPathField.setText(hgURL.toHgCommandStringWithMaskedPassword());
                    ClonePathsWizardPanel.this.pushUrl = hgURL != HgURL.NO_URL ? hgURL : null;
                }
            } else assert (false);
        }
    }
}

