/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.status;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.ViewCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class OpenInEditorAction
extends AbstractAction {
    public OpenInEditorAction() {
        super(NbBundle.getBundle(OpenInEditorAction.class).getString("CTL_Synchronize_Popup_OpenInEditor"));
        this.setEnabled(this.isActionEnabled());
    }

    private boolean isActionEnabled() {
        for (File file : HgUtils.getCurrentContext(null).getRootFiles()) {
            if (!file.canRead()) continue;
            return true;
        }
        return false;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        for (File file : HgUtils.getCurrentContext(null).getRootFiles()) {
            FileObject fileObject = FileUtil.toFileObject((File)file);
            if (fileObject == null) continue;
            try {
                this.openDataObjectByCookie(DataObject.find((FileObject)fileObject));
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {}
        }
    }

    private final boolean openDataObjectByCookie(DataObject dataObject) {
        Node.Cookie cookie = dataObject.getCookie(EditorCookie.Observable.class);
        if (cookie != null) {
            return this.openByCookie(cookie, EditorCookie.Observable.class);
        }
        cookie = dataObject.getCookie(EditorCookie.class);
        if (cookie != null) {
            return this.openByCookie(cookie, EditorCookie.class);
        }
        cookie = dataObject.getCookie(OpenCookie.class);
        if (cookie != null) {
            return this.openByCookie(cookie, OpenCookie.class);
        }
        cookie = dataObject.getCookie(EditCookie.class);
        if (cookie != null) {
            return this.openByCookie(cookie, EditCookie.class);
        }
        cookie = dataObject.getCookie(ViewCookie.class);
        if (cookie != null) {
            return this.openByCookie(cookie, ViewCookie.class);
        }
        return false;
    }

    private boolean openByCookie(Node.Cookie cookie, Class clazz) {
        if (clazz == EditorCookie.class || clazz == EditorCookie.Observable.class) {
            ((EditorCookie)cookie).open();
        } else if (clazz == OpenCookie.class) {
            ((OpenCookie)cookie).open();
        } else if (clazz == EditCookie.class) {
            ((EditCookie)cookie).edit();
        } else if (clazz == ViewCookie.class) {
            ((ViewCookie)cookie).view();
        } else {
            throw new IllegalArgumentException("Reopen #58766: " + clazz);
        }
        return true;
    }
}

