/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.repository;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.ui.repository.HgURL;
import org.netbeans.modules.mercurial.ui.repository.RepositoryConnection;
import org.netbeans.modules.mercurial.ui.repository.RepositoryDialogPanel;
import org.netbeans.modules.mercurial.ui.repository.RepositoryPanel;
import org.netbeans.modules.versioning.util.DialogBoundsPreserver;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Repository
implements ActionListener,
FocusListener,
ItemListener {
    public static final int FLAG_URL_ENABLED = 4;
    public static final int FLAG_ACCEPT_REVISION = 8;
    public static final int FLAG_SHOW_HINTS = 32;
    public static final int FLAG_SHOW_PROXY = 64;
    private static final String LOCAL_URL_HELP = "file:/repository_path";
    private static final String HTTP_URL_HELP = Utilities.isWindows() ? "http://[DOMAIN%5C]hostname/repository_path" : "http://hostname/repository_path";
    private static final String HTTPS_URL_HELP = Utilities.isWindows() ? "https://[DOMAIN%5C]hostname/repository_path" : "https://hostname/repository_path";
    private static final String STATIC_HTTP_URL_HELP = "static-http://hostname/repository_path";
    private static final String SSH_URL_HELP = "ssh://hostname/repository_path";
    private RepositoryPanel repositoryPanel;
    private boolean valid = true;
    private List<ChangeListener> listeners;
    private final ChangeEvent changeEvent = new ChangeEvent(this);
    private RepositoryConnection repositoryConnection;
    private HgURL url;
    public static final String PROP_VALID = "valid";
    private String message;
    private int modeMask;
    private Dimension maxNeededSize;
    private boolean bPushPull;
    private static int HG_PUSH_PULL_VERT_PADDING = 30;
    private JTextComponent urlComboEditor;
    private Document urlDoc;
    private Document usernameDoc;
    private Document passwordDoc;
    private Document tunnelCmdDoc;
    private boolean urlBeingSelectedFromPopup = false;

    public Repository(int n, String string, boolean bl) {
        this.modeMask = n;
        this.initPanel();
        this.repositoryPanel.titleLabel.setText(string);
        this.repositoryPanel.urlComboBox.setEnabled(this.isSet(4));
        this.repositoryPanel.tunnelHelpLabel.setVisible(this.isSet(32));
        this.repositoryPanel.tipLabel.setVisible(this.isSet(32));
        if (bl) {
            this.updateVisibility("foo:");
        } else {
            this.updateVisibility("https:");
        }
        this.maxNeededSize = this.repositoryPanel.getPreferredSize();
        this.repositoryPanel.savePasswordCheckBox.setSelected(HgModuleConfig.getDefault().getSavePassword());
        this.repositoryPanel.schedulePostInitRoutine(new Runnable(){

            public void run() {
                Repository.this.refreshUrlHistory();
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        assert (actionEvent.getSource() == this.repositoryPanel.proxySettingsButton);
        this.onProxyConfiguration();
    }

    private void onProxyConfiguration() {
        OptionsDisplayer.getDefault().open("General");
    }

    private void initPanel() {
        this.repositoryPanel = new RepositoryPanel();
        this.urlComboEditor = (JTextComponent)this.repositoryPanel.urlComboBox.getEditor().getEditorComponent();
        this.urlDoc = this.urlComboEditor.getDocument();
        this.usernameDoc = this.repositoryPanel.userTextField.getDocument();
        this.passwordDoc = this.repositoryPanel.userPasswordField.getDocument();
        this.tunnelCmdDoc = this.repositoryPanel.tunnelCommandTextField.getDocument();
        DocumentChangeHandler documentChangeHandler = new DocumentChangeHandler();
        this.urlDoc.addDocumentListener(documentChangeHandler);
        this.passwordDoc.addDocumentListener(documentChangeHandler);
        this.usernameDoc.addDocumentListener(documentChangeHandler);
        this.tunnelCmdDoc.addDocumentListener(documentChangeHandler);
        this.repositoryPanel.savePasswordCheckBox.addItemListener(this);
        this.repositoryPanel.urlComboBox.addItemListener(this);
        this.repositoryPanel.proxySettingsButton.addActionListener(this);
        this.repositoryPanel.userPasswordField.addFocusListener(this);
        this.tweakComboBoxEditor();
    }

    private void tweakComboBoxEditor() {
        ComboBoxEditor comboBoxEditor = this.repositoryPanel.urlComboBox.getEditor();
        if (comboBoxEditor.getClass() == UrlComboBoxEditor.class) {
            assert (false);
            return;
        }
        this.repositoryPanel.urlComboBox.setEditor(new UrlComboBoxEditor(comboBoxEditor));
    }

    public void refreshUrlHistory() {
        this.repositoryPanel.urlComboBox.setModel(new DefaultComboBoxModel(this.createPresetComboEntries()));
        this.urlComboEditor.selectAll();
    }

    private Vector<?> createPresetComboEntries() {
        assert (this.repositoryPanel.urlComboBox.isEditable());
        List<RepositoryConnection> list = HgModuleConfig.getDefault().getRecentUrls();
        HgURL.Scheme[] schemeArray = HgURL.Scheme.values();
        Vector<Object> vector = new Vector<Object>(list.size() + schemeArray.length);
        vector.addAll(list);
        for (HgURL.Scheme scheme : schemeArray) {
            vector.add(Repository.createURIPrefixForScheme(scheme));
        }
        return vector;
    }

    private static String createURIPrefixForScheme(HgURL.Scheme scheme) {
        if (scheme == HgURL.Scheme.FILE) {
            return (Object)((Object)scheme) + ":/";
        }
        return (Object)((Object)scheme) + "://";
    }

    private void quickValidateUrl() {
        String string = HgURL.validateQuickly(this.getUrlString());
        if (string == null) {
            this.setValid();
        } else {
            this.setValid(false, string);
        }
    }

    private void onUrlChange() {
        if (!this.urlBeingSelectedFromPopup) {
            this.repositoryConnection = null;
            this.url = null;
            this.repositoryPanel.userTextField.setText(null);
            this.repositoryPanel.userPasswordField.setText(null);
            this.repositoryPanel.tunnelCommandTextField.setText(null);
            this.repositoryPanel.savePasswordCheckBox.setSelected(false);
        }
        this.quickValidateUrl();
        this.updateVisibility();
    }

    private void updateVisibility() {
        this.updateVisibility(this.getUrlString());
    }

    private void updateVisibility(String string) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (string.startsWith("http:")) {
            this.repositoryPanel.tipLabel.setText(HTTP_URL_HELP);
            bl = true;
            bl2 = true;
        } else if (string.startsWith("https:")) {
            this.repositoryPanel.tipLabel.setText(HTTPS_URL_HELP);
            bl2 = true;
        } else if (string.startsWith("static-http:")) {
            this.repositoryPanel.tipLabel.setText(STATIC_HTTP_URL_HELP);
            bl = true;
            bl2 = true;
        } else if (string.startsWith("ssh")) {
            this.repositoryPanel.tipLabel.setText(this.getSVNTunnelTip(string));
            bl3 = true;
        } else if (string.startsWith("file:")) {
            this.repositoryPanel.tipLabel.setText(LOCAL_URL_HELP);
        } else {
            this.repositoryPanel.tipLabel.setText(NbBundle.getMessage(Repository.class, (String)"MSG_Repository_Url_Help", (Object[])new Object[]{LOCAL_URL_HELP, HTTP_URL_HELP, HTTPS_URL_HELP, STATIC_HTTP_URL_HELP, SSH_URL_HELP}));
        }
        this.repositoryPanel.userPasswordField.setVisible(bl);
        this.repositoryPanel.passwordLabel.setVisible(bl);
        this.repositoryPanel.userTextField.setVisible(bl);
        this.repositoryPanel.leaveBlankLabel.setVisible(bl);
        this.repositoryPanel.userLabel.setVisible(bl);
        this.repositoryPanel.savePasswordCheckBox.setVisible(false);
        this.repositoryPanel.proxySettingsButton.setVisible(bl2 && (this.modeMask & 0x40) != 0);
        this.repositoryPanel.savePasswordCheckBox.setVisible(false);
        this.repositoryPanel.tunnelCommandTextField.setVisible(false);
        this.repositoryPanel.tunnelCommandLabel.setVisible(false);
        this.repositoryPanel.tunnelLabel.setVisible(false);
        this.repositoryPanel.tunnelHelpLabel.setVisible(false);
    }

    public void setEditable(boolean bl) {
        assert (EventQueue.isDispatchThread());
        this.repositoryPanel.urlComboBox.setEnabled(bl && this.isSet(4));
        this.repositoryPanel.userTextField.setEnabled(bl && this.valid);
        this.repositoryPanel.userPasswordField.setEnabled(bl && this.valid);
        this.repositoryPanel.savePasswordCheckBox.setEnabled(bl && this.valid);
        this.repositoryPanel.tunnelCommandTextField.setEnabled(bl && this.valid);
        this.repositoryPanel.proxySettingsButton.setEnabled(bl && this.valid);
    }

    private String getSVNTunnelTip(String string) {
        return SSH_URL_HELP;
    }

    public String getUrlString() {
        return this.urlComboEditor.getText().trim();
    }

    private String getUsername() {
        return this.repositoryPanel.userTextField.getText().trim();
    }

    private String getPassword() {
        char[] cArray = this.repositoryPanel.userPasswordField.getPassword();
        String string = new String(cArray);
        Arrays.fill(cArray, '\u0000');
        return string;
    }

    private String getExternalCommand() {
        return this.repositoryPanel.tunnelCommandTextField.getText();
    }

    private boolean isSavePassword() {
        return this.repositoryPanel.savePasswordCheckBox.isSelected();
    }

    public HgURL getUrl() throws URISyntaxException {
        this.prepareUrl();
        assert (this.url != null);
        return this.url;
    }

    public RepositoryConnection getRepositoryConnection() throws URISyntaxException {
        this.prepareRepositoryConnection();
        assert (this.repositoryConnection != null);
        return this.repositoryConnection;
    }

    private void prepareUrl() throws URISyntaxException {
        if (this.url != null) {
            return;
        }
        String string = this.getUrlString();
        String string2 = this.getUsername();
        this.url = string2.length() == 0 ? new HgURL(string) : new HgURL(string, string2, this.getPassword());
    }

    private void prepareRepositoryConnection() {
        if (this.repositoryConnection != null) {
            return;
        }
        String string = this.getExternalCommand();
        boolean bl = this.isSavePassword();
        this.repositoryConnection = new RepositoryConnection(this.url, string, bl);
    }

    private void onUsernameChange() {
        this.repositoryConnection = null;
        this.url = null;
    }

    private void onPasswordChange() {
        this.repositoryConnection = null;
        this.url = null;
    }

    private void onTunnelCommandChange() {
        this.repositoryConnection = null;
    }

    private void onSavePasswordChange() {
        this.repositoryConnection = null;
    }

    public RepositoryPanel getPanel() {
        return this.repositoryPanel;
    }

    public boolean isValid() {
        return this.valid;
    }

    private void setValid() {
        this.setValid(true, "");
    }

    public void setInvalid() {
        this.setValid(false, "");
    }

    private void setValid(boolean bl, String string) {
        if (bl == this.valid && string.equals(this.message)) {
            return;
        }
        if (bl != this.valid) {
            this.repositoryPanel.proxySettingsButton.setEnabled(bl);
            this.repositoryPanel.userPasswordField.setEnabled(bl);
            this.repositoryPanel.userTextField.setEnabled(bl);
        }
        this.valid = bl;
        this.message = string;
        this.fireStateChanged();
    }

    private void fireStateChanged() {
        if (this.listeners != null && !this.listeners.isEmpty()) {
            for (ChangeListener changeListener : this.listeners) {
                changeListener.stateChanged(this.changeEvent);
            }
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ChangeListener>(4);
        }
        this.listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(changeListener);
    }

    public String getMessage() {
        return this.message;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.repositoryPanel.userPasswordField) {
            this.repositoryPanel.userPasswordField.selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.repositoryPanel.urlComboBox) {
            if (itemEvent.getStateChange() == 1) {
                this.comboBoxItemSelected(itemEvent.getItem());
            }
        } else if (object == this.repositoryPanel.savePasswordCheckBox) {
            this.onSavePasswordChange();
        } else assert (false);
    }

    private void comboBoxItemSelected(Object object) {
        if (object.getClass() == String.class) {
            this.urlPrefixSelected();
        } else if (object instanceof RepositoryConnection) {
            this.repositoryConnectionSelected((RepositoryConnection)object);
        } else assert (false);
    }

    private void urlPrefixSelected() {
        this.repositoryPanel.userTextField.setText(null);
        this.repositoryPanel.userPasswordField.setText(null);
        this.repositoryPanel.tunnelCommandTextField.setText(null);
        this.repositoryPanel.savePasswordCheckBox.setSelected(false);
        this.url = null;
        this.repositoryConnection = null;
    }

    private void repositoryConnectionSelected(RepositoryConnection repositoryConnection) {
        this.repositoryPanel.userTextField.setText(repositoryConnection.getUsername());
        this.repositoryPanel.userPasswordField.setText(repositoryConnection.getPassword());
        this.repositoryPanel.tunnelCommandTextField.setText(repositoryConnection.getExternalCommand());
        this.repositoryPanel.savePasswordCheckBox.setSelected(repositoryConnection.isSavePassword());
        this.url = repositoryConnection.getUrl();
        this.repositoryConnection = repositoryConnection;
    }

    public void setTipVisible(Boolean bl) {
        this.repositoryPanel.tipLabel.setVisible(bl);
    }

    public boolean show(String string, HelpCtx helpCtx, boolean bl) {
        RepositoryDialogPanel repositoryDialogPanel = new RepositoryDialogPanel();
        repositoryDialogPanel.panel.setLayout(new BorderLayout());
        RepositoryPanel repositoryPanel = this.getPanel();
        if (bl) {
            if (this.bPushPull) {
                this.maxNeededSize.setSize(this.maxNeededSize.width, this.maxNeededSize.height + HG_PUSH_PULL_VERT_PADDING);
            }
            repositoryPanel.setPreferredSize(this.maxNeededSize);
        }
        repositoryDialogPanel.panel.add((Component)repositoryPanel, "North");
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)repositoryDialogPanel, string);
        this.showDialog(dialogDescriptor, helpCtx, null);
        return dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION;
    }

    public Object show(String string, HelpCtx helpCtx, Object[] objectArray, boolean bl, String string2) {
        RepositoryDialogPanel repositoryDialogPanel = new RepositoryDialogPanel();
        repositoryDialogPanel.panel.setLayout(new BorderLayout());
        repositoryDialogPanel.panel.add((Component)this.getPanel(), "North");
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)repositoryDialogPanel, string);
        RepositoryPanel repositoryPanel = this.getPanel();
        if (bl) {
            if (this.bPushPull) {
                this.maxNeededSize.setSize(this.maxNeededSize.width, this.maxNeededSize.height + HG_PUSH_PULL_VERT_PADDING);
            }
            repositoryPanel.setPreferredSize(this.maxNeededSize);
        }
        if (objectArray != null) {
            dialogDescriptor.setOptions(objectArray);
        }
        this.showDialog(dialogDescriptor, helpCtx, string2);
        return dialogDescriptor.getValue();
    }

    private void showDialog(DialogDescriptor dialogDescriptor, HelpCtx helpCtx, String string) {
        dialogDescriptor.setModal(true);
        dialogDescriptor.setHelpCtx(helpCtx);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        if (string != null) {
            dialog.addWindowListener((WindowListener)new DialogBoundsPreserver(HgModuleConfig.getDefault().getPreferences(), string));
        }
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(Repository.class, (String)"ACSD_RepositoryPanel"));
        dialog.setVisible(true);
    }

    private boolean isSet(int n) {
        return (this.modeMask & n) != 0;
    }

    private final class DocumentChangeHandler
    implements DocumentListener {
        DocumentChangeHandler() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.textChanged(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.textChanged(documentEvent);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.textChanged(documentEvent);
        }

        private void textChanged(DocumentEvent documentEvent) {
            assert (EventQueue.isDispatchThread());
            Document document = documentEvent.getDocument();
            assert (document != null);
            assert (document == Repository.this.urlDoc || !Repository.this.urlBeingSelectedFromPopup);
            if (document == Repository.this.urlDoc) {
                Repository.this.onUrlChange();
            } else if (document == Repository.this.usernameDoc) {
                Repository.this.onUsernameChange();
            } else if (document == Repository.this.passwordDoc) {
                Repository.this.onPasswordChange();
            } else if (document == Repository.this.tunnelCmdDoc) {
                Repository.this.onTunnelCommandChange();
            }
        }
    }

    private final class UrlComboBoxEditor
    implements ComboBoxEditor,
    DocumentListener {
        private final ComboBoxEditor origEditor;
        private Reference<RepositoryConnection> repoConnRef;

        private UrlComboBoxEditor(ComboBoxEditor comboBoxEditor) {
            this.origEditor = comboBoxEditor;
            ((JTextComponent)comboBoxEditor.getEditorComponent()).getDocument().addDocumentListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setItem(Object object) {
            Repository.this.urlBeingSelectedFromPopup = true;
            try {
                this.setItemImpl(object);
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                Repository.this.urlBeingSelectedFromPopup = false;
                throw throwable;
            }
            Repository.this.urlBeingSelectedFromPopup = false;
        }

        private void setItemImpl(Object object) {
            assert (Repository.this.urlBeingSelectedFromPopup);
            if (object instanceof RepositoryConnection) {
                RepositoryConnection repositoryConnection = (RepositoryConnection)object;
                this.repoConnRef = new WeakReference<RepositoryConnection>(repositoryConnection);
                this.origEditor.setItem(repositoryConnection.getUrl().toUrlStringWithoutUserInfo());
            } else {
                this.clearRepoConnRef();
                this.origEditor.setItem(object);
            }
        }

        public Component getEditorComponent() {
            return this.origEditor.getEditorComponent();
        }

        public Object getItem() {
            RepositoryConnection repositoryConnection = this.getRepoConn();
            if (repositoryConnection != null) {
                return repositoryConnection;
            }
            return this.origEditor.getItem();
        }

        public void selectAll() {
            this.origEditor.selectAll();
        }

        public void addActionListener(ActionListener actionListener) {
            this.origEditor.addActionListener(actionListener);
        }

        public void removeActionListener(ActionListener actionListener) {
            this.origEditor.removeActionListener(actionListener);
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.textChanged();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.textChanged();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.textChanged();
        }

        private void textChanged() {
            if (Repository.this.urlBeingSelectedFromPopup) {
                return;
            }
            this.clearRepoConnRef();
        }

        private RepositoryConnection getRepoConn() {
            RepositoryConnection repositoryConnection;
            if (this.repoConnRef != null && (repositoryConnection = this.repoConnRef.get()) != null) {
                return repositoryConnection;
            }
            return null;
        }

        private void clearRepoConnRef() {
            if (this.repoConnRef != null) {
                this.repoConnRef.clear();
            }
        }
    }
}

