/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.repository;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.netbeans.modules.mercurial.kenai.HgKenaiSupport;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class HgURL {
    public static final HgURL NO_URL = new HgURL();
    private static final char SEGMENT_SEPARATOR = '/';
    private static final String PASSWORD_REPLACEMENT = "****";
    private static final String hexadecimalChars = "0123456789abcdef";
    private final Scheme scheme;
    private final String host;
    private final String username;
    private final String password;
    private final int port;
    private final String rawPath;
    private final String rawQuery;
    private final String rawFragment;
    private final String path;
    private String hgCommandForm;
    private String publicForm;

    public static String validateQuickly(String string) {
        if (string == null) {
            throw new IllegalArgumentException("URI string is <null>");
        }
        String string2 = HgURL.getSchemeName(string);
        if (string2 == null) {
            return HgURL.invalidUrlMessage(string);
        }
        Scheme scheme = HgURL.determineScheme(string2);
        if (scheme == null) {
            return HgURL.invalidUrlMessage(string);
        }
        String string3 = string.substring(scheme.name().length());
        if (scheme == Scheme.FILE) {
            if (!string3.startsWith(":/")) {
                return HgURL.invalidUrlMessage(string);
            }
        } else {
            if (!string3.startsWith("://")) {
                return HgURL.invalidUrlMessage(string);
            }
            if (string3.length() == "://".length()) {
                return HgURL.invalidUrlMessage(string);
            }
        }
        return null;
    }

    private static String invalidUrlMessage(String string) {
        return NbBundle.getMessage(HgURL.class, (String)"MSG_INVALID_URL", (Object)string);
    }

    private static String getSchemeName(String string) {
        return HgURL.getSchemeName(string, Scheme.getMaxSchemeNameLength());
    }

    private static String getSchemeName(String string, int n) {
        if (string.length() < 2) {
            return null;
        }
        int n2 = n != -1 ? Math.min(string.length() - 1, n) : string.length() - 1;
        StringBuilder stringBuilder = null;
        char c = string.charAt(0);
        int n3 = c | 0x20;
        if (!HgURL.isLowercaseAsciiAlpha(n3)) {
            return null;
        }
        if (c != n3) {
            stringBuilder = new StringBuilder(n2);
            stringBuilder.append(n3);
        }
        int n4 = n2;
        for (int i = 1; i < n2; ++i) {
            c = string.charAt(i);
            n3 = c | 0x20;
            if (!HgURL.isLegalLowercaseSchemeLetter(n3)) {
                n4 = i;
                break;
            }
            if (c != n3 && stringBuilder == null) {
                stringBuilder = new StringBuilder(n2);
                HgURL.appendLowercase(string, 1, i, stringBuilder);
            }
            if (stringBuilder == null) continue;
            stringBuilder.append(n3);
        }
        if (string.charAt(n4) != ':') {
            return null;
        }
        return stringBuilder == null ? string.substring(0, n4) : stringBuilder.toString();
    }

    private static boolean isLegalLowercaseSchemeLetter(int n) {
        return n >= 97 && n <= 122 || n >= 48 && n <= 57 || n == 43 || n == 45 || n == 46;
    }

    private static boolean isAsciiAlpha(char c) {
        return HgURL.isLowercaseAsciiAlpha(c | 0x20);
    }

    private static boolean isLowercaseAsciiAlpha(int n) {
        return n >= 97 && n <= 122;
    }

    private static boolean isSlash(char c) {
        return c == '/' || c == '\\';
    }

    private static void appendLowercase(String string, int n, int n2, StringBuilder stringBuilder) {
        for (int i = n; i < n2; ++i) {
            stringBuilder.append(string.charAt(i) | 0x20);
        }
    }

    private HgURL() {
        this.scheme = null;
        this.username = null;
        this.password = null;
        this.host = null;
        this.port = -1;
        this.path = null;
        this.rawPath = null;
        this.rawQuery = null;
        this.rawFragment = null;
    }

    public HgURL(File file) {
        this.scheme = Scheme.FILE;
        this.username = null;
        this.password = null;
        this.host = null;
        this.port = -1;
        this.path = file.toURI().getPath();
        this.rawPath = HgURL.makeRawPathInfo(this.path);
        this.rawQuery = null;
        this.rawFragment = null;
    }

    public HgURL(String string) throws URISyntaxException {
        this(string, null, null);
    }

    public HgURL(String string, String string2, String string3) throws URISyntaxException {
        String string4;
        URI uRI;
        if (string == null) {
            throw new IllegalArgumentException("<null> URL string");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("empty URL string");
        }
        if (HgURL.looksLikePlainFilePath(string)) {
            uRI = new File(string).toURI();
            this.scheme = Scheme.FILE;
        } else {
            uRI = new URI(string).parseServerAuthority();
            string4 = uRI.getScheme();
            Scheme scheme = this.scheme = string4 != null ? HgURL.determineScheme(string4) : null;
        }
        if (this.scheme == null) {
            throw new URISyntaxException(string, NbBundle.getMessage(HgURL.class, (String)"MSG_UNSUPPORTED_PROTOCOL", (Object)uRI.getScheme()));
        }
        HgURL.verifyUserInfoData(this.scheme, string2, string3);
        if (string2 != null) {
            this.username = string2;
            this.password = string3;
        } else {
            string4 = uRI.getRawUserInfo();
            if (string4 == null) {
                this.username = null;
                this.password = null;
            } else {
                int n = string4.indexOf(58);
                if (n == -1) {
                    this.username = string4;
                    this.password = null;
                } else {
                    this.username = string4.substring(0, n);
                    this.password = string4.substring(n + 1);
                }
            }
        }
        this.host = uRI.getHost();
        this.port = uRI.getPort();
        this.rawPath = uRI.getRawPath();
        this.rawQuery = uRI.getRawQuery();
        this.rawFragment = uRI.getRawFragment();
        this.path = uRI.getPath();
    }

    public static boolean looksLikePlainFilePath(String string) {
        if (string == null) {
            throw new IllegalArgumentException("<null> URL string");
        }
        if (string.length() == 0) {
            return false;
        }
        return string.charAt(0) == '/' || Utilities.isWindows() && HgURL.isWindowsAbsolutePath(string);
    }

    public static String stripUserInfo(String string) {
        if (string == null) {
            throw new IllegalArgumentException("<null> URL string");
        }
        if ((string = string.trim()).length() == 0) {
            return string;
        }
        try {
            HgURL hgURL = new HgURL(string);
            if (hgURL.isFile() && HgURL.looksLikePlainFilePath(string)) {
                return hgURL.toHgCommandUrlStringWithoutUserInfo();
            }
            return hgURL.toUrlStringWithoutUserInfo();
        }
        catch (URISyntaxException uRISyntaxException) {
            return HgURL.stripUserInfoFromInvalidURI(string);
        }
    }

    private static String stripUserInfoFromInvalidURI(String string) {
        if (HgURL.looksLikePlainFilePath(string) && !string.startsWith("//")) {
            return string;
        }
        String string2 = HgURL.getSchemeName(string, -1);
        String string3 = string2 != null ? string.substring(string2.length() + 1).trim() : string;
        int n = string3.lastIndexOf(64);
        if (n == -1) {
            return string;
        }
        String string4 = string3.substring(n + 1);
        if (string2 == null) {
            if (string3.startsWith("//")) {
                return "//" + string4;
            }
            return string4;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        stringBuilder.append(string2).append(':');
        if (string3.startsWith("//")) {
            stringBuilder.append("//");
        }
        stringBuilder.append(string4);
        return stringBuilder.toString();
    }

    private static String trimDupliciteInitialSlashes(String string) {
        int n;
        int n2 = string.length();
        if (n2 == 0) {
            return string;
        }
        String string2 = string;
        for (n = 0; n < n2 && string2.charAt(n) == '/'; ++n) {
        }
        if (n == 0 || n == 1) {
            return string;
        }
        return string.substring(n - 1);
    }

    private static Scheme determineScheme(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        for (Scheme scheme : Scheme.values()) {
            if (!scheme.name.equals(string)) continue;
            return scheme;
        }
        return null;
    }

    private static void verifyUserInfoData(Scheme scheme, String string, String string2) {
        boolean bl = scheme.supportsAuthentication();
        if (!(bl || string == null && string2 == null)) {
            throw new IllegalArgumentException("this URI does not support authentication, but username and/or password is specified");
        }
        if (string == null && string2 != null) {
            throw new IllegalArgumentException("username is unset but password is set");
        }
    }

    private static boolean isWindowsAbsolutePath(String string) {
        int n = string.length();
        if (n == 0) {
            return false;
        }
        int n2 = 0;
        if (HgURL.isSlash(string.charAt(n2))) {
            ++n2;
        }
        if (n <= n2 || !HgURL.isAsciiAlpha(string.charAt(n2++))) {
            return false;
        }
        if (n <= n2 || string.charAt(n2++) != ':') {
            return false;
        }
        return n > n2 && HgURL.isSlash(string.charAt(n2++));
    }

    public boolean isFile() {
        return this.scheme == Scheme.FILE;
    }

    public boolean isKenaiURL() {
        return HgKenaiSupport.getInstance().isKenai(this.toUrlStringWithoutUserInfo());
    }

    public String getProtocol() {
        return this.scheme.name();
    }

    public Scheme getScheme() {
        return this.scheme;
    }

    public String getPath() {
        return this.path;
    }

    public String getFilePath() {
        if (Utilities.isWindows() && HgURL.isWindowsAbsolutePath(this.path)) {
            return HgURL.getWindowsFilePath(this.path);
        }
        return this.path;
    }

    private static String getWindowsFilePath(String string) {
        if (HgURL.isSlash(string.charAt(0))) {
            string = string.substring(1);
        }
        return string.replace('/', '\\');
    }

    String getUsername() {
        return this.username;
    }

    String getPassword() {
        return this.password;
    }

    public String getUserInfo() {
        return this.getUserInfo(true);
    }

    String getUserInfo(boolean bl) {
        if (this.username == null) {
            return null;
        }
        if (this.password == null) {
            return this.username;
        }
        return bl ? this.username + ':' + PASSWORD_REPLACEMENT : this.username + ':' + this.password;
    }

    public boolean supportsAuthentication() {
        return this.scheme.supportsAuthentication();
    }

    public static File getFile(HgURL hgURL) {
        if (!hgURL.isFile()) {
            throw new IllegalArgumentException("The passed HgURL must represent a file.");
        }
        return new File(hgURL.getPath());
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        assert (this.getClass() == HgURL.class);
        if (object.getClass() != HgURL.class) {
            return false;
        }
        return ((HgURL)object).getUniqueIdentifier().equals(this.getUniqueIdentifier());
    }

    public int hashCode() {
        return this.getUniqueIdentifier().hashCode();
    }

    private Object getUniqueIdentifier() {
        return this.toHgCommandUrlString();
    }

    public String toString() {
        if (this.publicForm == null) {
            this.publicForm = this.toUrlString(false, true);
        }
        return this.publicForm;
    }

    public String toHgCommandUrlString() {
        if (this.hgCommandForm == null) {
            this.hgCommandForm = this.isFile() ? this.getFilePath() : this.toUrlString();
        }
        return this.hgCommandForm;
    }

    public String toHgCommandUrlStringWithoutUserInfo() {
        return this.isFile() ? this.getFilePath() : this.toUrlStringWithoutUserInfo();
    }

    public String toHgCommandStringWithMaskedPassword() {
        return this.isFile() ? this.getFilePath() : this.toUrlString(false, true);
    }

    public URL toURL() {
        String string = this.toCompleteUrlString();
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            assert (false) : malformedURLException.getMessage();
            return null;
        }
    }

    public String toCompleteUrlString() {
        return this.toUrlString();
    }

    public String toUrlString() {
        return this.toUrlString(false, false);
    }

    public String toUrlStringWithoutUserInfo() {
        return this.toUrlString(true, true);
    }

    private String toUrlString(boolean bl, boolean bl2) {
        if (this == NO_URL) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append(this.scheme.name).append(':');
        boolean bl3 = this.scheme != Scheme.FILE ? this.addAuthoritySpec(bl, bl2, stringBuilder) : false;
        if (this.rawPath != null && this.rawPath.length() != 0) {
            if (bl3 && this.rawPath.charAt(0) != '/') {
                stringBuilder.append('/');
            }
            stringBuilder.append(this.rawPath);
            bl3 = false;
        }
        if (this.rawQuery != null) {
            stringBuilder.append('?').append(this.rawQuery);
        }
        if (this.rawFragment != null) {
            stringBuilder.append('#').append(this.rawFragment);
        }
        return stringBuilder.toString();
    }

    public boolean addAuthoritySpec(boolean bl, boolean bl2, StringBuilder stringBuilder) {
        if (this.host == null) {
            return false;
        }
        stringBuilder.append("//");
        if (!bl && this.username != null) {
            stringBuilder.append(HgURL.makeRawUserInfo(this.username));
            if (this.password != null) {
                stringBuilder.append(':');
                if (bl2) {
                    stringBuilder.append(PASSWORD_REPLACEMENT);
                } else {
                    stringBuilder.append(HgURL.makeRawUserInfo(this.password));
                }
            }
            stringBuilder.append('@');
        }
        stringBuilder.append(this.host);
        if (this.port != -1) {
            stringBuilder.append(':').append(this.port);
        }
        return true;
    }

    private static String makeRawUserInfo(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length() + 10);
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (HgURL.isLegalUserInfoChar(c)) {
                stringBuilder.append(c);
                continue;
            }
            HgURL.appendEncoded(c, stringBuilder);
        }
        return stringBuilder.toString();
    }

    private static String makeRawPathInfo(String string) {
        char c;
        int n;
        int n2 = string.length();
        if (n2 == 0) {
            return string;
        }
        for (n = 0; n < n2 && HgURL.isLegalPathChar(c = string.charAt(n)); ++n) {
        }
        if (n == n2) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() + 20);
        if (n != 0) {
            stringBuilder.append(string.substring(0, n));
        }
        assert (!HgURL.isLegalPathChar(string.charAt(n)));
        HgURL.appendEncoded(string.charAt(n++), stringBuilder);
        while (n < n2) {
            char c2 = string.charAt(n);
            if (HgURL.isLegalPathChar(c2)) {
                stringBuilder.append(c2);
            } else {
                HgURL.appendEncoded(c2, stringBuilder);
            }
            ++n;
        }
        return stringBuilder.toString();
    }

    private static boolean isLegalUserInfoChar(char c) {
        return HgURL.isAlnumChar(c) || "-_.!~*'();&=+$,".indexOf(c) != -1;
    }

    private static boolean isLegalPathChar(char c) {
        return HgURL.isAlnumChar(c) || "/-_.!~*'():@&=+$,".indexOf(c) != -1;
    }

    private static boolean isAlnumChar(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9';
    }

    private static void appendEncoded(int n, StringBuilder stringBuilder) {
        if (n < 128) {
            HgURL.appendEncodedByte(n & 0x7F, stringBuilder);
        } else if (n < 2048) {
            HgURL.appendEncodedByte(0xC0 | (n & 0x7C0) >>> 6, stringBuilder);
            HgURL.appendEncodedByte(0x80 | n & 0x3F, stringBuilder);
        } else if (n < 65536) {
            HgURL.appendEncodedByte(0xE0 | (n & 0xF000) >>> 12, stringBuilder);
            HgURL.appendEncodedByte(0x80 | (n & 0xFC0) >>> 6, stringBuilder);
            HgURL.appendEncodedByte(0x80 | n & 0x3F, stringBuilder);
        } else {
            HgURL.appendEncodedByte(0xF0 | (n & 0x1C0000) >>> 18, stringBuilder);
            HgURL.appendEncodedByte(0x80 | (n & 0x3F000) >>> 12, stringBuilder);
            HgURL.appendEncodedByte(0x80 | (n & 0xFC0) >>> 6, stringBuilder);
            HgURL.appendEncodedByte(0x80 | n & 0x3F, stringBuilder);
        }
    }

    private static void appendEncodedByte(int n, StringBuilder stringBuilder) {
        assert (n < 256);
        stringBuilder.append('%');
        stringBuilder.append(hexadecimalChars.charAt((n & 0xF0) >>> 4));
        stringBuilder.append(hexadecimalChars.charAt(n & 0xF));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Scheme {
        FILE("file", false),
        HTTP("http", true),
        HTTPS("https", true),
        STATIC_HTTP("static-http", true),
        SSH("ssh", true);

        private static int longestSchemeName;
        private final String name;
        private final boolean supportsAuthentication;

        private Scheme(String string2, boolean bl) {
            this.name = string2;
            this.supportsAuthentication = bl;
        }

        public static int getMaxSchemeNameLength() {
            if (longestSchemeName == 0) {
                for (Scheme scheme : Scheme.values()) {
                    longestSchemeName = Math.max(scheme.name.length(), longestSchemeName);
                }
            }
            return longestSchemeName;
        }

        public String toString() {
            return this.name;
        }

        public boolean supportsAuthentication() {
            return this.supportsAuthentication;
        }
    }
}

