/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.commit;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Set;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.util.RequestProcessor;

public final class ExcludeFromCommitAction
extends ContextAction {
    public static final int UNDEFINED = -1;
    public static final int EXCLUDING = 1;
    public static final int INCLUDING = 2;
    private final VCSContext context;

    public ExcludeFromCommitAction(String string, VCSContext vCSContext) {
        this.context = vCSContext;
        this.putValue("Name", string);
    }

    protected boolean enable(VCSContext vCSContext) {
        return this.getActionStatus(vCSContext) != -1;
    }

    protected int getFileEnabledStatus() {
        return 6612;
    }

    protected int getDirectoryEnabledStatus() {
        return 6612;
    }

    protected String getBaseName(VCSContext vCSContext) {
        int n = this.getActionStatus(vCSContext);
        switch (n) {
            case -1: 
            case 1: {
                return "popup_commit_exclude";
            }
            case 2: {
                return "popup_commit_include";
            }
        }
        throw new RuntimeException("Invalid action status: " + n);
    }

    public int getActionStatus(VCSContext vCSContext) {
        HgModuleConfig hgModuleConfig = HgModuleConfig.getDefault();
        int n = -1;
        if (vCSContext == null) {
            vCSContext = this.context;
        }
        Set set = vCSContext.getRootFiles();
        for (File file : set) {
            if (hgModuleConfig.isExcludedFromCommit(file.getAbsolutePath())) {
                if (n == 1) {
                    return -1;
                }
                n = 2;
                continue;
            }
            if (n == 2) {
                return -1;
            }
            n = 1;
        }
        return n;
    }

    public void performAction(ActionEvent actionEvent) {
        final VCSContext vCSContext = this.context;
        RequestProcessor requestProcessor = Mercurial.getInstance().getRequestProcessor();
        HgProgressSupport hgProgressSupport = new HgProgressSupport(){

            public void perform() {
                HgModuleConfig hgModuleConfig = HgModuleConfig.getDefault();
                int n = ExcludeFromCommitAction.this.getActionStatus(vCSContext);
                Set set = vCSContext.getRootFiles();
                ArrayList<String> arrayList = new ArrayList<String>(set.size());
                for (File file : set) {
                    arrayList.add(file.getAbsolutePath());
                }
                if (this.isCanceled()) {
                    return;
                }
                if (n != 2) {
                    hgModuleConfig.addExclusionPaths(arrayList);
                } else {
                    hgModuleConfig.removeExclusionPaths(arrayList);
                }
            }
        };
        hgProgressSupport.start(requestProcessor, "");
    }
}

