/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.options;

import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.options.PropertiesPanel;
import org.netbeans.modules.mercurial.options.PropertiesTable;
import org.netbeans.modules.mercurial.ui.properties.HgPropertiesNode;
import org.netbeans.modules.mercurial.ui.repository.HgURL;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class HgExtProperties
implements ActionListener,
DocumentListener {
    private PropertiesPanel panel;
    private File root;
    private PropertiesTable propTable;
    private HgProgressSupport support;
    private File loadedValueFile;
    private Font fontTextArea;

    public HgExtProperties(PropertiesPanel propertiesPanel, PropertiesTable propertiesTable, File file) {
        this.panel = propertiesPanel;
        this.propTable = propertiesTable;
        this.root = file;
        propertiesPanel.getTxtAreaValue().getDocument().addDocumentListener(this);
        ((JTextField)propertiesPanel.getComboName().getEditor().getEditorComponent()).getDocument().addDocumentListener(this);
        propertiesTable.getTable().addMouseListener(new TableMouseListener());
        propertiesPanel.getBtnAdd().addActionListener(this);
        propertiesPanel.getBtnRemove().addActionListener(this);
        propertiesPanel.getComboName().setEditable(true);
        propertiesPanel.getBtnAdd().setEnabled(false);
        this.initPropertyNameCbx();
        this.refreshProperties();
    }

    public PropertiesPanel getPropertiesPanel() {
        return this.panel;
    }

    public void setPropertiesPanel(PropertiesPanel propertiesPanel) {
        this.panel = propertiesPanel;
    }

    public File getRoot() {
        return this.root;
    }

    public void setRoot(File file) {
        this.root = file;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.panel.getBtnAdd())) {
            this.addProperty();
        }
        if (object.equals(this.panel.getBtnRemove())) {
            this.removeProperties();
        }
    }

    protected void initPropertyNameCbx() {
        ArrayList arrayList = new ArrayList(8);
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel(new Vector(arrayList));
        this.panel.getComboName().setModel(defaultComboBoxModel);
        this.panel.getComboName().getEditor().setItem("");
    }

    protected String getPropertyValue() {
        return this.panel.getTxtAreaValue().getText();
    }

    protected String getPropertyName() {
        Object object = this.panel.getComboName().getSelectedObjects()[0];
        if (object == null) {
            return this.panel.getComboName().getEditor().getItem().toString().trim();
        }
        return object.toString().trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperties() {
        RequestProcessor requestProcessor = Mercurial.getInstance().getRequestProcessor();
        try {
            this.support = new HgProgressSupport(){

                protected void perform() {
                    Properties properties = HgModuleConfig.getDefault().getProperties(HgExtProperties.this.root, "extensions");
                    HgPropertiesNode[] hgPropertiesNodeArray = new HgPropertiesNode[properties.size()];
                    int n = 0;
                    Enumeration<?> enumeration = properties.propertyNames();
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        String string2 = properties.getProperty(string);
                        String string3 = string2 != null ? string2 : "";
                        hgPropertiesNodeArray[n] = new HgPropertiesNode(string, string3);
                        ++n;
                    }
                    HgExtProperties.this.propTable.setNodes(hgPropertiesNodeArray);
                    HgExtProperties.this.setSelected(0);
                    HgExtProperties.this.propTable.getTable().getSelectionModel().setSelectionInterval(0, 0);
                }
            };
            this.support.start(requestProcessor, (HgURL)null, NbBundle.getMessage(HgExtProperties.class, (String)"LBL_Properties_Progress"));
        }
        finally {
            this.support = null;
        }
    }

    private boolean addProperty(String string, String string2) {
        HgPropertiesNode[] hgPropertiesNodeArray = this.propTable.getNodes();
        for (int i = 0; i < hgPropertiesNodeArray.length; ++i) {
            String string3 = hgPropertiesNodeArray[this.propTable.getModelIndex(i)].getName();
            if (!string3.equals(string)) continue;
            hgPropertiesNodeArray[this.propTable.getModelIndex(i)].setValue(string2);
            this.propTable.setNodes(hgPropertiesNodeArray);
            return true;
        }
        HgPropertiesNode[] hgPropertiesNodeArray2 = new HgPropertiesNode[hgPropertiesNodeArray.length + 1];
        for (int i = 0; i < hgPropertiesNodeArray.length; ++i) {
            hgPropertiesNodeArray2[i] = hgPropertiesNodeArray[i];
        }
        hgPropertiesNodeArray2[hgPropertiesNodeArray.length] = new HgPropertiesNode(string, string2);
        this.propTable.setNodes(hgPropertiesNodeArray2);
        return true;
    }

    public void addProperty() {
        if (this.addProperty(this.getPropertyName(), this.getPropertyValue())) {
            this.panel.getComboName().getEditor().setItem("");
            this.panel.getTxtAreaValue().setText("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperties() {
        RequestProcessor requestProcessor = Mercurial.getInstance().getRequestProcessor();
        try {
            this.support = new HgProgressSupport(){

                protected void perform() {
                    try {
                        HgModuleConfig.getDefault().clearProperties(HgExtProperties.this.root, "extensions");
                        HgPropertiesNode[] hgPropertiesNodeArray = HgExtProperties.this.propTable.getNodes();
                        for (int i = 0; i < hgPropertiesNodeArray.length; ++i) {
                            String string = hgPropertiesNodeArray[HgExtProperties.this.propTable.getModelIndex(i)].getName();
                            String string2 = hgPropertiesNodeArray[HgExtProperties.this.propTable.getModelIndex(i)].getValue();
                            HgModuleConfig.getDefault().setProperty(HgExtProperties.this.root, "extensions", string, string2, true);
                        }
                    }
                    catch (IOException iOException) {
                        HgModuleConfig.notifyParsingError();
                    }
                }
            };
            this.support.start(requestProcessor, (HgURL)null, NbBundle.getMessage(HgExtProperties.class, (String)"LBL_Properties_Progress"));
        }
        finally {
            this.support = null;
        }
    }

    public void removeProperties() {
        int n;
        int[] nArray = this.propTable.getSelectedItems();
        if (nArray.length == 0) {
            return;
        }
        HgPropertiesNode[] hgPropertiesNodeArray = this.propTable.getNodes();
        if (hgPropertiesNodeArray.length == 0) {
            return;
        }
        HgPropertiesNode[] hgPropertiesNodeArray2 = new HgPropertiesNode[hgPropertiesNodeArray.length - nArray.length];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = this.propTable.getModelIndex(nArray[n]);
        }
        n = 0;
        int n2 = 0;
        for (int i = 0; i < hgPropertiesNodeArray.length; ++i) {
            if (i != nArray[n]) {
                hgPropertiesNodeArray2[n2++] = hgPropertiesNodeArray[i];
                continue;
            }
            if (n >= nArray.length - 1) continue;
            ++n;
        }
        this.propTable.setNodes(hgPropertiesNodeArray2);
        this.panel.getComboName().getEditor().setItem("");
        this.panel.getTxtAreaValue().setText("");
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.validateUserInput(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.validateUserInput(documentEvent);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.validateUserInput(documentEvent);
    }

    private void validateUserInput(DocumentEvent documentEvent) {
        Document document = documentEvent.getDocument();
        String string = this.panel.getComboName().getEditor().getItem().toString().trim();
        String string2 = this.panel.getTxtAreaValue().getText().trim();
        if (string.length() == 0 || string.indexOf(" ") > 0) {
            this.panel.getBtnAdd().setEnabled(false);
        } else {
            this.panel.getBtnAdd().setEnabled(true);
        }
    }

    private void setSelected(int n) {
        HgPropertiesNode[] hgPropertiesNodeArray = this.propTable.getNodes();
        if (hgPropertiesNodeArray == null || hgPropertiesNodeArray.length == 0 || n < 0) {
            return;
        }
        final String string = hgPropertiesNodeArray[this.propTable.getModelIndex(n)].getName();
        final String string2 = hgPropertiesNodeArray[this.propTable.getModelIndex(n)].getValue();
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
                linkedHashSet.add(string);
                DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel(new Vector(linkedHashSet));
                HgExtProperties.this.panel.getComboName().setModel(defaultComboBoxModel);
                HgExtProperties.this.panel.getTxtAreaValue().setText(string2);
            }
        });
    }

    public class TableMouseListener
    extends MouseAdapter {
        public void mouseClicked(MouseEvent mouseEvent) {
            int[] nArray;
            if (mouseEvent.getClickCount() == 1 && (nArray = HgExtProperties.this.propTable.getSelectedItems()) != null && nArray.length > 0) {
                HgExtProperties.this.setSelected(nArray[0]);
            }
        }
    }
}

