/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.diff.builtin;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.diff.builtin.Base64;
import org.netbeans.modules.diff.builtin.Hunk;
import org.netbeans.modules.diff.builtin.PatchException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ContextualPatch {
    public static final String MAGIC = "# This patch file was generated by NetBeans IDE";
    private final Pattern unifiedRangePattern = Pattern.compile("@@ -(\\d+)(,\\d+)? \\+(\\d+)(,\\d+)? @@(\\s.*)?");
    private final Pattern baseRangePattern = Pattern.compile("\\*\\*\\* (\\d+)(,\\d+)? \\*\\*\\*\\*");
    private final Pattern modifiedRangePattern = Pattern.compile("--- (\\d+)(,\\d+)? ----");
    private final Pattern normalChangeRangePattern = Pattern.compile("(\\d+)(,(\\d+))?c(\\d+)(,(\\d+))?");
    private final Pattern normalAddRangePattern = Pattern.compile("(\\d+)a(\\d+),(\\d+)");
    private final Pattern normalDeleteRangePattern = Pattern.compile("(\\d+),(\\d+)d(\\d+)");
    private final Pattern binaryHeaderPattern = Pattern.compile("MIME: (.*?); encoding: (.*?); length: (-?\\d+?)");
    private final File patchFile;
    private final File suggestedContext;
    private File context;
    private BufferedReader patchReader;
    private String patchLine;
    private boolean patchLineRead;
    private int lastPatchedLine;

    public static ContextualPatch create(File file, File file2) {
        return new ContextualPatch(file, file2);
    }

    private ContextualPatch(File file, File file2) {
        this.patchFile = file;
        this.suggestedContext = file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PatchReport> patch(boolean bl) throws PatchException, IOException {
        ArrayList<PatchReport> arrayList = new ArrayList<PatchReport>();
        this.init();
        try {
            ArrayList<PatchReport> arrayList2;
            this.patchLine = this.patchReader.readLine();
            ArrayList<SinglePatch> arrayList3 = new ArrayList<SinglePatch>();
            while ((arrayList2 = this.getNextPatch()) != null) {
                arrayList3.add((SinglePatch)((Object)arrayList2));
            }
            this.computeContext(arrayList3);
            for (SinglePatch singlePatch : arrayList3) {
                try {
                    this.applyPatch(singlePatch, bl);
                    arrayList.add(new PatchReport(singlePatch.targetFile, this.computeBackup(singlePatch.targetFile), singlePatch.binary, PatchStatus.Patched, null));
                }
                catch (Exception exception) {
                    arrayList.add(new PatchReport(singlePatch.targetFile, null, singlePatch.binary, PatchStatus.Failure, exception));
                }
            }
            arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            if (this.patchReader != null) {
                try {
                    this.patchReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void init() throws IOException {
        this.patchReader = new BufferedReader(new FileReader(this.patchFile));
        String string = "ISO-8859-1";
        String string2 = this.patchReader.readLine();
        if (MAGIC.equals(string2)) {
            string = "utf8";
            string2 = this.patchReader.readLine();
        }
        this.patchReader.close();
        byte[] byArray = new byte[MAGIC.length()];
        FileInputStream fileInputStream = new FileInputStream(this.patchFile);
        int n = ((InputStream)fileInputStream).read(byArray);
        ((InputStream)fileInputStream).close();
        if (n != -1 && MAGIC.equals(new String(byArray, "utf8"))) {
            string = "utf8";
        }
        this.patchReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.patchFile), string));
    }

    private void applyPatch(SinglePatch singlePatch, boolean bl) throws IOException, PatchException {
        List<Object> list;
        this.lastPatchedLine = 1;
        singlePatch.targetFile = this.computeTargetFile(singlePatch);
        if (singlePatch.targetFile.exists() && !singlePatch.binary) {
            list = this.readFile(singlePatch.targetFile);
            if (this.patchCreatesNewFileThatAlreadyExists(singlePatch, list)) {
                return;
            }
        } else {
            list = new ArrayList();
        }
        if (!singlePatch.binary) {
            for (Hunk hunk : singlePatch.hunks) {
                this.applyHunk(list, hunk);
            }
        }
        if (!bl) {
            this.backup(singlePatch.targetFile);
            this.writeFile(singlePatch, list);
        }
    }

    private boolean patchCreatesNewFileThatAlreadyExists(SinglePatch singlePatch, List<String> list) throws PatchException {
        if (singlePatch.hunks.length != 1) {
            return false;
        }
        Hunk hunk = singlePatch.hunks[0];
        if (hunk.baseStart != 0 || hunk.baseCount != 0 || hunk.modifiedStart != 1 || hunk.modifiedCount != list.size()) {
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>(hunk.modifiedCount);
        this.applyHunk(arrayList, hunk);
        return ((Object)arrayList).equals(list);
    }

    private void backup(File file) throws IOException {
        if (file.exists()) {
            this.copyStreamsCloseAll(new FileOutputStream(this.computeBackup(file)), new FileInputStream(file));
        }
    }

    private File computeBackup(File file) {
        return new File(file.getParentFile(), file.getName() + ".original~");
    }

    private void copyStreamsCloseAll(OutputStream outputStream, InputStream inputStream) throws IOException {
        int n;
        byte[] byArray = new byte[4096];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
        outputStream.close();
        inputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(SinglePatch singlePatch, List<String> list) throws IOException {
        singlePatch.targetFile.getParentFile().mkdirs();
        FileObject fileObject = FileUtil.toFileObject((File)singlePatch.targetFile);
        if (fileObject == null) {
            fileObject = FileUtil.createData((File)singlePatch.targetFile);
        }
        if (fileObject == null) {
            return;
        }
        if (singlePatch.binary) {
            if (singlePatch.hunks.length == 0) {
                fileObject.delete();
            } else {
                byte[] byArray = Base64.decode(singlePatch.hunks[0].lines);
                this.copyStreamsCloseAll(fileObject.getOutputStream(), new ByteArrayInputStream(byArray));
            }
        } else {
            Charset charset = this.getEncoding(singlePatch.targetFile);
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(fileObject.getOutputStream(), charset));
            try {
                if (list.size() == 0) {
                    return;
                }
                for (String string : list.subList(0, list.size() - 1)) {
                    printWriter.println(string);
                }
                printWriter.print(list.get(list.size() - 1));
                if (!singlePatch.noEndingNewline) {
                    printWriter.println();
                }
            }
            finally {
                printWriter.close();
            }
        }
    }

    private void applyHunk(List<String> list, Hunk hunk) throws PatchException {
        int n = this.findHunkIndex(list, hunk);
        if (n == -1) {
            throw new PatchException("Cannot apply hunk @@ " + hunk.baseCount);
        }
        this.applyHunk(list, hunk, n, false);
    }

    private int findHunkIndex(List<String> list, Hunk hunk) throws PatchException {
        int n;
        int n2 = hunk.modifiedStart;
        if (n2 >= this.lastPatchedLine && this.applyHunk(list, hunk, n2, true)) {
            return n2;
        }
        for (n = n2 - 1; n >= this.lastPatchedLine; --n) {
            if (!this.applyHunk(list, hunk, n, true)) continue;
            return n;
        }
        for (n = n2 + 1; n < list.size(); ++n) {
            if (!this.applyHunk(list, hunk, n, true)) continue;
            return n;
        }
        return -1;
    }

    private boolean applyHunk(List<String> list, Hunk hunk, int n, boolean bl) throws PatchException {
        --n;
        for (String string : hunk.lines) {
            String string2;
            boolean bl2 = this.isAdditionLine(string);
            if (!bl2 && !(string2 = list.get(n).trim()).equals(string.substring(1).trim())) {
                if (bl) {
                    return false;
                }
                throw new PatchException("Unapplicable hunk @@ " + hunk.baseStart);
            }
            if (bl) {
                if (bl2) {
                    --n;
                }
            } else if (bl2) {
                list.add(n, string.substring(1));
            } else if (this.isRemovalLine(string)) {
                list.remove(n);
                --n;
            }
            ++n;
        }
        this.lastPatchedLine = ++n;
        return true;
    }

    private boolean isAdditionLine(String string) {
        return string.charAt(0) == '+';
    }

    private boolean isRemovalLine(String string) {
        return string.charAt(0) == '-';
    }

    private Charset getEncoding(File file) {
        try {
            return FileEncodingQuery.getEncoding((FileObject)FileUtil.toFileObject((File)file));
        }
        catch (Throwable throwable) {
            return Charset.defaultCharset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> readFile(File file) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), this.getEncoding(file)));
        if (bufferedReader == null) {
            bufferedReader = new BufferedReader(new FileReader(file));
        }
        try {
            String string;
            ArrayList<String> arrayList = new ArrayList<String>();
            while ((string = bufferedReader.readLine()) != null) {
                arrayList.add(string);
            }
            ArrayList<String> arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private SinglePatch getNextPatch() throws IOException, PatchException {
        SinglePatch singlePatch;
        block6: {
            singlePatch = new SinglePatch();
            while (true) {
                String string;
                if ((string = this.readPatchLine()) == null) {
                    return null;
                }
                if (string.startsWith("Index:")) {
                    singlePatch.targetPath = string.substring(6).trim();
                    continue;
                }
                if (string.startsWith("MIME: application/octet-stream;")) {
                    this.unreadPatchLine();
                    this.readBinaryPatchContent(singlePatch);
                    break block6;
                }
                if (string.startsWith("--- ")) {
                    this.unreadPatchLine();
                    this.readPatchContent(singlePatch);
                    break block6;
                }
                if (string.startsWith("*** ")) {
                    this.unreadPatchLine();
                    this.readContextPatchContent(singlePatch);
                    break block6;
                }
                if (this.isNormalDiffRange(string)) break;
            }
            this.unreadPatchLine();
            this.readNormalPatchContent(singlePatch);
        }
        return singlePatch;
    }

    private boolean isNormalDiffRange(String string) {
        return this.normalAddRangePattern.matcher(string).matches() || this.normalChangeRangePattern.matcher(string).matches() || this.normalDeleteRangePattern.matcher(string).matches();
    }

    private void readBinaryPatchContent(SinglePatch singlePatch) throws PatchException, IOException {
        ArrayList<Hunk> arrayList = new ArrayList<Hunk>();
        Hunk hunk = new Hunk();
        while (true) {
            String string;
            if ((string = this.readPatchLine()) == null || string.startsWith("Index:") || string.length() == 0) {
                this.unreadPatchLine();
                break;
            }
            if (singlePatch.binary) {
                hunk.lines.add(string);
                continue;
            }
            Matcher matcher = this.binaryHeaderPattern.matcher(string);
            if (!matcher.matches()) continue;
            singlePatch.binary = true;
            int n = Integer.parseInt(matcher.group(3));
            if (n == -1) break;
            arrayList.add(hunk);
        }
        singlePatch.hunks = arrayList.toArray(new Hunk[arrayList.size()]);
    }

    private void readNormalPatchContent(SinglePatch singlePatch) throws IOException, PatchException {
        ArrayList<Hunk> arrayList;
        block6: {
            String string;
            arrayList = new ArrayList<Hunk>();
            Hunk hunk = null;
            while (true) {
                if ((string = this.readPatchLine()) == null || string.startsWith("Index:")) break block6;
                Matcher matcher = this.normalAddRangePattern.matcher(string);
                if (matcher.matches()) {
                    hunk = new Hunk();
                    arrayList.add(hunk);
                    this.parseNormalRange(hunk, matcher);
                    continue;
                }
                matcher = this.normalChangeRangePattern.matcher(string);
                if (matcher.matches()) {
                    hunk = new Hunk();
                    arrayList.add(hunk);
                    this.parseNormalRange(hunk, matcher);
                    continue;
                }
                matcher = this.normalDeleteRangePattern.matcher(string);
                if (matcher.matches()) {
                    hunk = new Hunk();
                    arrayList.add(hunk);
                    this.parseNormalRange(hunk, matcher);
                    continue;
                }
                if (string.startsWith("> ")) {
                    hunk.lines.add("+" + string.substring(2));
                    continue;
                }
                if (string.startsWith("< ")) {
                    hunk.lines.add("-" + string.substring(2));
                    continue;
                }
                if (!string.startsWith("---")) break;
            }
            throw new PatchException("Invalid hunk line: " + string);
        }
        this.unreadPatchLine();
        singlePatch.hunks = arrayList.toArray(new Hunk[arrayList.size()]);
    }

    private void parseNormalRange(Hunk hunk, Matcher matcher) {
        if (matcher.pattern() == this.normalAddRangePattern) {
            hunk.baseStart = Integer.parseInt(matcher.group(1));
            hunk.baseCount = 0;
            hunk.modifiedStart = Integer.parseInt(matcher.group(2));
            hunk.modifiedCount = Integer.parseInt(matcher.group(3)) - hunk.modifiedStart + 1;
        } else if (matcher.pattern() == this.normalDeleteRangePattern) {
            hunk.baseStart = Integer.parseInt(matcher.group(1));
            hunk.baseCount = Integer.parseInt(matcher.group(2)) - hunk.baseStart + 1;
            hunk.modifiedStart = Integer.parseInt(matcher.group(3));
            hunk.modifiedCount = 0;
        } else {
            hunk.baseStart = Integer.parseInt(matcher.group(1));
            hunk.baseCount = matcher.group(3) != null ? Integer.parseInt(matcher.group(3)) - hunk.baseStart + 1 : 1;
            hunk.modifiedStart = Integer.parseInt(matcher.group(4));
            hunk.modifiedCount = matcher.group(6) != null ? Integer.parseInt(matcher.group(6)) - hunk.modifiedStart + 1 : 1;
        }
    }

    private void readContextPatchContent(SinglePatch singlePatch) throws IOException, PatchException {
        ArrayList<Hunk> arrayList;
        block6: {
            String string;
            String string2 = this.readPatchLine();
            if (string2 == null || !string2.startsWith("*** ")) {
                throw new PatchException("Invalid context diff header: " + string2);
            }
            String string3 = this.readPatchLine();
            if (string3 == null || !string3.startsWith("--- ")) {
                throw new PatchException("Invalid context diff header: " + string3);
            }
            if (singlePatch.targetPath == null) {
                this.computeTargetPath(string2, string3, singlePatch);
            }
            arrayList = new ArrayList<Hunk>();
            Hunk hunk = null;
            int n = -1;
            while (true) {
                if ((string = this.readPatchLine()) == null || string.length() == 0 || string.startsWith("Index:")) break block6;
                if (string.startsWith("***************")) {
                    hunk = new Hunk();
                    this.parseContextRange(hunk, this.readPatchLine());
                    arrayList.add(hunk);
                    continue;
                }
                if (string.startsWith("--- ")) {
                    n = 0;
                    this.parseContextRange(hunk, string);
                    hunk.lines.add(string);
                    continue;
                }
                char c = string.charAt(0);
                if (c != ' ' && c != '+' && c != '-' && c != '!') break;
                if (n >= hunk.modifiedCount) continue;
                hunk.lines.add(string);
                if (n == -1) continue;
                ++n;
            }
            throw new PatchException("Invalid hunk line: " + string);
        }
        this.unreadPatchLine();
        singlePatch.hunks = arrayList.toArray(new Hunk[arrayList.size()]);
        this.convertContextToUnified(singlePatch);
    }

    private void convertContextToUnified(SinglePatch singlePatch) throws PatchException {
        Hunk[] hunkArray = new Hunk[singlePatch.hunks.length];
        int n = 0;
        for (Hunk hunk : singlePatch.hunks) {
            hunkArray[n++] = this.convertContextToUnified(hunk);
        }
        singlePatch.hunks = hunkArray;
    }

    private Hunk convertContextToUnified(Hunk hunk) throws PatchException {
        int n;
        Hunk hunk2 = new Hunk();
        hunk2.baseStart = hunk.baseStart;
        hunk2.modifiedStart = hunk.modifiedStart;
        int n2 = -1;
        for (n = 0; n < hunk.lines.size(); ++n) {
            if (!hunk.lines.get(n).startsWith("--- ")) continue;
            n2 = n;
            break;
        }
        if (n2 == -1) {
            throw new PatchException("Missing split divider in context patch");
        }
        n = 0;
        int n3 = n2 + 1;
        ArrayList<String> arrayList = new ArrayList<String>(hunk.lines.size());
        while (n < n2 || n3 < hunk.lines.size()) {
            String string;
            String string2 = n < n2 ? hunk.lines.get(n) : "~";
            String string3 = string = n3 < hunk.lines.size() ? hunk.lines.get(n3) : "~";
            if (string2.startsWith("- ")) {
                arrayList.add("-" + string2.substring(2));
                ++hunk2.baseCount;
                ++n;
                continue;
            }
            if (string.startsWith("+ ")) {
                arrayList.add("+" + string.substring(2));
                ++hunk2.modifiedCount;
                ++n3;
                continue;
            }
            if (string2.startsWith("! ")) {
                arrayList.add("-" + string2.substring(2));
                ++hunk2.baseCount;
                ++n;
                continue;
            }
            if (string.startsWith("! ")) {
                arrayList.add("+" + string.substring(2));
                ++hunk2.modifiedCount;
                ++n3;
                continue;
            }
            if (string2.startsWith("  ") && string.startsWith("  ")) {
                arrayList.add(string2.substring(1));
                ++hunk2.baseCount;
                ++hunk2.modifiedCount;
                ++n;
                ++n3;
                continue;
            }
            if (string2.startsWith("  ")) {
                arrayList.add(string2.substring(1));
                ++hunk2.baseCount;
                ++hunk2.modifiedCount;
                ++n;
                continue;
            }
            if (string.startsWith("  ")) {
                arrayList.add(string.substring(1));
                ++hunk2.baseCount;
                ++hunk2.modifiedCount;
                ++n3;
                continue;
            }
            throw new PatchException("Invalid context patch: " + string2);
        }
        hunk2.lines = arrayList;
        return hunk2;
    }

    private void readPatchContent(SinglePatch singlePatch) throws IOException, PatchException {
        ArrayList<Hunk> arrayList;
        block7: {
            String string = this.readPatchLine();
            if (string == null || !string.startsWith("--- ")) {
                throw new PatchException("Invalid unified diff header: " + string);
            }
            String string2 = this.readPatchLine();
            if (string2 == null || !string2.startsWith("+++ ")) {
                throw new PatchException("Invalid unified diff header: " + string2);
            }
            if (singlePatch.targetPath == null) {
                this.computeTargetPath(string, string2, singlePatch);
            }
            arrayList = new ArrayList<Hunk>();
            Hunk hunk = null;
            while (true) {
                String string3;
                if ((string3 = this.readPatchLine()) == null || string3.length() == 0 || string3.startsWith("Index:")) {
                    this.unreadPatchLine();
                    break block7;
                }
                char c = string3.charAt(0);
                if (c == '@') {
                    hunk = new Hunk();
                    this.parseRange(hunk, string3);
                    arrayList.add(hunk);
                    continue;
                }
                if (c == ' ' || c == '+' || c == '-') {
                    hunk.lines.add(string3);
                    continue;
                }
                if (!string3.equals("\\ No newline at end of file")) break;
                singlePatch.noEndingNewline = true;
            }
            this.unreadPatchLine();
        }
        singlePatch.hunks = arrayList.toArray(new Hunk[arrayList.size()]);
    }

    private void computeTargetPath(String string, String string2, SinglePatch singlePatch) {
        int n;
        string = string.substring("+++ ".length());
        string2 = string2.substring("--- ".length());
        if (string.startsWith("a/") && string2.startsWith("b/")) {
            string = string.substring(2);
        }
        if ((n = string.indexOf(9)) == -1) {
            n = string.length();
        }
        singlePatch.targetPath = string.substring(0, n).trim();
    }

    private void parseRange(Hunk hunk, String string) throws PatchException {
        Matcher matcher = this.unifiedRangePattern.matcher(string);
        if (!matcher.matches()) {
            throw new PatchException("Invalid unified diff range: " + string);
        }
        hunk.baseStart = Integer.parseInt(matcher.group(1));
        hunk.baseCount = matcher.group(2) != null ? Integer.parseInt(matcher.group(2).substring(1)) : 1;
        hunk.modifiedStart = Integer.parseInt(matcher.group(3));
        hunk.modifiedCount = matcher.group(4) != null ? Integer.parseInt(matcher.group(4).substring(1)) : 1;
    }

    private void parseContextRange(Hunk hunk, String string) throws PatchException {
        if (string.charAt(0) == '*') {
            Matcher matcher = this.baseRangePattern.matcher(string);
            if (!matcher.matches()) {
                throw new PatchException("Invalid context diff range: " + string);
            }
            hunk.baseStart = Integer.parseInt(matcher.group(1));
            hunk.baseCount = matcher.group(2) != null ? Integer.parseInt(matcher.group(2).substring(1)) : 1;
            hunk.baseCount -= hunk.baseStart - 1;
        } else {
            Matcher matcher = this.modifiedRangePattern.matcher(string);
            if (!matcher.matches()) {
                throw new PatchException("Invalid context diff range: " + string);
            }
            hunk.modifiedStart = Integer.parseInt(matcher.group(1));
            hunk.modifiedCount = matcher.group(2) != null ? Integer.parseInt(matcher.group(2).substring(1)) : 1;
            hunk.modifiedCount -= hunk.modifiedStart - 1;
        }
    }

    private String readPatchLine() throws IOException {
        if (this.patchLineRead) {
            this.patchLine = this.patchReader.readLine();
        } else {
            this.patchLineRead = true;
        }
        return this.patchLine;
    }

    private void unreadPatchLine() {
        this.patchLineRead = false;
    }

    private void computeContext(List<SinglePatch> list) {
        File file = this.suggestedContext;
        int n = 0;
        this.context = this.suggestedContext;
        while (this.context != null) {
            int n2 = 0;
            for (SinglePatch singlePatch : list) {
                try {
                    this.applyPatch(singlePatch, true);
                    ++n2;
                }
                catch (Exception exception) {}
            }
            if (n2 > n) {
                n = n2;
                file = this.context;
                if (n2 == list.size()) break;
            }
            this.context = this.context.getParentFile();
        }
        this.context = file;
    }

    private File computeTargetFile(SinglePatch singlePatch) {
        if (singlePatch.targetPath == null) {
            singlePatch.targetPath = this.context.getAbsolutePath();
        }
        if (this.context.isFile()) {
            return this.context;
        }
        return new File(this.context, singlePatch.targetPath);
    }

    public static final class PatchReport {
        private File file;
        private File originalBackupFile;
        private boolean binary;
        private PatchStatus status;
        private Throwable failure;

        PatchReport(File file, File file2, boolean bl, PatchStatus patchStatus, Throwable throwable) {
            this.file = file;
            this.originalBackupFile = file2;
            this.binary = bl;
            this.status = patchStatus;
            this.failure = throwable;
        }

        public File getFile() {
            return this.file;
        }

        public File getOriginalBackupFile() {
            return this.originalBackupFile;
        }

        public boolean isBinary() {
            return this.binary;
        }

        public PatchStatus getStatus() {
            return this.status;
        }

        public Throwable getFailure() {
            return this.failure;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PatchStatus {
        Patched,
        Missing,
        Failure;

    }

    private class SinglePatch {
        String targetIndex;
        String targetPath;
        Hunk[] hunks;
        boolean targetMustExist = true;
        File targetFile;
        boolean noEndingNewline;
        boolean binary;

        private SinglePatch() {
        }
    }
}

