/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.io.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.netbeans.modules.vmd.api.io.DataEditorView;
import org.netbeans.modules.vmd.api.io.DataEditorViewFactory;
import org.netbeans.modules.vmd.api.io.DataObjectContext;
import org.netbeans.modules.vmd.api.io.providers.IOSupport;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorViewFactorySupport {
    private static final Lookup.Result factoriesLookupResult = Lookup.getDefault().lookupResult(DataEditorViewFactory.class);

    public static Collection<DataEditorView> createEditorViews(DataObjectContext dataObjectContext) {
        String string = IOSupport.resolveProjectType(dataObjectContext);
        if (string == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<DataEditorView> arrayList = new ArrayList<DataEditorView>();
        for (Object e : factoriesLookupResult.allInstances()) {
            DataEditorView dataEditorView = ((DataEditorViewFactory)e).createEditorView(dataObjectContext);
            if (dataEditorView == null) continue;
            arrayList.add(dataEditorView);
        }
        Collections.sort(arrayList, new Comparator<DataEditorView>(){

            @Override
            public int compare(DataEditorView dataEditorView, DataEditorView dataEditorView2) {
                return dataEditorView.getOrder() - dataEditorView2.getOrder();
            }
        });
        return Collections.unmodifiableCollection(arrayList);
    }
}

