/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jspparser;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsps.parserapi.TldChangeEvent;
import org.netbeans.modules.web.jsps.parserapi.TldChangeListener;
import org.openide.util.Exceptions;

public class TldChangeSupport {
    private final List<TldChangeListener> listeners = new CopyOnWriteArrayList<TldChangeListener>();
    private final Object source;

    public TldChangeSupport(Object object) {
        this.source = object;
    }

    public void addTldChangeListener(TldChangeListener tldChangeListener) {
        if (tldChangeListener == null) {
            return;
        }
        this.listeners.add(tldChangeListener);
    }

    public void removeTldChangeListener(TldChangeListener tldChangeListener) {
        if (tldChangeListener == null) {
            return;
        }
        this.listeners.remove(tldChangeListener);
    }

    public void fireChange(WebModule webModule) {
        if (this.listeners.isEmpty()) {
            return;
        }
        this.fireChange(new TldChangeEvent(this.source, webModule));
    }

    private void fireChange(TldChangeEvent tldChangeEvent) {
        assert (tldChangeEvent != null);
        for (TldChangeListener tldChangeListener : this.listeners) {
            try {
                tldChangeListener.tldChange(tldChangeEvent);
            }
            catch (RuntimeException runtimeException) {
                Exceptions.printStackTrace((Throwable)runtimeException);
            }
        }
    }

    public boolean hasListeners() {
        return !this.listeners.isEmpty();
    }
}

