/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.editors.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.font.TextAttribute;
import java.text.AttributedString;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;

public class MultiLineField
extends JComponent
implements Accessible {
    private static final int CHARS_DISPLAYED = 80;
    private static final int LINES_DISPLAYED = 4;
    private static final int LINE_SPACING = 2;
    private static final int DEFAULT_WIDTH = 400;
    private static final int MIN_WIDTH = 50;
    private static final String SPACE = " ";
    private static final Insets INSETS = new Insets(0, 5, 5, 5);
    protected static final Color ERROR_COLOR = Color.red;
    private String[] stringsToDisplay;
    private AttributedString[] attributedStrings;
    private Object lockObject = new Object();
    protected FontMetrics fontMetrics;
    protected int totalWidth;
    protected Dimension preferredSize;
    private Insets insets;
    private int numberLines;
    private int lineHeight;
    private int charHeight;
    private int lineSpacing;
    private boolean useMonospacedFont;
    private boolean formatText;

    public MultiLineField() {
        this.setText(new String[0]);
        this.init(4);
    }

    public MultiLineField(String string) {
        this.setText(string);
        this.init(this.stringsToDisplay.length);
    }

    public MultiLineField(String string, boolean bl) {
        this(string);
        this.formatText = bl;
    }

    public MultiLineField(String[] stringArray) {
        this.setText(stringArray);
        this.init(this.stringsToDisplay.length);
    }

    private void init(int n) {
        this.formatText = false;
        this.insets = INSETS;
        this.numberLines = n;
        this.useMonospacedFont = false;
        this.preferredSize = new Dimension(100, 20);
    }

    public void setInsets(Insets insets) {
        this.insets = insets;
    }

    public void useMonospacedFont(boolean bl) {
        this.useMonospacedFont = bl;
    }

    public void addNotify() {
        int n;
        super.addNotify();
        int n2 = this.getFont().getSize();
        if (this.useMonospacedFont) {
            Font font = new Font("Monospaced", 0, n2);
            this.setFont(font);
        }
        this.fontMetrics = this.getFontMetrics(this.getFont());
        int n3 = 0;
        if (this.stringsToDisplay == null) {
            n3 = this.fontMetrics.charWidth('v') * 80;
        } else if (this.formatText) {
            n3 = 400;
        } else {
            for (n = 0; n < this.stringsToDisplay.length; ++n) {
                int n4 = this.fontMetrics.stringWidth(this.stringsToDisplay[n]);
                if (n4 <= n3) continue;
                n3 = n4;
            }
        }
        this.charHeight = this.fontMetrics.getMaxAscent() + this.fontMetrics.getMaxDescent();
        this.lineSpacing = 0;
        this.lineSpacing = n2 > 12 ? 2 + (n2 - 4) / 4 : 2;
        this.totalWidth = this.insets.left + this.insets.right + n3;
        this.lineHeight = this.charHeight + this.lineSpacing;
        if (this.formatText) {
            this.reformat();
        }
        n = this.insets.top + this.insets.bottom + this.charHeight * this.numberLines + this.lineSpacing * (this.numberLines - 1);
        this.preferredSize = new Dimension(this.totalWidth, n);
    }

    private void reformat() {
        if (this.stringsToDisplay == null || this.stringsToDisplay.length < 1) {
            return;
        }
        String string = this.stringsToDisplay[0];
        for (int i = 1; i < this.stringsToDisplay.length; ++i) {
            string = string.concat(SPACE + this.stringsToDisplay[i]);
        }
        this.reformat(string);
    }

    private void reformat(String string) {
        if (this.totalWidth < 50) {
            return;
        }
        int n = this.totalWidth - (this.insets.left + this.insets.right);
        StringTokenizer stringTokenizer = new StringTokenizer(string, SPACE);
        Vector<String> vector = new Vector<String>();
        String string2 = stringTokenizer.nextToken();
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            String string4 = string2 + SPACE + string3;
            int n2 = this.fontMetrics.stringWidth(string4);
            if (n2 > n) {
                vector.addElement(string2);
                string2 = string3;
                continue;
            }
            string2 = string4;
        }
        vector.addElement(string2);
        this.numberLines = vector.size();
        this.stringsToDisplay = new String[this.numberLines];
        vector.copyInto(this.stringsToDisplay);
    }

    public Dimension getPreferredSize() {
        return this.preferredSize;
    }

    public Dimension getMinimumSize() {
        return this.preferredSize;
    }

    public void setSize(Dimension dimension) {
        if (dimension.width != this.totalWidth) {
            this.totalWidth = dimension.width;
            if (this.formatText) {
                this.reformat();
            }
        }
        super.setSize(dimension);
    }

    public void setBounds(Rectangle rectangle) {
        if (rectangle.width != this.totalWidth) {
            this.totalWidth = rectangle.width;
            if (this.formatText) {
                this.reformat();
            }
        }
        super.setBounds(rectangle);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (n3 != this.totalWidth) {
            this.totalWidth = n3;
            if (this.formatText) {
                this.reformat();
            }
        }
        super.setBounds(n, n2, n3, n4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (dimension.width != this.totalWidth) {
            this.totalWidth = dimension.width;
        }
        graphics.clearRect(0, 0, dimension.width, dimension.height);
        Object object = this.lockObject;
        synchronized (object) {
            int n = this.insets.top + this.fontMetrics.getMaxAscent();
            int n2 = (this.numberLines - this.stringsToDisplay.length) / 2;
            if (n2 > 0) {
                n += this.lineHeight * n2;
            }
            for (int i = 0; i < this.stringsToDisplay.length; ++i) {
                if (this.attributedStrings != null) {
                    this.attributedStrings[i].addAttribute(TextAttribute.FONT, this.getFont());
                    graphics.drawString(this.attributedStrings[i].getIterator(), this.insets.left, n);
                } else {
                    graphics.drawString(this.stringsToDisplay[i], this.insets.left, n);
                }
                n += this.lineHeight;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setText(AttributedString[] attributedStringArray) {
        Object object = this.lockObject;
        synchronized (object) {
            this.attributedStrings = attributedStringArray;
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setText(String[] stringArray) {
        Object object = this.lockObject;
        synchronized (object) {
            this.stringsToDisplay = stringArray;
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getText() {
        String[] stringArray = null;
        Object object = this.lockObject;
        synchronized (object) {
            if (this.stringsToDisplay != null && this.stringsToDisplay.length > 0) {
                stringArray = new String[this.stringsToDisplay.length];
                System.arraycopy(this.stringsToDisplay, 0, stringArray, 0, this.stringsToDisplay.length);
            }
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setText(String string) {
        Object object = this.lockObject;
        synchronized (object) {
            this.attributedStrings = null;
            if (string == null) {
                this.stringsToDisplay = new String[1];
                this.stringsToDisplay[0] = SPACE;
            } else if (this.formatText) {
                if (this.fontMetrics != null) {
                    this.reformat(string);
                } else {
                    this.stringsToDisplay = new String[1];
                    this.stringsToDisplay[0] = string;
                }
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
                int n = stringTokenizer.countTokens();
                this.stringsToDisplay = new String[n];
                for (int i = 0; i < n; ++i) {
                    this.stringsToDisplay[i] = stringTokenizer.nextToken();
                }
            }
        }
    }

    public void setError(boolean bl) {
        if (bl) {
            if (this.stringsToDisplay == null) {
                return;
            }
            this.attributedStrings = new AttributedString[this.stringsToDisplay.length];
            for (int i = 0; i < this.stringsToDisplay.length; ++i) {
                this.attributedStrings[i] = new AttributedString(this.stringsToDisplay[i]);
                this.attributedStrings[i].addAttribute(TextAttribute.FOREGROUND, ERROR_COLOR);
            }
        } else {
            this.attributedStrings = null;
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleMultiLineField();
        }
        return this.accessibleContext;
    }

    protected class AccessibleMultiLineField
    extends JComponent.AccessibleJComponent {
        protected AccessibleMultiLineField() {
            super(MultiLineField.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LABEL;
        }
    }
}

