/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.serialization;

import java.util.Arrays;
import java.util.List;
import org.netbeans.modules.vmd.api.model.PresenterSerializer;
import org.netbeans.modules.vmd.api.model.PropertyDescriptor;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.serialization.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MidpPropertyPresenterSerializer
implements PresenterSerializer {
    private String displayName;
    private String editorID;
    private String propertyName;

    public MidpPropertyPresenterSerializer(String string, PropertyDescriptor propertyDescriptor) {
        this.displayName = string;
        this.editorID = MidpPropertyPresenterSerializer.createEditorIDForPropertyDescriptor(propertyDescriptor);
        this.propertyName = propertyDescriptor.getName();
    }

    public List<Element> serialize(Document document) {
        Element element = document.createElement("MidpProperty");
        XMLUtils.setAttribute(document, element, "displayName", this.displayName);
        if (this.editorID != null) {
            XMLUtils.setAttribute(document, element, "editor", this.editorID);
        }
        XMLUtils.setAttribute(document, element, "propertyName", this.propertyName);
        return Arrays.asList(element);
    }

    private static String createEditorIDForPropertyDescriptor(PropertyDescriptor propertyDescriptor) {
        TypeID typeID = propertyDescriptor.getType();
        if (MidpTypes.TYPEID_BOOLEAN.equals((Object)typeID)) {
            return "boolean";
        }
        if (MidpTypes.TYPEID_CHAR.equals((Object)typeID)) {
            return "char";
        }
        if (MidpTypes.TYPEID_BYTE.equals((Object)typeID)) {
            return "byte";
        }
        if (MidpTypes.TYPEID_SHORT.equals((Object)typeID)) {
            return "short";
        }
        if (MidpTypes.TYPEID_INT.equals((Object)typeID)) {
            return "int";
        }
        if (MidpTypes.TYPEID_LONG.equals((Object)typeID)) {
            return "long";
        }
        if (MidpTypes.TYPEID_FLOAT.equals((Object)typeID)) {
            return "float";
        }
        if (MidpTypes.TYPEID_DOUBLE.equals((Object)typeID)) {
            return "double";
        }
        if (MidpTypes.TYPEID_JAVA_LANG_STRING.equals((Object)typeID)) {
            return "java.lang.String";
        }
        return "#javaCode";
    }
}

