/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.propertyeditors;

import java.util.Map;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.api.properties.DesignPropertyEditor;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertyEditorComboBoxNoUserCode
extends DesignPropertyEditor {
    private final Map<String, PropertyValue> values;
    private String[] tags;
    private TypeID enableTypeID;

    private PropertyEditorComboBoxNoUserCode(Map<String, PropertyValue> map, TypeID typeID) {
        this.values = map;
        this.enableTypeID = typeID;
        this.createTags();
    }

    public static PropertyEditorComboBoxNoUserCode createInstance(Map<String, PropertyValue> map, TypeID typeID) {
        if (map == null) {
            throw new IllegalArgumentException("Argument values can't be null");
        }
        for (String string : map.keySet()) {
            PropertyValue propertyValue = map.get(string);
            if (propertyValue != null) continue;
            throw new IllegalArgumentException("PropertyValue for " + string + " key can't be null");
        }
        return new PropertyEditorComboBoxNoUserCode(map, typeID);
    }

    public void cleanUp(DesignComponent designComponent) {
        super.cleanUp(designComponent);
        this.tags = null;
        this.enableTypeID = null;
    }

    public void setAsText(String string) {
        if (this.canWrite()) {
            this.saveValue(string);
        }
    }

    private void saveValue(String string) {
        PropertyValue propertyValue;
        if (string.length() > 0 && (propertyValue = this.values.get(string)) != null) {
            super.setValue((Object)propertyValue);
        }
    }

    public boolean supportsCustomEditor() {
        return false;
    }

    public String getAsText() {
        PropertyValue propertyValue = (PropertyValue)super.getValue();
        if (this.values == null) {
            return null;
        }
        for (String string : this.values.keySet()) {
            PropertyValue propertyValue2 = this.values.get(string);
            if (!propertyValue.getPrimitiveValue().equals(propertyValue2.getPrimitiveValue())) continue;
            return string;
        }
        return NbBundle.getMessage(PropertyEditorComboBoxNoUserCode.class, (String)"LBL_MULTIPLE");
    }

    public String[] getTags() {
        return this.tags;
    }

    private void createTags() {
        int n = 0;
        this.tags = new String[this.values.size()];
        for (String string : this.values.keySet()) {
            this.tags[n++] = string;
        }
    }

    public Boolean canEditAsText() {
        return null;
    }
}

