/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.components.items;

import org.netbeans.modules.vmd.api.model.ComponentProducer;
import org.netbeans.modules.vmd.api.model.DescriptorRegistry;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.Presenter;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.api.model.common.AcceptPresenter;
import org.netbeans.modules.vmd.api.model.common.AcceptSuggestion;
import org.netbeans.modules.vmd.midp.components.MidpDocumentSupport;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.categories.DatabindingCategoryCD;
import org.netbeans.modules.vmd.midp.components.databinding.DataSetAbstractCD;
import org.netbeans.modules.vmd.midp.components.databinding.DataSetConnectorCD;
import org.netbeans.modules.vmd.midp.components.databinding.MidpDatabindingSupport;

public abstract class DatabindingItemAcceptPresenter
extends AcceptPresenter {
    private final TypeID typeID = DataSetAbstractCD.TYPEID;

    public DatabindingItemAcceptPresenter() {
        super(AcceptPresenter.Kind.COMPONENT_PRODUCER);
    }

    public final boolean isAcceptable(ComponentProducer componentProducer, AcceptSuggestion acceptSuggestion) {
        DescriptorRegistry descriptorRegistry = this.getComponent().getDocument().getDescriptorRegistry();
        TypeID typeID = componentProducer.getMainComponentTypeID();
        return descriptorRegistry.isInHierarchy(this.typeID, typeID);
    }

    public final ComponentProducer.Result accept(ComponentProducer componentProducer, AcceptSuggestion acceptSuggestion) {
        ComponentProducer.Result result = componentProducer.createComponent(this.getComponent().getDocument());
        DesignComponent designComponent = result.getMainComponent();
        if (designComponent != null) {
            this.notifyCreated(designComponent);
        }
        DesignComponent designComponent2 = MidpDocumentSupport.getCategoryComponent(designComponent.getDocument(), DatabindingCategoryCD.TYPEID);
        designComponent2.addComponent(designComponent);
        return result;
    }

    protected abstract void notifyCreated(DesignComponent var1);

    public static Presenter create(final String ... stringArray) {
        return new DatabindingItemAcceptPresenter(){

            protected void notifyCreated(DesignComponent designComponent) {
                for (String string : stringArray) {
                    MidpDatabindingSupport.removeUnusedConnector(designComponent, string);
                    this.createConnector(designComponent, string);
                }
            }
        };
    }

    protected void createConnector(DesignComponent designComponent, String string) {
        DesignComponent designComponent2 = designComponent.getDocument().createComponent(DataSetConnectorCD.TYPEID);
        designComponent2.writeProperty("property", MidpTypes.createStringValue(string));
        designComponent2.writeProperty("referencedComponent", MidpTypes.createLongValue(this.getComponent().getComponentID()));
        designComponent.addComponent(designComponent2);
        this.getComponent().resetToDefault(string);
    }
}

