/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.components.items;

import java.util.List;
import org.netbeans.modules.vmd.api.codegen.CodeWriter;
import org.netbeans.modules.vmd.api.codegen.MultiGuardedSection;
import org.netbeans.modules.vmd.api.codegen.Parameter;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.api.model.common.DocumentSupport;
import org.netbeans.modules.vmd.midp.codegen.MidpCodeSupport;
import org.netbeans.modules.vmd.midp.codegen.MidpParameter;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.elements.ChoiceElementCD;

public class ChoiceGroupCode {
    public static final String PARAM_STRING = "elementString";
    public static final String PARAM_IMAGE = "elementImage";
    static final String PARAM_FONT = "elementFont";
    static final String PARAM_SELECTED_ARRAY = "elementSelectedArray";
    static final String PARAM_STRING_ARRAY = "elementStringArray";
    static final String PARAM_IMAGE_ARRAY = "elementImageArray";
    static final String PARAM_CHOICE_TYPE = "choiceType";
    static final String PARAM_FIT_POLICY = "fitPolicy";

    public static Parameter createStringParameter() {
        return new StringParameter();
    }

    public static Parameter createImageParameter() {
        return new ImageParameter();
    }

    public static Parameter createFontParameter() {
        return new FontParameter();
    }

    public static Parameter createSelectArrayParameter() {
        return new SelectedArrayParameter();
    }

    public static Parameter createStringArrayParameter() {
        return new StringArrayParameter();
    }

    public static Parameter createImageArrayParameter() {
        return new ImageArrayParameter();
    }

    public static Parameter createChoiceTypeParameter() {
        return new ChoiceTypeParameter();
    }

    public static Parameter createFitPolicyParameter() {
        return new FitPolicyParameter();
    }

    private static class FitPolicyParameter
    extends MidpParameter {
        protected FitPolicyParameter() {
            super(ChoiceGroupCode.PARAM_FIT_POLICY);
        }

        public void generateParameterCode(DesignComponent designComponent, MultiGuardedSection multiGuardedSection, int n) {
            PropertyValue propertyValue = designComponent.readProperty(ChoiceGroupCode.PARAM_FIT_POLICY);
            if (propertyValue.getKind() == PropertyValue.Kind.VALUE) {
                int n2 = MidpTypes.getInteger(propertyValue);
                switch (n2) {
                    case 0: {
                        multiGuardedSection.getWriter().write("Choice.TEXT_WRAP_DEFAULT");
                        break;
                    }
                    case 1: {
                        multiGuardedSection.getWriter().write("Choice.TEXT_WRAP_ON");
                        break;
                    }
                    case 2: {
                        multiGuardedSection.getWriter().write("Choice.TEXT_WRAP_OFF");
                        break;
                    }
                    default: {
                        throw Debug.illegalState((Object[])new Object[0]);
                    }
                }
                return;
            }
            super.generateParameterCode(designComponent, multiGuardedSection, n);
        }
    }

    private static class ChoiceTypeParameter
    extends MidpParameter {
        protected ChoiceTypeParameter() {
            super(ChoiceGroupCode.PARAM_CHOICE_TYPE);
        }

        public void generateParameterCode(DesignComponent designComponent, MultiGuardedSection multiGuardedSection, int n) {
            PropertyValue propertyValue = designComponent.readProperty(ChoiceGroupCode.PARAM_CHOICE_TYPE);
            if (propertyValue.getKind() == PropertyValue.Kind.VALUE) {
                int n2 = MidpTypes.getInteger(propertyValue);
                switch (n2) {
                    case 1: {
                        multiGuardedSection.getWriter().write("Choice.EXCLUSIVE");
                        break;
                    }
                    case 2: {
                        multiGuardedSection.getWriter().write("Choice.MULTIPLE");
                        break;
                    }
                    case 4: {
                        multiGuardedSection.getWriter().write("Choice.POPUP");
                        break;
                    }
                    default: {
                        throw Debug.illegalState((Object[])new Object[0]);
                    }
                }
                return;
            }
            super.generateParameterCode(designComponent, multiGuardedSection, n);
        }
    }

    private static class ImageArrayParameter
    implements Parameter {
        private ImageArrayParameter() {
        }

        public String getParameterName() {
            return ChoiceGroupCode.PARAM_IMAGE_ARRAY;
        }

        public int getParameterPriority() {
            return 0;
        }

        public void generateParameterCode(DesignComponent designComponent, MultiGuardedSection multiGuardedSection, int n) {
            PropertyValue propertyValue = designComponent.readProperty("elements");
            List list = propertyValue.getArray();
            CodeWriter codeWriter = multiGuardedSection.getWriter();
            codeWriter.write("new Image[] { ");
            for (int i = 0; i < list.size(); ++i) {
                if (i > 0) {
                    codeWriter.write(", ");
                }
                PropertyValue propertyValue2 = (PropertyValue)list.get(i);
                DesignComponent designComponent2 = propertyValue2.getComponent();
                PropertyValue propertyValue3 = designComponent2.readProperty("image");
                MidpCodeSupport.generateCodeForPropertyValue(codeWriter, propertyValue3);
            }
            codeWriter.write(" }");
        }

        public boolean isRequiredToBeSet(DesignComponent designComponent) {
            return !designComponent.isDefaultValue("elements");
        }

        public int getCount(DesignComponent designComponent) {
            return -1;
        }

        public boolean isRequiredToBeSet(DesignComponent designComponent, int n) {
            throw Debug.illegalState((Object[])new Object[0]);
        }
    }

    private static class StringArrayParameter
    implements Parameter {
        private StringArrayParameter() {
        }

        public String getParameterName() {
            return ChoiceGroupCode.PARAM_STRING_ARRAY;
        }

        public int getParameterPriority() {
            return 0;
        }

        public void generateParameterCode(DesignComponent designComponent, MultiGuardedSection multiGuardedSection, int n) {
            PropertyValue propertyValue = designComponent.readProperty("elements");
            List list = propertyValue.getArray();
            CodeWriter codeWriter = multiGuardedSection.getWriter();
            codeWriter.write("new String[] { ");
            for (int i = 0; i < list.size(); ++i) {
                if (i > 0) {
                    codeWriter.write(", ");
                }
                PropertyValue propertyValue2 = (PropertyValue)list.get(i);
                DesignComponent designComponent2 = propertyValue2.getComponent();
                PropertyValue propertyValue3 = designComponent2.readProperty("string");
                MidpCodeSupport.generateCodeForPropertyValue(codeWriter, propertyValue3);
            }
            codeWriter.write(" }");
        }

        public boolean isRequiredToBeSet(DesignComponent designComponent) {
            return !designComponent.isDefaultValue("elements");
        }

        public int getCount(DesignComponent designComponent) {
            return -1;
        }

        public boolean isRequiredToBeSet(DesignComponent designComponent, int n) {
            throw Debug.illegalState((Object[])new Object[0]);
        }
    }

    private static class SelectedArrayParameter
    implements Parameter {
        private SelectedArrayParameter() {
        }

        public String getParameterName() {
            return ChoiceGroupCode.PARAM_SELECTED_ARRAY;
        }

        public int getParameterPriority() {
            return 0;
        }

        public void generateParameterCode(DesignComponent designComponent, MultiGuardedSection multiGuardedSection, int n) {
            PropertyValue propertyValue = designComponent.readProperty("elements");
            List list = propertyValue.getArray();
            CodeWriter codeWriter = multiGuardedSection.getWriter();
            codeWriter.write("new boolean[] { ");
            for (int i = 0; i < list.size(); ++i) {
                if (i > 0) {
                    codeWriter.write(", ");
                }
                PropertyValue propertyValue2 = (PropertyValue)list.get(i);
                DesignComponent designComponent2 = propertyValue2.getComponent();
                PropertyValue propertyValue3 = designComponent2.readProperty("selected");
                MidpCodeSupport.generateCodeForPropertyValue(codeWriter, propertyValue3);
            }
            codeWriter.write(" }");
        }

        public boolean isRequiredToBeSet(DesignComponent designComponent) {
            return !designComponent.isDefaultValue("elements");
        }

        public int getCount(DesignComponent designComponent) {
            return -1;
        }

        public boolean isRequiredToBeSet(DesignComponent designComponent, int n) {
            throw Debug.illegalState((Object[])new Object[0]);
        }
    }

    private static class FontParameter
    implements Parameter {
        private FontParameter() {
        }

        public String getParameterName() {
            return ChoiceGroupCode.PARAM_FONT;
        }

        public int getParameterPriority() {
            return 0;
        }

        public void generateParameterCode(DesignComponent designComponent, MultiGuardedSection multiGuardedSection, int n) {
            PropertyValue propertyValue = designComponent.readProperty("elements");
            List list = propertyValue.getArray();
            DesignComponent designComponent2 = ((PropertyValue)list.get(n)).getComponent();
            PropertyValue propertyValue2 = designComponent2.readProperty("font");
            MidpCodeSupport.generateCodeForPropertyValue(multiGuardedSection.getWriter(), propertyValue2);
        }

        public boolean isRequiredToBeSet(DesignComponent designComponent) {
            List list = DocumentSupport.gatherSubComponentsOfType((DesignComponent)designComponent, (TypeID)ChoiceElementCD.TYPEID);
            if (list == null) {
                return false;
            }
            for (DesignComponent designComponent2 : list) {
                if (designComponent2.isDefaultValue("font")) continue;
                return true;
            }
            return false;
        }

        public int getCount(DesignComponent designComponent) {
            PropertyValue propertyValue = designComponent.readProperty("elements");
            List list = propertyValue.getArray();
            return list.size();
        }

        public boolean isRequiredToBeSet(DesignComponent designComponent, int n) {
            return true;
        }
    }

    private static class ImageParameter
    implements Parameter {
        private ImageParameter() {
        }

        public String getParameterName() {
            return ChoiceGroupCode.PARAM_IMAGE;
        }

        public int getParameterPriority() {
            return 0;
        }

        public void generateParameterCode(DesignComponent designComponent, MultiGuardedSection multiGuardedSection, int n) {
            PropertyValue propertyValue = designComponent.readProperty("elements");
            List list = propertyValue.getArray();
            DesignComponent designComponent2 = ((PropertyValue)list.get(n)).getComponent();
            PropertyValue propertyValue2 = designComponent2.readProperty("image");
            MidpCodeSupport.generateCodeForPropertyValue(multiGuardedSection.getWriter(), propertyValue2);
        }

        public boolean isRequiredToBeSet(DesignComponent designComponent) {
            return !designComponent.isDefaultValue("elements");
        }

        public int getCount(DesignComponent designComponent) {
            PropertyValue propertyValue = designComponent.readProperty("elements");
            List list = propertyValue.getArray();
            return list.size();
        }

        public boolean isRequiredToBeSet(DesignComponent designComponent, int n) {
            return true;
        }
    }

    private static class StringParameter
    implements Parameter {
        private StringParameter() {
        }

        public String getParameterName() {
            return ChoiceGroupCode.PARAM_STRING;
        }

        public int getParameterPriority() {
            return 0;
        }

        public void generateParameterCode(DesignComponent designComponent, MultiGuardedSection multiGuardedSection, int n) {
            PropertyValue propertyValue = designComponent.readProperty("elements");
            List list = propertyValue.getArray();
            DesignComponent designComponent2 = ((PropertyValue)list.get(n)).getComponent();
            PropertyValue propertyValue2 = designComponent2.readProperty("string");
            MidpCodeSupport.generateCodeForPropertyValue(multiGuardedSection.getWriter(), propertyValue2);
        }

        public boolean isRequiredToBeSet(DesignComponent designComponent) {
            return !designComponent.isDefaultValue("elements");
        }

        public int getCount(DesignComponent designComponent) {
            PropertyValue propertyValue = designComponent.readProperty("elements");
            List list = propertyValue.getArray();
            return list.size();
        }

        public boolean isRequiredToBeSet(DesignComponent designComponent, int n) {
            return true;
        }
    }
}

