/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.attributes;

import freemind.controller.filter.util.SortedComboBoxModel;
import freemind.main.XMLElement;
import freemind.modes.attributes.AttributeRegistry;

public class AttributeRegistryElement {
    private String key;
    private RegisteredAttributeValues values;
    private AttributeRegistry registry;
    private boolean isVisible;
    private boolean isRestricted;
    private Boolean visibilityModel;
    private Boolean restrictionModel;

    public AttributeRegistryElement(AttributeRegistry registry, String key) {
        this.key = key;
        this.registry = registry;
        this.values = new RegisteredAttributeValues();
        this.isVisible = false;
        this.visibilityModel = new Boolean(this.isVisible);
        this.isRestricted = false;
        this.restrictionModel = new Boolean(this.isRestricted);
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public SortedComboBoxModel getValues() {
        return this.values;
    }

    public void addValue(String s) {
        this.values._add(s);
        this.registry.fireAttributesChanged();
    }

    public void removeAllValues() {
        this.values.clear();
        this.registry.fireAttributesChanged();
    }

    public void removeValue(String s) {
        this.values._remove(s);
        this.registry.fireAttributesChanged();
    }

    public boolean isRestricted() {
        return this.isRestricted;
    }

    public Comparable getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public XMLElement save() {
        XMLElement element = new XMLElement();
        if (this.isVisible()) {
            element.setAttribute("VISIBLE", "true");
        }
        if (this.isRestricted()) {
            element.setAttribute("RESTRICTED", "true");
            for (int i = 0; i < this.values.getSize(); ++i) {
                XMLElement value = new XMLElement();
                value.setName("attribute_value");
                value.setAttribute("VALUE", this.values.getElementAt(i).toString());
                element.addChild(value);
            }
        }
        element.setName("attribute_name");
        element.setAttribute("NAME", this.key.toString());
        return element;
    }

    public void setVisibility(boolean isVisible) {
        if (this.isVisible != isVisible) {
            this.isVisible = isVisible;
            this.visibilityModel = isVisible;
            if (isVisible) {
                this.registry.incrementVisibleElementsNumber();
            } else {
                this.registry.decrementVisibleElementsNumber();
            }
            this.registry.fireAttributeLayoutChanged();
        }
    }

    public void setRestriction(boolean isRestricted) {
        this.isRestricted = isRestricted;
        this.restrictionModel = isRestricted;
        this.registry.fireAttributesChanged();
    }

    Boolean getRestriction() {
        return this.restrictionModel;
    }

    void setRestrictionModel(Boolean restrictionModel) {
        this.restrictionModel = restrictionModel;
    }

    Boolean getVisibilityModel() {
        return this.visibilityModel;
    }

    void setVisibilityModel(Boolean visibilityModel) {
        this.visibilityModel = visibilityModel;
    }

    public void replaceValue(String oldValue, String newValue) {
        this.values._replace(oldValue, newValue);
        this.registry.fireAttributesChanged();
    }

    private class RegisteredAttributeValues
    extends SortedComboBoxModel {
        private RegisteredAttributeValues() {
        }

        public AttributeRegistry getRegistry() {
            return AttributeRegistryElement.this.registry;
        }

        public String getKey() {
            return AttributeRegistryElement.this.key;
        }

        public void add(Object element) {
            AttributeRegistryElement.this.registry.getAttributeController().performRegistryAttributeValue(this.getKey(), element.toString());
        }

        public void _add(Object element) {
            super.add(element);
        }

        public void remove(Object element) {
            AttributeRegistryElement.this.registry.getAttributeController().performRemoveAttributeValue(this.getKey(), element.toString());
        }

        public void _remove(Object element) {
            super.remove(element);
        }

        public void replace(Object oldO, Object newO) {
            AttributeRegistryElement.this.registry.getAttributeController().performReplaceAttributeValue(this.getKey(), oldO.toString(), newO.toString());
        }

        public void _replace(Object oldO, Object newO) {
            super.replace(oldO, newO);
        }
    }
}

