/*
 * Decompiled with CFR 0.152.
 */
package plugins.script;

import freemind.main.Resources;
import java.io.FileDescriptor;
import java.net.InetAddress;
import java.security.Permission;
import java.util.HashSet;
import java.util.logging.Logger;

public class ScriptingSecurityManager
extends SecurityManager {
    private final boolean mWithoutFileRestriction;
    private final boolean mWithoutNetworkRestriction;
    private final boolean mWithoutExecRestriction;
    private static final int PERM_Accept = 0;
    private static final int PERM_Connect = 1;
    private static final int PERM_Listen = 2;
    private static final int PERM_Multicast = 3;
    private static final int PERM_SetFactory = 4;
    private static final int PERM_Exec = 5;
    private static final int PERM_Link = 6;
    private static final int PERM_Delete = 7;
    private static final int PERM_Read = 8;
    private static final int PERM_Write = 9;
    private static final int PERM_GROUP_FILE = 0;
    private static final int PERM_GROUP_NETWORK = 1;
    private static final int PERM_GROUP_EXEC = 2;
    private static Logger logger = null;

    public ScriptingSecurityManager(boolean pWithoutFileRestriction, boolean pWithoutNetworkRestriction, boolean pWithoutExecRestriction) {
        if (logger == null) {
            logger = Resources.getInstance().getLogger(this.getClass().getName());
        }
        this.mWithoutFileRestriction = pWithoutFileRestriction;
        this.mWithoutNetworkRestriction = pWithoutNetworkRestriction;
        this.mWithoutExecRestriction = pWithoutExecRestriction;
    }

    public void checkAccept(String pHost, int pPort) {
        if (this.mWithoutNetworkRestriction) {
            return;
        }
        throw this.getException(1, 0);
    }

    public void checkConnect(String pHost, int pPort, Object pContext) {
        if (this.mWithoutNetworkRestriction) {
            return;
        }
        throw this.getException(1, 1);
    }

    public void checkConnect(String pHost, int pPort) {
        if (this.mWithoutNetworkRestriction) {
            return;
        }
        throw this.getException(1, 1);
    }

    public void checkListen(int pPort) {
        if (this.mWithoutNetworkRestriction) {
            return;
        }
        throw this.getException(1, 2);
    }

    public void checkMulticast(InetAddress pMaddr, byte pTtl) {
        if (this.mWithoutNetworkRestriction) {
            return;
        }
        throw this.getException(1, 3);
    }

    public void checkMulticast(InetAddress pMaddr) {
        if (this.mWithoutNetworkRestriction) {
            return;
        }
        throw this.getException(1, 3);
    }

    public void checkSetFactory() {
        if (this.mWithoutNetworkRestriction) {
            return;
        }
        throw this.getException(1, 4);
    }

    public void checkExec(String pCmd) {
        if (this.mWithoutExecRestriction) {
            return;
        }
        throw this.getException(2, 5);
    }

    public void checkLink(String pLib) {
        HashSet<String> set = new HashSet<String>();
        set.add("awt");
        set.add("net");
        set.add("jpeg");
        set.add("fontmanager");
        if (this.mWithoutExecRestriction || set.contains(pLib)) {
            return;
        }
        throw this.getException(2, 6);
    }

    public void checkDelete(String pFile) {
        if (this.mWithoutFileRestriction) {
            return;
        }
        throw this.getException(0, 7);
    }

    public void checkRead(FileDescriptor pFd) {
        if (this.mWithoutFileRestriction) {
            return;
        }
        throw this.getException(0, 8);
    }

    public void checkRead(String pFile, Object pContext) {
        if (this.mWithoutFileRestriction) {
            return;
        }
        throw this.getException(0, 8);
    }

    public void checkRead(String pFile) {
        if (this.mWithoutFileRestriction) {
            return;
        }
        throw this.getException(0, 8);
    }

    public void checkWrite(FileDescriptor pFd) {
        if (this.mWithoutFileRestriction) {
            return;
        }
        throw this.getException(0, 9);
    }

    public void checkWrite(String pFile) {
        if (this.mWithoutFileRestriction) {
            return;
        }
        throw this.getException(0, 9);
    }

    private SecurityException getException(int pPermissionGroup, int pPermission) {
        return new SecurityException(Resources.getInstance().format("plugins/ScriptEditor.FORBIDDEN_ACTION", (Object[])new Integer[]{new Integer(pPermissionGroup), new Integer(pPermission)}));
    }

    public void checkAccess(Thread pT) {
    }

    public void checkAccess(ThreadGroup pG) {
    }

    public void checkAwtEventQueueAccess() {
    }

    public void checkCreateClassLoader() {
    }

    public void checkExit(int pStatus) {
    }

    public void checkMemberAccess(Class arg0, int arg1) {
    }

    public void checkPackageAccess(String pPkg) {
    }

    public void checkPackageDefinition(String pPkg) {
    }

    public void checkPermission(Permission pPerm, Object pContext) {
        logger.info("Check Permission with Context: " + pPerm.getClass());
    }

    public void checkPermission(Permission pPerm) {
        logger.info("Check Permission: " + pPerm.getClass());
    }

    public void checkPrintJobAccess() {
    }

    public void checkPropertiesAccess() {
    }

    public void checkPropertyAccess(String pKey) {
    }

    public void checkSecurityAccess(String pTarget) {
    }

    public void checkSystemClipboardAccess() {
    }

    public boolean checkTopLevelWindow(Object pWindow) {
        return true;
    }
}

