/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.mindmapmode;

import freemind.controller.Controller;
import freemind.main.XMLParseException;
import freemind.modes.Mode;
import freemind.modes.ModeController;
import freemind.modes.mindmapmode.MindMapController;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.logging.Logger;

public class MindMapMode
extends Mode {
    private Controller c;
    private MindMapController modecontroller;
    private final String MODENAME = "MindMap";
    private boolean isRunning = false;
    private static Logger logger = null;

    public void init(Controller c) {
        this.c = c;
        if (logger == null) {
            logger = c.getFrame().getLogger(this.getClass().getName());
        }
        this.modecontroller = (MindMapController)this.createModeController();
    }

    public ModeController createModeController() {
        logger.finest("Creating new MindMapController...");
        MindMapController mindMapController = new MindMapController(this);
        logger.finest("Creating new MindMapController. Done:" + mindMapController);
        return mindMapController;
    }

    public String toString() {
        return "MindMap";
    }

    public void activate() {
        if (this.isRunning) {
            this.c.getMapModuleManager().changeToMapOfMode(this);
        } else {
            this.isRunning = true;
        }
    }

    public void restore(String restoreable) throws FileNotFoundException, XMLParseException, MalformedURLException, IOException, URISyntaxException {
        this.getDefaultModeController().load(new File(restoreable));
    }

    public Controller getController() {
        return this.c;
    }

    public ModeController getDefaultModeController() {
        return this.modecontroller;
    }
}

