/*
 * Decompiled with CFR 0.152.
 */
package freemind.controller.printpreview;

import freemind.controller.printpreview.Preview;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JLabel;

class BrowseAction
extends AbstractAction {
    private JLabel pageNumber;
    protected Preview preview;
    protected int pageStep;
    private final Runnable pageIndexPainter;

    public BrowseAction(Preview preview, JLabel pageNumber, int pageStep) {
        this.preview = preview;
        this.pageStep = pageStep;
        this.pageNumber = pageNumber;
        this.pageIndexPainter = new Runnable(){

            public void run() {
                BrowseAction.this.paintPageIndex();
            }
        };
    }

    public void actionPerformed(ActionEvent e) {
        this.preview.moveIndex(this.pageStep);
        this.paintPageIndex();
        this.preview.repaint();
        EventQueue.invokeLater(this.pageIndexPainter);
    }

    private void paintPageIndex() {
        this.pageNumber.setText(this.getPageIndexText());
        this.pageNumber.paintImmediately(0, 0, this.pageNumber.getWidth(), this.pageNumber.getHeight());
    }

    private String getPageIndexText() {
        return "- " + String.valueOf(1 + this.preview.getPageIndex()) + " -";
    }
}

