/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.search.resultpanel;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.RangeList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.swing.DefaultEventSelectionModel;
import ca.odell.glazedlists.swing.DefaultEventTableModel;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.jdesktop.application.Resource;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.limewire.collection.glazedlists.GlazedListsFactory;
import org.limewire.core.api.search.SearchCategory;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.ui.swing.components.Disposable;
import org.limewire.ui.swing.components.DisposalListener;
import org.limewire.ui.swing.components.RemoteHostWidget;
import org.limewire.ui.swing.components.RemoteHostWidgetFactory;
import org.limewire.ui.swing.downloads.DownloadMediator;
import org.limewire.ui.swing.library.LibraryMediator;
import org.limewire.ui.swing.search.SearchViewType;
import org.limewire.ui.swing.search.model.SearchResultsModel;
import org.limewire.ui.swing.search.model.VisualSearchResult;
import org.limewire.ui.swing.search.resultpanel.DownloadHandler;
import org.limewire.ui.swing.search.resultpanel.DownloadHandlerImpl;
import org.limewire.ui.swing.search.resultpanel.ResultsTable;
import org.limewire.ui.swing.search.resultpanel.ResultsTableFormat;
import org.limewire.ui.swing.search.resultpanel.ResultsTableFormatFactory;
import org.limewire.ui.swing.search.resultpanel.SearchPopupHandler;
import org.limewire.ui.swing.search.resultpanel.SearchResultMenuFactory;
import org.limewire.ui.swing.search.resultpanel.classic.ClassicDoubleClickHandler;
import org.limewire.ui.swing.search.resultpanel.classic.FromTableCellRenderer;
import org.limewire.ui.swing.search.resultpanel.classic.ResultEnterAction;
import org.limewire.ui.swing.search.resultpanel.list.ListViewDisplayedRowsLimit;
import org.limewire.ui.swing.search.resultpanel.list.ListViewRowHeightRule;
import org.limewire.ui.swing.search.resultpanel.list.ListViewTableEditorRenderer;
import org.limewire.ui.swing.search.resultpanel.list.ListViewTableEditorRendererFactory;
import org.limewire.ui.swing.search.resultpanel.list.ListViewTableFormat;
import org.limewire.ui.swing.table.CalendarRenderer;
import org.limewire.ui.swing.table.DefaultLimeTableCellRenderer;
import org.limewire.ui.swing.table.FileSizeRenderer;
import org.limewire.ui.swing.table.IconLabelRenderer;
import org.limewire.ui.swing.table.IconLabelRendererFactory;
import org.limewire.ui.swing.table.QualityRenderer;
import org.limewire.ui.swing.table.TableCellHeaderRenderer;
import org.limewire.ui.swing.table.TableColors;
import org.limewire.ui.swing.table.TimeRenderer;
import org.limewire.ui.swing.util.EventListJXTableSorting;
import org.limewire.ui.swing.util.GuiUtils;

public class BaseResultPanel
extends JXPanel {
    private static final int MAX_DISPLAYED_RESULT_SIZE = 500;
    private static final int TABLE_ROW_HEIGHT = 23;
    private static final int ROW_HEIGHT = ListViewRowHeightRule.RowDisplayConfig.HeadingAndMetadata.getRowHeight();
    private final ListViewTableEditorRendererFactory listViewTableEditorRendererFactory;
    private static final Log LOG = LogFactory.getLog(BaseResultPanel.class);
    private final ListViewTable resultsList;
    private SearchCategory listConfiguredFor;
    private final ResultsTable<VisualSearchResult> resultsTable;
    private SearchCategory tableConfiguredFor;
    private SearchCategory currentCategory;
    private final Map<VisualSearchResult, ListViewRowHeightRule.RowDisplayResult> vsrToRowDisplayResultMap = new HashMap<VisualSearchResult, ListViewRowHeightRule.RowDisplayResult>();
    private final SearchResultsModel searchResultsModel;
    private final ResultsTableFormatFactory tableFormatFactory;
    private final ListViewRowHeightRule rowHeightRule;
    private final RemoteHostWidgetFactory fromWidgetfactory;
    private final Provider<IconLabelRendererFactory> iconLabelRendererFactory;
    private final DownloadHandler downloadHandler;
    private final Provider<TimeRenderer> timeRenderer;
    private final Provider<FileSizeRenderer> fileSizeRenderer;
    private final Provider<CalendarRenderer> calendarRenderer;
    private final Provider<QualityRenderer> qualityRenderer;
    private final DefaultLimeTableCellRenderer defaultTableCellRenderer;
    private RangeList<VisualSearchResult> maxSizedList;
    private ListEventListener<VisualSearchResult> maxSizedListener;
    private DefaultEventSelectionModel<VisualSearchResult> listSelectionModel;
    private EventListJXTableSorting resultsTableSorting;
    private DefaultEventSelectionModel<VisualSearchResult> selectionModel;
    private ColorHighlighter resultsColorHighlighter;
    private Scrollable visibleComponent;
    private final SearchResultMenuFactory menuFactory;

    @Inject
    public BaseResultPanel(@Assisted SearchResultsModel searchResultsModel, ResultsTableFormatFactory tableFormatFactory, ListViewTableEditorRendererFactory listViewTableEditorRendererFactory, ListViewRowHeightRule rowHeightRule, RemoteHostWidgetFactory fromWidgetFactory, SearchResultMenuFactory menuFactory, Provider<IconLabelRendererFactory> iconLabelRendererFactory, Provider<TimeRenderer> timeRenderer, Provider<FileSizeRenderer> fileSizeRenderer, Provider<CalendarRenderer> calendarRenderer, LibraryMediator libraryMediator, Provider<QualityRenderer> qualityRenderer, DefaultLimeTableCellRenderer defaultTableCellRenderer, DownloadMediator downloadMediator) {
        this.searchResultsModel = searchResultsModel;
        this.tableFormatFactory = tableFormatFactory;
        this.listViewTableEditorRendererFactory = listViewTableEditorRendererFactory;
        this.rowHeightRule = rowHeightRule;
        this.fromWidgetfactory = fromWidgetFactory;
        this.iconLabelRendererFactory = iconLabelRendererFactory;
        this.downloadHandler = new DownloadHandlerImpl(searchResultsModel, libraryMediator, downloadMediator);
        this.timeRenderer = timeRenderer;
        this.fileSizeRenderer = fileSizeRenderer;
        this.calendarRenderer = calendarRenderer;
        this.qualityRenderer = qualityRenderer;
        this.defaultTableCellRenderer = defaultTableCellRenderer;
        this.menuFactory = menuFactory;
        rowHeightRule.initializeWithSearch(searchResultsModel.getSearchQuery());
        this.resultsList = this.createList();
        this.resultsTable = this.createTable();
        searchResultsModel.addDisposalListener(new ResultModelDisposalListener());
        this.setLayout(new BorderLayout());
    }

    private ListViewTable createList() {
        ListViewTable listTable = new ListViewTable();
        listTable.setShowGrid(true, false);
        listTable.setRowHeightEnabled(true);
        listTable.setEmptyRowsPainted(false);
        return listTable;
    }

    private ResultsTable<VisualSearchResult> createTable() {
        ResultsTable<VisualSearchResult> table = new ResultsTable<VisualSearchResult>();
        table.setPopupHandler(new SearchPopupHandler(this.downloadHandler, table, this.menuFactory));
        table.setDoubleClickHandler(new ClassicDoubleClickHandler(table, this.downloadHandler));
        table.setRowHeight(23);
        return table;
    }

    private void configureList() {
        int i;
        LOG.debugf("Configuring list view for {0}, configured already for {1}", (Object)this.currentCategory, (Object)this.listConfiguredFor);
        this.listConfiguredFor = this.currentCategory;
        if (this.maxSizedList != null) {
            this.maxSizedList.removeListEventListener(this.maxSizedListener);
        }
        final EventList<VisualSearchResult> sortedList = this.searchResultsModel.getSortedSearchResults();
        this.maxSizedList = GlazedListsFactory.rangeList(sortedList);
        this.maxSizedList.setHeadRange(0, 501);
        ListViewTableFormat tableFormat = new ListViewTableFormat();
        this.resultsList.setEventListFormat(this.maxSizedList, tableFormat, false);
        if (this.listSelectionModel != null) {
            this.listSelectionModel.dispose();
        }
        this.listSelectionModel = new DefaultEventSelectionModel<VisualSearchResult>(this.maxSizedList);
        this.listSelectionModel.setSelectionMode(103);
        this.resultsList.setSelectionModel(this.listSelectionModel);
        this.resultsList.setEnterKeyAction(new ResultEnterAction(this.listSelectionModel.getSelected(), this.downloadHandler));
        ListViewDisplayedRowsLimit displayLimit = new ListViewDisplayedRowsLimit(){

            @Override
            public int getLastDisplayedRow() {
                return 500;
            }

            @Override
            public int getTotalResultsReturned() {
                return sortedList.size();
            }
        };
        ListViewTableEditorRenderer renderer = this.listViewTableEditorRendererFactory.create(this.downloadHandler, this.rowHeightRule, displayLimit);
        ListViewTableEditorRenderer editor = this.listViewTableEditorRendererFactory.create(this.downloadHandler, this.rowHeightRule, displayLimit);
        TableColumnModel tcm = this.resultsList.getColumnModel();
        int columnCount = tableFormat.getColumnCount();
        for (i = 0; i < columnCount; ++i) {
            TableColumn tc = tcm.getColumn(i);
            tc.setCellRenderer(renderer);
            tc.setCellEditor(editor);
        }
        this.resultsList.setDefaultEditor((Class)VisualSearchResult.class, (TableCellEditor)editor);
        for (i = 0; i < tableFormat.getColumnCount(); ++i) {
            this.resultsList.getColumnModel().getColumn(i).setPreferredWidth(tableFormat.getInitialWidth(i));
        }
        this.maxSizedListener = new ListEventListener<VisualSearchResult>(){

            @Override
            public void listChanged(ListEvent<VisualSearchResult> listChanges) {
                DefaultEventTableModel tableModel = BaseResultPanel.this.resultsList.getEventTableModel();
                if (tableModel.getRowCount() == 0) {
                    return;
                }
                Runnable runner = new Runnable(){

                    @Override
                    public void run() {
                        DefaultEventTableModel model = BaseResultPanel.this.resultsList.getEventTableModel();
                        BaseResultPanel.this.resultsList.setIgnoreRepaints(true);
                        boolean setRowSize = false;
                        for (int row = 0; row < model.getRowCount(); ++row) {
                            VisualSearchResult vsr = (VisualSearchResult)model.getElementAt(row);
                            ListViewRowHeightRule.RowDisplayResult result = (ListViewRowHeightRule.RowDisplayResult)BaseResultPanel.this.vsrToRowDisplayResultMap.get(vsr);
                            if (result == null || result.isStale(vsr)) {
                                result = BaseResultPanel.this.rowHeightRule.getDisplayResult(vsr);
                                BaseResultPanel.this.vsrToRowDisplayResultMap.put(vsr, result);
                            }
                            int newRowHeight = result.getConfig().getRowHeight();
                            if (vsr.getSimilarityParent() != null || BaseResultPanel.this.resultsList.getRowHeight(row) == newRowHeight) continue;
                            BaseResultPanel.this.resultsList.setRowHeight(row, newRowHeight);
                            setRowSize = true;
                        }
                        BaseResultPanel.this.resultsList.setIgnoreRepaints(false);
                        if (setRowSize) {
                            if (BaseResultPanel.this.resultsList.isEditing()) {
                                BaseResultPanel.this.resultsList.editingCanceled(new ChangeEvent(BaseResultPanel.this.resultsList));
                            }
                            BaseResultPanel.this.resultsList.updateViewSizeSequence();
                            BaseResultPanel.this.resultsList.resizeAndRepaint();
                        }
                    }
                };
                SwingUtilities.invokeLater(runner);
            }
        };
        this.maxSizedList.addListEventListener(this.maxSizedListener);
        this.resultsList.setRowHeight(ROW_HEIGHT);
    }

    private void configureTable() {
        SortedList<VisualSearchResult> sortedList;
        LOG.debugf("Configuring table view for {0}, configured already for {1}", (Object)this.currentCategory, (Object)this.tableConfiguredFor);
        this.tableConfiguredFor = this.currentCategory;
        if (this.resultsTableSorting != null) {
            this.resultsTableSorting.uninstall();
        }
        if (this.resultsColorHighlighter != null) {
            this.resultsTable.removeHighlighter(this.resultsColorHighlighter);
        }
        SearchCategory selectedCategory = this.searchResultsModel.getSelectedCategory();
        EventList<VisualSearchResult> eventList = this.searchResultsModel.getFilteredSearchResults();
        ResultsTableFormat<VisualSearchResult> tableFormat = this.tableFormatFactory.createTableFormat(selectedCategory);
        SortedList<VisualSearchResult> downstreamList = sortedList = GlazedListsFactory.sortedList(eventList, null);
        this.resultsTable.setEventListFormat(downstreamList, tableFormat, true);
        this.resultsTableSorting = EventListJXTableSorting.install(this.resultsTable, sortedList, tableFormat);
        if (this.selectionModel != null) {
            this.selectionModel.dispose();
        }
        this.selectionModel = new DefaultEventSelectionModel<VisualSearchResult>(downstreamList);
        this.resultsTable.setSelectionModel(this.selectionModel);
        this.resultsTable.setEnterKeyAction(new ResultEnterAction(this.selectionModel.getSelected(), this.downloadHandler));
        this.setupCellRenderers(tableFormat);
        this.resultsTable.applySavedColumnSettings();
        TableColors tableColors = new TableColors();
        this.resultsColorHighlighter = new ColorHighlighter(new DownloadedHighlightPredicate(downstreamList), null, tableColors.getDisabledForegroundColor(), null, tableColors.getDisabledForegroundColor());
        this.resultsTable.addHighlighter(this.resultsColorHighlighter);
    }

    protected void setupCellRenderers(ResultsTableFormat<VisualSearchResult> tableFormat) {
        SearchCategory selectedCategory;
        IconLabelRenderer nameRenderer = this.iconLabelRendererFactory.get().createIconRenderer((selectedCategory = this.searchResultsModel.getSelectedCategory()) == SearchCategory.ALL);
        int columnCount = tableFormat.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            Class clazz = tableFormat.getColumnClass(i);
            if (clazz == String.class || clazz == Integer.class || clazz == Long.class) {
                this.setCellRenderer(i, this.defaultTableCellRenderer);
                this.setCellEditor(i, null);
                continue;
            }
            if (clazz == Calendar.class) {
                this.setCellRenderer(i, this.calendarRenderer.get());
                this.setCellEditor(i, null);
                continue;
            }
            if (i == tableFormat.getNameColumn()) {
                this.setCellRenderer(i, nameRenderer);
                this.setCellEditor(i, null);
                continue;
            }
            if (!VisualSearchResult.class.isAssignableFrom(clazz)) continue;
            this.setCellRenderer(i, new FromTableCellRenderer(this.fromWidgetfactory.create(RemoteHostWidget.RemoteWidgetType.TABLE)));
            this.setCellEditor(i, new FromTableCellRenderer(this.fromWidgetfactory.create(RemoteHostWidget.RemoteWidgetType.TABLE)));
        }
        switch (selectedCategory) {
            case ALL: {
                this.setCellRenderer(4, this.fileSizeRenderer.get());
                break;
            }
            case AUDIO: {
                this.setHeaderRenderer(4, new TableCellHeaderRenderer(11));
                this.setCellRenderer(12, this.fileSizeRenderer.get());
                this.setCellRenderer(4, this.timeRenderer.get());
                this.setCellRenderer(5, this.qualityRenderer.get());
                break;
            }
            case VIDEO: {
                this.setHeaderRenderer(4, new TableCellHeaderRenderer(11));
                this.setCellRenderer(6, this.fileSizeRenderer.get());
                this.setCellRenderer(4, this.timeRenderer.get());
                this.setCellRenderer(5, this.qualityRenderer.get());
                break;
            }
            case DOCUMENT: {
                this.setCellRenderer(4, this.fileSizeRenderer.get());
                break;
            }
            case IMAGE: {
                this.setCellRenderer(4, this.fileSizeRenderer.get());
                break;
            }
            case PROGRAM: {
                this.setCellRenderer(2, this.fileSizeRenderer.get());
                break;
            }
            case OTHER: {
                this.setCellRenderer(4, this.fileSizeRenderer.get());
                break;
            }
        }
    }

    protected void setCellRenderer(int column, TableCellRenderer cellRenderer) {
        TableColumnModel tcm = this.resultsTable.getColumnModel();
        TableColumn tc = tcm.getColumn(column);
        tc.setCellRenderer(cellRenderer);
    }

    protected void setCellEditor(int column, TableCellEditor editor) {
        TableColumnModel tcm = this.resultsTable.getColumnModel();
        TableColumn tc = tcm.getColumn(column);
        tc.setCellEditor(editor);
    }

    protected void setHeaderRenderer(int column, TableCellRenderer headerRenderer) {
        TableColumnModel tcm = this.resultsTable.getColumnModel();
        TableColumn tc = tcm.getColumn(column);
        tc.setHeaderRenderer(headerRenderer);
    }

    public void showCategory(SearchCategory searchCategory) {
        if (this.currentCategory != searchCategory) {
            this.currentCategory = searchCategory;
            this.searchResultsModel.setSelectedCategory(searchCategory);
            if (this.listConfiguredFor != null || this.visibleComponent == this.resultsList) {
                this.configureList();
            }
            if (this.tableConfiguredFor != null || this.visibleComponent == this.resultsTable) {
                this.configureTable();
            }
        } else {
            LOG.debugf("Resetting current category {0}!", (Object)this.currentCategory);
        }
    }

    public void setViewType(SearchViewType mode) {
        if (this.visibleComponent != null) {
            this.remove((Component)((Object)this.visibleComponent));
        }
        switch (mode) {
            case LIST: {
                if (this.currentCategory != null && this.listConfiguredFor != this.currentCategory) {
                    this.configureList();
                }
                this.visibleComponent = this.resultsList;
                break;
            }
            case TABLE: {
                if (this.currentCategory != null && this.tableConfiguredFor != this.currentCategory) {
                    this.configureTable();
                }
                this.visibleComponent = this.resultsTable;
                break;
            }
            default: {
                throw new IllegalStateException("unsupported mode: " + (Object)((Object)mode));
            }
        }
        this.add((Component)((Object)this.visibleComponent));
    }

    public Component getScrollPaneHeader() {
        return this.visibleComponent == this.resultsTable ? this.resultsTable.getTableHeader() : null;
    }

    public Scrollable getScrollable() {
        return this.visibleComponent;
    }

    public static class ListViewTable
    extends ResultsTable<VisualSearchResult> {
        @Resource
        private Color similarResultParentBackgroundColor;
        private boolean ignoreRepaints;

        public ListViewTable() {
            GuiUtils.assignResources(this);
            this.setGridColor(Color.decode("#EBEBEB"));
            this.setHighlighters(new ColorHighlighter(this.getBackground(), null, this.getTableColors().selectionColor, null), new ColorHighlighter(new HighlightPredicate(){

                @Override
                public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                    VisualSearchResult vsr = (VisualSearchResult)ListViewTable.this.getValueAt(adapter.row, 0);
                    return vsr != null && vsr.isChildrenVisible();
                }
            }, this.similarResultParentBackgroundColor, null, this.getTableColors().selectionColor, null));
        }

        @Override
        protected void paintEmptyRows(Graphics g) {
        }

        private void setIgnoreRepaints(boolean ignore) {
            this.ignoreRepaints = ignore;
        }

        @Override
        protected void updateViewSizeSequence() {
            if (this.ignoreRepaints) {
                return;
            }
            super.updateViewSizeSequence();
        }

        @Override
        protected void resizeAndRepaint() {
            if (this.ignoreRepaints) {
                return;
            }
            super.resizeAndRepaint();
        }
    }

    private static class DownloadedHighlightPredicate
    implements HighlightPredicate {
        private EventList<VisualSearchResult> eventList;

        public DownloadedHighlightPredicate(EventList<VisualSearchResult> sortedList) {
            this.eventList = sortedList;
        }

        @Override
        public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
            VisualSearchResult result = (VisualSearchResult)this.eventList.get(adapter.row);
            return result.isSpam();
        }
    }

    private class ResultModelDisposalListener
    implements DisposalListener {
        private ResultModelDisposalListener() {
        }

        @Override
        public void objectDisposed(Disposable source) {
            if (BaseResultPanel.this.listSelectionModel != null) {
                BaseResultPanel.this.listSelectionModel.dispose();
            }
            if (BaseResultPanel.this.selectionModel != null) {
                BaseResultPanel.this.selectionModel.dispose();
            }
        }
    }
}

