/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.properties;

import org.limewire.core.api.FilePropertyKey;
import org.limewire.core.api.library.PropertiableFile;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.util.CommonUtils;

public class FileInfoUtils {
    public static String convertDate(PropertiableFile propertiable) {
        Object time = propertiable.getProperty(FilePropertyKey.DATE_CREATED);
        if (time instanceof Long) {
            return GuiUtils.msec2DateTime((Long)time);
        }
        return "";
    }

    public static String getLength(PropertiableFile propertiableFile) {
        Long length = (Long)propertiableFile.getProperty(FilePropertyKey.LENGTH);
        return length != null ? CommonUtils.seconds2time(length) : null;
    }

    public static String getFileSize(PropertiableFile propertiable) {
        Long fileSize = FileInfoUtils.getFileSizeLong(propertiable);
        if (fileSize != null) {
            return GuiUtils.formatUnitFromBytes(fileSize);
        }
        return "";
    }

    public static String getFileSizeBytes(PropertiableFile propertiable) {
        Long fileSize = FileInfoUtils.getFileSizeLong(propertiable);
        if (fileSize != null) {
            return GuiUtils.formatBytes(fileSize);
        }
        return "";
    }

    private static Long getFileSizeLong(PropertiableFile propertiable) {
        return (Long)propertiable.getProperty(FilePropertyKey.FILE_SIZE);
    }

    public static String getQuality(PropertiableFile propertiableFile) {
        Long qualityScore = FileInfoUtils.getQualityScoreLong(propertiableFile);
        return qualityScore != null ? GuiUtils.toQualityString(qualityScore) : null;
    }

    private static Long getQualityScoreLong(PropertiableFile propertiable) {
        return (Long)propertiable.getProperty(FilePropertyKey.QUALITY);
    }
}

