/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.painter;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import javax.swing.Action;
import javax.swing.Icon;
import org.jdesktop.swingx.JXButton;
import org.jdesktop.swingx.painter.AbstractPainter;
import org.limewire.ui.swing.components.LimeComboBox;
import org.limewire.ui.swing.util.FontUtils;

public class ButtonForegroundPainter
extends AbstractPainter<JXButton> {
    private final Paint pressedForeground;
    private final Paint hoverForeground;
    private final Paint disabledForeground;
    private final FontTransform pressedTransform;
    private final FontTransform hoverTransform;
    private final FontTransform disabledTransform;
    private Font fontCache = null;
    private Font pressedFontCache = null;
    private Font hoverFontCache = null;
    private Font disabledFontCache = null;

    public ButtonForegroundPainter() {
        this(null, null, null);
    }

    public ButtonForegroundPainter(Paint hoverForeground, Paint pressedForeground, Paint disabledForeground) {
        this(hoverForeground, pressedForeground, disabledForeground, FontTransform.NO_CHANGE, FontTransform.NO_CHANGE, FontTransform.NO_CHANGE);
    }

    public ButtonForegroundPainter(Paint hoverForeground, Paint pressedForeground, Paint disabledForeground, FontTransform hoverTransform, FontTransform pressedTransform, FontTransform disabledTransform) {
        this.pressedForeground = pressedForeground;
        this.hoverForeground = hoverForeground;
        this.disabledForeground = disabledForeground;
        this.pressedTransform = pressedTransform;
        this.hoverTransform = hoverTransform;
        this.disabledTransform = disabledTransform;
        this.setCacheable(false);
    }

    private Font deriveTransform(Font font, FontTransform transform) {
        switch (transform) {
            case NO_CHANGE: {
                return font;
            }
            case ADD_UNDERLINE: {
                return FontUtils.deriveUnderline(font, true);
            }
            case REMOVE_UNDERLINE: {
                return FontUtils.deriveUnderline(font, false);
            }
        }
        return font;
    }

    private void reloadFontCache(Font font) {
        this.fontCache = font;
        this.disabledFontCache = this.deriveTransform(font, this.disabledTransform);
        this.pressedFontCache = this.deriveTransform(font, this.pressedTransform);
        this.hoverFontCache = this.deriveTransform(font, this.hoverTransform);
    }

    @Override
    protected void doPaint(Graphics2D g, JXButton object, int width, int height) {
        int textBaseline = (object.getHeight() - 3) / 2 + g.getFontMetrics().getAscent() / 2;
        Icon icon = null;
        Paint foreground = null;
        Font font = object.getFont();
        if (font != this.fontCache) {
            this.reloadFontCache(font);
        }
        if (!object.isEnabled()) {
            foreground = this.disabledForeground;
            font = this.disabledFontCache;
        } else if (object.getModel().isPressed() || object.getModel().isSelected()) {
            icon = object.getPressedIcon();
            foreground = this.pressedForeground;
            font = this.pressedFontCache;
        } else if (object.getModel().isRollover() || object.hasFocus()) {
            icon = object.getRolloverIcon();
            foreground = this.hoverForeground;
            font = this.hoverFontCache;
        } else {
            icon = object.getIcon();
        }
        if (foreground == null) {
            foreground = object.getForeground();
        }
        g.setPaint(foreground);
        g.setFont(font);
        if (object.getText() != null) {
            g.drawString(object.getText(), object.getInsets().left, textBaseline);
            if (icon != null) {
                icon.paintIcon(object, g, object.getWidth() - icon.getIconWidth() / 2 - 10, object.getHeight() / 2 - icon.getIconHeight() / 2);
            }
        } else if (object instanceof LimeComboBox) {
            LimeComboBox box = (LimeComboBox)object;
            Action action = box.getSelectedAction();
            if (action != null) {
                Icon actionIcon = (Icon)action.getValue("SmallIcon");
                int leftGap = object.getInsets().left;
                if (actionIcon != null) {
                    actionIcon.paintIcon(box, g, leftGap, (box.getHeight() - actionIcon.getIconHeight()) / 2);
                    leftGap += actionIcon.getIconWidth() + 4;
                }
                g.drawString((String)action.getValue("Name"), leftGap, textBaseline);
            }
            if (icon != null) {
                icon.paintIcon(box, g, box.getWidth() - object.getInsets().right + icon.getIconWidth(), box.getHeight() / 2 - icon.getIconHeight() / 2);
            }
        }
    }

    public static enum FontTransform {
        NO_CHANGE,
        ADD_UNDERLINE,
        REMOVE_UNDERLINE;

    }
}

