/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.options;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.DefaultEventTableModel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXTable;
import org.limewire.ui.swing.components.HyperlinkButton;
import org.limewire.ui.swing.options.OptionPanel;
import org.limewire.ui.swing.table.AbstractTableFormat;
import org.limewire.ui.swing.table.MouseableTable;
import org.limewire.ui.swing.util.I18n;

public abstract class AbstractFilterOptionPanel
extends OptionPanel {
    protected EventList<String> eventList = GlazedLists.threadSafeList(new BasicEventList());

    protected class RemoveButtonRenderer
    extends JPanel
    implements TableCellRenderer,
    TableCellEditor {
        private final List<CellEditorListener> listeners = new ArrayList<CellEditorListener>();
        private final HyperlinkButton button = new HyperlinkButton(I18n.tr("remove"));

        public RemoveButtonRenderer(final JXTable table) {
            this.button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int index = table.rowAtPoint(table.getMousePosition());
                    AbstractFilterOptionPanel.this.eventList.remove(index);
                    RemoveButtonRenderer.this.cancelCellEditing();
                }
            });
            this.setLayout(new MigLayout("insets 2 5 2 5, hidemode 0, align 50%"));
            this.add(this.button);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.button.setVisible(AbstractFilterOptionPanel.this.eventList.contains(value));
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setBackground(table.getBackground());
            }
            return this;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.button.setVisible(AbstractFilterOptionPanel.this.eventList.contains(value));
            this.setBackground(table.getSelectionBackground());
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancelCellEditing() {
            List<CellEditorListener> list = this.listeners;
            synchronized (list) {
                int N = this.listeners.size();
                for (int i = 0; i < N; ++i) {
                    this.listeners.get(i).editingCanceled(new ChangeEvent(this));
                }
            }
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeCellEditorListener(CellEditorListener lis) {
            List<CellEditorListener> list = this.listeners;
            synchronized (list) {
                if (this.listeners.contains(lis)) {
                    this.listeners.remove(lis);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addCellEditorListener(CellEditorListener lis) {
            List<CellEditorListener> list = this.listeners;
            synchronized (list) {
                if (!this.listeners.contains(lis)) {
                    this.listeners.add(lis);
                }
            }
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return true;
        }

        @Override
        public boolean stopCellEditing() {
            this.cancelCellEditing();
            return true;
        }
    }

    protected static class FilterTableFormat
    extends AbstractTableFormat<String> {
        private static final int NAME_INDEX = 0;
        private static final int BUTTON_INDEX = 1;

        public FilterTableFormat(String firstColumnTitle) {
            super(firstColumnTitle, "");
        }

        @Override
        public Object getColumnValue(String baseObject, int column) {
            switch (column) {
                case 0: {
                    return baseObject;
                }
                case 1: {
                    return baseObject;
                }
            }
            throw new IllegalStateException("Unknown column:" + column);
        }
    }

    protected class FilterTable
    extends MouseableTable {
        public FilterTable(DefaultEventTableModel<String> model) {
            super(model);
            this.setShowGrid(false, false);
            this.setColumnSelectionAllowed(false);
            this.setSelectionMode(0);
            this.getColumn(1).setCellRenderer(new RemoveButtonRenderer(this));
            this.getColumn(1).setCellEditor(new RemoveButtonRenderer(this));
        }
    }
}

