/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.images;

import com.google.inject.Provider;
import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import org.limewire.core.api.library.LocalFileItem;
import org.limewire.ui.swing.images.ImageList;
import org.limewire.ui.swing.library.table.LibraryPopupMenu;
import org.limewire.ui.swing.table.TablePopupHandler;

class ImagePopupHandler
implements TablePopupHandler {
    private final ImageList imageList;
    private final Provider<LibraryPopupMenu> popupMenu;

    public ImagePopupHandler(ImageList imageList, Provider<LibraryPopupMenu> popupMenu) {
        this.imageList = imageList;
        this.popupMenu = popupMenu;
    }

    @Override
    public boolean isPopupShowing(int row) {
        return false;
    }

    @Override
    public void maybeShowPopup(Component component, int x, int y) {
        int popupRow = this.imageList.locationToIndex(new Point(x, y));
        if (popupRow < 0) {
            return;
        }
        LocalFileItem selectedItem = (LocalFileItem)this.imageList.getModel().getElementAt(popupRow);
        ArrayList<LocalFileItem> selectedItems = new ArrayList<LocalFileItem>(this.imageList.getSelectedItems());
        if (selectedItems.size() <= 1 || !selectedItems.contains(selectedItem)) {
            selectedItems.clear();
            this.imageList.setSelectedIndex(popupRow);
        }
        this.popupMenu.get().show(component, x, y);
    }
}

