/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.visual;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import java.net.SocketAddress;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.limewire.mojito.KUID;
import org.limewire.mojito.io.MessageDispatcher;
import org.limewire.mojito.messages.DHTMessage;
import org.limewire.mojito.visual.Painter;

class PlasmaLamp
extends Painter {
    private static final long ATTACK = 250L;
    private static final long RELEASE = 2750L;
    private static final long DURATION = 3000L;
    private static final float DOT_SIZE = 6.0f;
    private static final Random GENERATOR = new Random();
    private final List<Node> nodes = new LinkedList<Node>();
    private final Point2D.Double localhost = new Point2D.Double();
    private final Ellipse2D.Double ellipse = new Ellipse2D.Double();
    private final Ellipse2D.Double dot = new Ellipse2D.Double();
    private final KUID nodeId;

    public PlasmaLamp(KUID nodeId) {
        this.nodeId = nodeId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Component c, Graphics2D g2) {
        double width = c.getWidth();
        double height = c.getHeight();
        double gap = 50.0;
        double radius = Math.max(Math.min(width / 2.0, height / 2.0) - gap, gap);
        double arc_x = width / 2.0 - radius;
        double arc_y = height / 2.0 - radius;
        double arc_width = 2.0 * radius;
        double arc_height = 2.0 * radius;
        g2.setColor(Color.orange);
        g2.setStroke(TWO_PIXEL_STROKE);
        this.ellipse.setFrame(arc_x, arc_y, arc_width, arc_height);
        g2.draw(this.ellipse);
        double fi = PlasmaLamp.position(this.nodeId, Math.PI * 2) - 1.5707963267948966;
        double dx = width / 2.0 + radius * Math.cos(fi);
        double dy = height / 2.0 + radius * Math.sin(fi);
        this.localhost.setLocation(dx, dy);
        this.dot.setFrame(dx - 3.0, dy - 3.0, 6.0, 6.0);
        List<Node> list = this.nodes;
        synchronized (list) {
            Iterator<Node> it = this.nodes.iterator();
            while (it.hasNext()) {
                if (!it.next().paint(this.localhost, width, height, radius, g2)) continue;
                it.remove();
            }
        }
        g2.setColor(Color.orange);
        g2.setStroke(DEFAULT_STROKE);
        g2.fill(this.dot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(MessageDispatcher.MessageDispatcherEvent.EventType type, KUID nodeId, SocketAddress dst, DHTMessage.OpCode opcode, boolean request) {
        if (nodeId == null) {
            return;
        }
        List<Node> list = this.nodes;
        synchronized (list) {
            this.nodes.add(new Node(this.dot, type, nodeId, opcode, request));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        List<Node> list = this.nodes;
        synchronized (list) {
            this.nodes.clear();
        }
    }

    private static class Node {
        private final Ellipse2D.Double dot;
        private final MessageDispatcher.MessageDispatcherEvent.EventType type;
        private final KUID nodeId;
        private final boolean request;
        private final int noise;
        private final long timeStamp = System.currentTimeMillis();
        private final Point2D.Double remote = new Point2D.Double();
        private final Point2D.Double point = new Point2D.Double();
        private final QuadCurve2D.Double curve = new QuadCurve2D.Double();
        private final Ellipse2D.Double circle = new Ellipse2D.Double();
        private final Ellipse2D.Double prxDot = new Ellipse2D.Double();
        private final Stroke stroke;

        public Node(Ellipse2D.Double dot, MessageDispatcher.MessageDispatcherEvent.EventType type, KUID nodeId, DHTMessage.OpCode opcode, boolean request) {
            this.dot = dot;
            this.type = type;
            this.nodeId = nodeId;
            this.request = request;
            this.stroke = Painter.getStrokeForOpCode(opcode);
            int noise = GENERATOR.nextInt(50);
            if (GENERATOR.nextBoolean()) {
                noise = -noise;
            }
            this.noise = noise;
        }

        private int alpha() {
            long delta = System.currentTimeMillis() - this.timeStamp;
            if (delta < 250L) {
                return (int)(1.02f * (float)delta);
            }
            return Math.max(255 - (int)(0.085f * (float)delta), 0);
        }

        private double radius() {
            double r = 20.0;
            long delta = System.currentTimeMillis() - this.timeStamp;
            if (delta < 3000L) {
                return 0.006666666666666667 * (double)delta;
            }
            return 20.0;
        }

        public boolean paint(Point2D.Double localhost, double width, double height, double radius, Graphics2D g2) {
            double cx = width / 2.0;
            double cy = height / 2.0;
            double fi = Painter.position(this.nodeId, Math.PI * 2) - 1.5707963267948966;
            double dx = cx + radius * Math.cos(fi);
            double dy = cy + radius * Math.sin(fi);
            int red = 0;
            int green = 0;
            int blue = 0;
            if (this.type.equals((Object)MessageDispatcher.MessageDispatcherEvent.EventType.MESSAGE_SENT)) {
                red = 255;
                if (!this.request) {
                    blue = 255;
                }
            } else {
                green = 255;
                if (this.request) {
                    blue = 255;
                }
            }
            this.remote.setLocation(dx, dy);
            Point2D.Double corner = new Point2D.Double(localhost.x + 3.0 * this.dot.width, localhost.y + 3.0 * this.dot.height);
            this.prxDot.setFrameFromCenter(localhost, corner);
            Shape shape = null;
            if (!this.prxDot.contains(this.remote)) {
                this.point.setLocation(cx + (double)this.noise, cy + (double)this.noise);
                this.curve.setCurve(localhost, this.point, this.remote);
                shape = this.curve;
            } else {
                double r = this.radius();
                this.point.setLocation(localhost.x + r, localhost.y + r);
                this.circle.setFrameFromCenter(localhost, this.point);
                shape = this.circle;
            }
            if (shape != null) {
                g2.setStroke(this.stroke);
                g2.setColor(new Color(red, green, blue, this.alpha()));
                g2.draw(shape);
            }
            return System.currentTimeMillis() - this.timeStamp >= 3000L;
        }
    }
}

