/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.core.impl.library;

import ca.odell.glazedlists.BasicEventList;
import com.google.inject.Inject;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.library.FileCollection;
import com.limegroup.gnutella.library.FileDesc;
import com.limegroup.gnutella.library.IncompleteFileDesc;
import com.limegroup.gnutella.library.Library;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.List;
import org.limewire.core.api.library.FileProcessingEvent;
import org.limewire.core.api.library.LibraryFileList;
import org.limewire.core.api.library.LocalFileItem;
import org.limewire.core.api.library.RemoteLibraryState;
import org.limewire.core.impl.library.CoreLocalFileItemFactory;
import org.limewire.core.impl.library.LocalFileListImpl;
import org.limewire.listener.EventListener;
import org.limewire.listener.SwingSafePropertyChangeSupport;

class LibraryFileListImpl
extends LocalFileListImpl
implements LibraryFileList {
    private final Library managedList;
    private final PropertyChangeSupport changeSupport = new SwingSafePropertyChangeSupport(this);
    private volatile RemoteLibraryState libraryState = RemoteLibraryState.LOADING;

    @Inject
    LibraryFileListImpl(Library managedList, CoreLocalFileItemFactory coreLocalFileItemFactory) {
        super(new BasicEventList<LocalFileItem>(), coreLocalFileItemFactory);
        this.managedList = managedList;
        this.managedList.addListener(this.newEventListener());
        this.managedList.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                RemoteLibraryState oldState = LibraryFileListImpl.this.libraryState;
                if (evt.getPropertyName().equals("hasPending")) {
                    if (Boolean.TRUE.equals(evt.getNewValue())) {
                        LibraryFileListImpl.this.libraryState = RemoteLibraryState.LOADING;
                    } else {
                        LibraryFileListImpl.this.libraryState = RemoteLibraryState.LOADED;
                    }
                }
                LibraryFileListImpl.this.changeSupport.firePropertyChange("state", (Object)oldState, (Object)LibraryFileListImpl.this.libraryState);
            }
        });
    }

    @Override
    protected void changeFileDesc(FileDesc old, FileDesc now) {
        super.changeFileDesc(old, now);
        this.changeSupport.firePropertyChange("rename", old.getFile(), now.getFile());
    }

    @Override
    protected FileCollection getCoreCollection() {
        return this.managedList;
    }

    @Override
    public void fileRenamed(File oldFile, File newFile) {
        this.managedList.fileRenamed(oldFile, newFile);
    }

    @Override
    protected boolean containsCoreUrn(URN urn) {
        List<FileDesc> fds = this.managedList.getFileDescsMatching(urn);
        for (FileDesc fd : fds) {
            if (fd instanceof IncompleteFileDesc) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public RemoteLibraryState getState() {
        return this.libraryState;
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public void addFileProcessingListener(EventListener<FileProcessingEvent> listener) {
        this.managedList.addFileProcessingListener(listener);
    }

    @Override
    public void removeFileProcessingListener(EventListener<FileProcessingEvent> listener) {
        this.managedList.removeFileProcessingListener(listener);
    }

    @Override
    public void cancelPendingTasks() {
        this.managedList.cancelPendingTasks();
    }
}

