/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.bittorrent.bencoding;

import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import org.limewire.bittorrent.bencoding.Token;

public abstract class BEAbstractCollection<T>
extends Token<T> {
    protected boolean done;
    private Token<?> currentElement;

    public BEAbstractCollection(ReadableByteChannel chan) {
        super(chan);
        this.result = this.createCollection();
    }

    protected abstract T createCollection();

    protected abstract void add(Object var1);

    protected abstract Token<?> getNewElement() throws IOException;

    @Override
    protected boolean isDone() {
        return this.done;
    }

    @Override
    public void handleRead() throws IOException {
        if (this.isDone()) {
            throw new IllegalStateException("token is done, don't read to it");
        }
        while (true) {
            if (this.currentElement == null) {
                this.currentElement = this.getNewElement();
            }
            if (this.currentElement == null) {
                return;
            }
            if (this.currentElement.getResult() == Token.TERMINATOR) {
                this.done = true;
                return;
            }
            this.currentElement.handleRead();
            Object result = this.currentElement.getResult();
            if (result == null) {
                return;
            }
            if (result == Token.TERMINATOR) {
                this.done = true;
                return;
            }
            this.add(result);
            this.currentElement = null;
        }
    }
}

