/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.browser;

import java.awt.Canvas;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlException;
import java.util.Vector;
import org.jdesktop.jdic.browser.BrowserEngineManager;
import org.jdesktop.jdic.browser.IBrowserEngine;
import org.jdesktop.jdic.browser.IWebBrowser;
import org.jdesktop.jdic.browser.WebBrowserEvent;
import org.jdesktop.jdic.browser.WebBrowserListener;
import org.jdesktop.jdic.browser.internal.NativeEventThread;
import org.jdesktop.jdic.browser.internal.WebBrowserUtil;
import org.jdesktop.jdic.init.JdicInitException;
import org.jdesktop.jdic.init.JdicManager;

public class WebBrowser
extends Canvas
implements IWebBrowser {
    private static final String FILE_PROTOCOL = "file:///";
    private static final String FILE = "file";
    private MyFocusListener focusListener = new MyFocusListener();
    private static NativeEventThread eventThread;
    private Vector webBrowserListeners = new Vector();
    private int instanceNum;
    private static int lastInstanceNum;
    private boolean isInitialized = false;
    private boolean isBackEnabled = false;
    private boolean isForwardEnabled = false;
    private boolean synchronize = false;
    private String initFailureMessage = "WebBrowser is not initialized.";
    private boolean autoDispose = true;
    private URL urlBeforeDispose = null;

    public void setInitialized(boolean bl) {
        this.isInitialized = bl;
    }

    public void setInitFailureMessage(String string) {
        this.initFailureMessage = string;
    }

    public WebBrowser() {
        this(true);
    }

    public WebBrowser(boolean bl) {
        this(null, bl);
    }

    public WebBrowser(URL uRL) {
        this(uRL, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebBrowser(URL uRL, boolean bl) {
        this.autoDispose = bl;
        Class clazz = WebBrowser.class;
        synchronized (clazz) {
            this.instanceNum = lastInstanceNum++;
        }
        eventThread.attachWebBrowser(this);
        if (0 == this.instanceNum) {
            eventThread.start();
            eventThread.fireNativeEvent(this.instanceNum, 0);
        }
        if (null != uRL) {
            this.setURL(uRL);
        }
        this.setFocusable(true);
        this.addFocusListener(this.focusListener);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (!this.isInitialized) {
            eventThread.fireNativeEvent(this.instanceNum, 1);
            if (this.urlBeforeDispose != null) {
                this.setURL(this.urlBeforeDispose);
                this.urlBeforeDispose = null;
            }
        }
        if (!this.autoDispose) {
            this.setVisible(true);
        }
    }

    public void addNotify() {
        super.addNotify();
    }

    public void removeNotify() {
        if (this.autoDispose) {
            this.dispose();
        } else {
            this.setVisible(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.urlBeforeDispose = this.getURL();
        WebBrowser webBrowser = this;
        synchronized (webBrowser) {
            eventThread.fireNativeEvent(this.instanceNum, 2);
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        WebBrowser.super.removeNotify();
        this.setInitialized(false);
    }

    public boolean isAutoDispose() {
        return this.autoDispose;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        eventThread.fireNativeEvent(this.instanceNum, 4, new Rectangle(n, n2, n3, n4));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchWebBrowserEvent(WebBrowserEvent webBrowserEvent) {
        Vector vector;
        int n;
        int n2 = webBrowserEvent.getID();
        WebBrowserUtil.trace("Dispatch event from NativeEventThread: " + n2);
        String string = "@" + this.instanceNum + "," + n2 + ",";
        URL uRL = null;
        if (3001 == n2) {
            try {
                uRL = new URL(webBrowserEvent.getData());
            }
            catch (MalformedURLException malformedURLException) {
                try {
                    uRL = new URL(BrowserEngineManager.instance().getActiveEngine().getFileProtocolURLPrefix() + webBrowserEvent.getData());
                }
                catch (MalformedURLException malformedURLException2) {
                    WebBrowserUtil.trace(malformedURLException2.toString());
                }
            }
            string = string + (this.willOpenURL(uRL) ? "0" : "1");
            eventThread.getMessenger().sendMessage(string);
            return;
        }
        if (3002 == n2) {
            if (webBrowserEvent.getData() != null) {
                try {
                    uRL = new URL(webBrowserEvent.getData());
                }
                catch (MalformedURLException malformedURLException) {
                    malformedURLException.printStackTrace();
                }
            }
            string = string + (this.willOpenWindow(uRL) ? "0" : "1");
            eventThread.getMessenger().sendMessage(string);
            return;
        }
        if (3022 == n2) {
            String string2 = webBrowserEvent.getData();
            if (string2.startsWith("forward")) {
                this.isForwardEnabled = string2.substring(8).equals("1");
                WebBrowserUtil.trace("Forward State changed = " + this.isForwardEnabled);
            } else if (string2.startsWith("back")) {
                this.isBackEnabled = string2.substring(5).equals("1");
                WebBrowserUtil.trace("Back State changed = " + this.isBackEnabled);
            }
            return;
        }
        if (3043 == n2) {
            WebBrowserUtil.trace("Got event from brower: Focus request.");
            this.requestFocus();
            return;
        }
        if (3044 == n2) {
            WebBrowserUtil.trace("Got event from brower: Destory window succeeds.");
            WebBrowser webBrowser = this;
            synchronized (webBrowser) {
                this.notify();
            }
        }
        WebBrowser webBrowser = this;
        synchronized (webBrowser) {
            n = this.webBrowserListeners.size();
            if (n == 0) {
                return;
            }
            vector = (Vector)this.webBrowserListeners.clone();
        }
        block22: for (int i = 0; i < n; ++i) {
            WebBrowserListener webBrowserListener = (WebBrowserListener)vector.elementAt(i);
            switch (n2) {
                case 3042: {
                    webBrowserListener.initializationCompleted(webBrowserEvent);
                    continue block22;
                }
                case 3003: {
                    webBrowserListener.downloadStarted(webBrowserEvent);
                    continue block22;
                }
                case 3004: {
                    webBrowserListener.downloadCompleted(webBrowserEvent);
                    continue block22;
                }
                case 3005: {
                    webBrowserListener.downloadProgress(webBrowserEvent);
                    continue block22;
                }
                case 3006: {
                    webBrowserListener.downloadError(webBrowserEvent);
                    continue block22;
                }
                case 3007: {
                    webBrowserListener.documentCompleted(webBrowserEvent);
                    continue block22;
                }
                case 3023: {
                    webBrowserListener.titleChange(webBrowserEvent);
                    continue block22;
                }
                case 3024: {
                    webBrowserListener.statusTextChange(webBrowserEvent);
                }
            }
        }
    }

    public synchronized void addWebBrowserListener(WebBrowserListener webBrowserListener) {
        if (!this.webBrowserListeners.contains(webBrowserListener)) {
            this.webBrowserListeners.addElement(webBrowserListener);
        }
    }

    public synchronized void removeWebBrowserListener(WebBrowserListener webBrowserListener) {
        if (webBrowserListener == null) {
            return;
        }
        this.webBrowserListeners.removeElement(webBrowserListener);
    }

    public WebBrowserListener[] getWebBrowserListeners() {
        return this.webBrowserListeners.toArray(new WebBrowserListener[0]);
    }

    public URL getURL() {
        eventThread.fireNativeEvent(this.instanceNum, 12);
        if (this.waitForResult()) {
            try {
                return new URL(eventThread.getEventRetString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public void setURL() {
        eventThread.fireNativeEvent(this.instanceNum, 5, "about:blank");
    }

    public void setURL(URL uRL) {
        this.setURL(uRL, null);
    }

    public void setURL(URL uRL, String string) {
        this.setURL(uRL, string, null);
    }

    public void setURL(URL uRL, String string, String string2) {
        if (uRL == null) {
            return;
        }
        String string3 = uRL.toString();
        if (uRL.getProtocol().equals(FILE)) {
            String string4 = uRL.getFile();
            if (string4.startsWith("/")) {
                string4 = string4.substring(1);
            }
            File file = new File(string4);
            try {
                String string5 = file.getCanonicalFile().getAbsolutePath();
                string3 = FILE_PROTOCOL + string5;
            }
            catch (IOException iOException) {
                WebBrowserUtil.error(iOException.getMessage());
                iOException.printStackTrace();
            }
        }
        if (string == null && string2 == null) {
            eventThread.fireNativeEvent(this.instanceNum, 5, string3);
        } else {
            eventThread.fireNativeEvent(this.instanceNum, 6, string3 + this.instanceNum + "," + 6 + "," + (string == null ? "" : string) + this.instanceNum + "," + 6 + "," + (string2 == null ? "" : string2));
        }
    }

    public void syncSetURL(URL uRL) throws JdicInitException {
        this.syncSetURL(uRL, null, null);
    }

    public void syncSetURL(URL uRL, String string) throws JdicInitException {
        this.syncSetURL(uRL, string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncSetURL(URL uRL, String string, String string2) throws JdicInitException {
        try {
            this.synchronize = true;
            if (!this.isInitialized) {
                WebBrowserUtil.error("You can't call this method before WebBrowser is initialized!");
                throw new JdicInitException("You can't call this method before WebBrowser is initialized!");
            }
            this.setURL(uRL, string, string2);
            WebBrowser webBrowser = this;
            synchronized (webBrowser) {
                try {
                    this.wait();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    System.out.println(exception.getMessage());
                }
            }
        }
        finally {
            this.synchronize = false;
        }
    }

    public void back() {
        eventThread.fireNativeEvent(this.instanceNum, 8);
    }

    public void forward() {
        eventThread.fireNativeEvent(this.instanceNum, 9);
    }

    public void refresh() {
        eventThread.fireNativeEvent(this.instanceNum, 10);
    }

    public void stop() {
        eventThread.fireNativeEvent(this.instanceNum, 11);
    }

    public void print() {
        this.executeScript("window.print();");
    }

    public void setContent(String string) {
        eventThread.fireNativeEvent(this.instanceNum, 16, string);
    }

    public String getContent() {
        eventThread.fireNativeEvent(this.instanceNum, 15);
        if (this.waitForResult()) {
            try {
                return eventThread.getEventRetString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public String executeScript(String string) {
        eventThread.fireNativeEvent(this.instanceNum, 17, string);
        if (this.waitForResult()) {
            try {
                return eventThread.getEventRetString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static void setDebug(boolean bl) {
        WebBrowserUtil.enableDebugMessages(bl);
    }

    public static String getBrowserBinary() {
        return BrowserEngineManager.instance().getActiveEngine().getEmbeddedBinaryName();
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public boolean isBackEnabled() {
        return this.isBackEnabled;
    }

    public boolean isForwardEnabled() {
        return this.isForwardEnabled;
    }

    protected boolean willOpenURL(URL uRL) {
        if (null == uRL) {
            return true;
        }
        WebBrowserUtil.trace("URL = " + uRL.toString());
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            try {
                securityManager.checkConnect(uRL.getHost(), uRL.getPort());
            }
            catch (AccessControlException accessControlException) {
                return false;
            }
        }
        return true;
    }

    protected boolean willOpenWindow(URL uRL) {
        if (uRL != null) {
            WebBrowserUtil.trace("willOpenWindow " + uRL.toString());
        }
        return true;
    }

    public int getInstanceNum() {
        return this.instanceNum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForResult() {
        if (!this.isInitialized) {
            WebBrowserUtil.trace("You can't call this method before WebBrowser is initialized!");
            return false;
        }
        boolean bl = false;
        WebBrowser webBrowser = this;
        synchronized (webBrowser) {
            try {
                this.wait();
                bl = true;
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
            }
        }
        return bl;
    }

    public int getNativeWindow() {
        return this.nativeGetWindow(System.getProperty("java.home"));
    }

    private native int nativeGetWindow(String var1);

    public Component asComponent() {
        return this;
    }

    public IBrowserEngine getBrowserEngine() {
        return BrowserEngineManager.instance().getActiveEngine();
    }

    public String getInitFailureMessage() {
        return this.initFailureMessage;
    }

    public boolean isSynchronize() {
        return this.synchronize;
    }

    static {
        lastInstanceNum = 0;
        try {
            Toolkit.getDefaultToolkit();
            JdicManager jdicManager = JdicManager.getManager();
            jdicManager.initShareNative();
            WebBrowserUtil.loadLibrary();
            eventThread = new NativeEventThread();
        }
        catch (JdicInitException jdicInitException) {
            WebBrowserUtil.error(jdicInitException.getCause().getMessage());
            jdicInitException.printStackTrace();
        }
    }

    class MyFocusListener
    implements FocusListener {
        MyFocusListener() {
        }

        public void focusGained(FocusEvent focusEvent) {
            WebBrowserUtil.trace("\nMyFocusListener: focusGained\n");
            eventThread.fireNativeEvent(WebBrowser.this.instanceNum, 13);
        }

        public void focusLost(FocusEvent focusEvent) {
            WebBrowserUtil.trace("\nMyFocusListener: focusLost\n");
            eventThread.fireNativeEvent(WebBrowser.this.instanceNum, 14);
        }
    }
}

