/*
 * Decompiled with CFR 0.152.
 */
package de.kapsi.net.daap;

import de.kapsi.net.daap.DaapException;
import de.kapsi.net.daap.DaapRequest;
import de.kapsi.net.daap.Folder;
import de.kapsi.net.daap.Library;
import de.kapsi.net.daap.Playlist;
import de.kapsi.net.daap.Song;
import de.kapsi.net.daap.Transaction;
import de.kapsi.net.daap.Txn;
import de.kapsi.net.daap.chunks.Chunk;
import de.kapsi.net.daap.chunks.UIntChunk;
import de.kapsi.net.daap.chunks.impl.DatabasePlaylists;
import de.kapsi.net.daap.chunks.impl.DatabaseSongs;
import de.kapsi.net.daap.chunks.impl.DeletedIdListing;
import de.kapsi.net.daap.chunks.impl.ItemId;
import de.kapsi.net.daap.chunks.impl.Listing;
import de.kapsi.net.daap.chunks.impl.ListingItem;
import de.kapsi.net.daap.chunks.impl.ReturnedCount;
import de.kapsi.net.daap.chunks.impl.SpecifiedTotalCount;
import de.kapsi.net.daap.chunks.impl.Status;
import de.kapsi.net.daap.chunks.impl.UpdateType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Database {
    private static final Log LOG = LogFactory.getLog(Database.class);
    private static long databaseId = 1L;
    private final long itemId;
    private final long persistentId;
    private String name;
    private int totalPlaylistCount = 0;
    private int totalSongCount = 0;
    private final List<Playlist> playlists = new ArrayList<Playlist>();
    private Set<Playlist> deletedPlaylists = null;
    private Set<Song> deletedSongs = null;
    private Playlist masterPlaylist = null;

    protected Database(Database database, Transaction txn) {
        this.itemId = database.itemId;
        this.persistentId = database.persistentId;
        this.name = database.name;
        if (database.deletedPlaylists != null) {
            this.deletedPlaylists = database.deletedPlaylists;
            database.deletedPlaylists = null;
        }
        Set songs = database.getSongs();
        for (Playlist playlist : database.playlists) {
            Set<Song> deletedSongs;
            if (!txn.modified(playlist)) continue;
            if (this.deletedPlaylists == null || !this.deletedPlaylists.contains(playlist)) {
                Playlist clone = new Playlist(playlist, txn);
                this.playlists.add(clone);
                if (playlist == database.masterPlaylist) {
                    this.masterPlaylist = clone;
                }
            }
            if ((deletedSongs = playlist.getDeletedSongs()) == null || deletedSongs.isEmpty()) continue;
            if (this.deletedSongs == null) {
                this.deletedSongs = new HashSet<Song>(deletedSongs);
                continue;
            }
            this.deletedSongs.addAll(deletedSongs);
        }
        if (this.deletedSongs != null) {
            this.deletedSongs.removeAll(songs);
        }
        this.totalPlaylistCount = database.playlists.size();
        this.totalSongCount = songs.size();
    }

    public Database(String name) {
        this(name, new Playlist(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Database(String name, Playlist masterPlaylist) {
        Class<Database> clazz = Database.class;
        synchronized (Database.class) {
            this.itemId = UIntChunk.checkUIntRange(databaseId++);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            this.persistentId = Library.nextPersistentId();
            this.name = name;
            this.totalPlaylistCount = 0;
            this.totalSongCount = 0;
            this.masterPlaylist = masterPlaylist;
            this.addPlaylistP(null, masterPlaylist);
            return;
        }
    }

    protected long getItemId() {
        return this.itemId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(Transaction txn, final String name) {
        if (txn != null) {
            txn.addTxn(this, new Txn(){

                public void commit(Transaction txn) {
                    Database.this.setNameP(txn, name);
                }
            });
        } else {
            this.setNameP(txn, name);
        }
        this.masterPlaylist.setName(txn, name);
    }

    private void setNameP(Transaction txn, String name) {
        this.name = name;
    }

    protected long getPersistentId() {
        return this.persistentId;
    }

    public Playlist getMasterPlaylist() {
        return this.masterPlaylist;
    }

    public List<Playlist> getPlaylists() {
        return Collections.unmodifiableList(this.playlists);
    }

    public void addPlaylist(Transaction txn, final Playlist playlist) {
        if (this.masterPlaylist.equals(playlist)) {
            throw new DaapException("You cannot add the master playlist.");
        }
        if (txn != null) {
            txn.addTxn(this, new Txn(){

                public void commit(Transaction txn) {
                    Database.this.addPlaylistP(txn, playlist);
                }
            });
            txn.attach(playlist);
        } else {
            this.addPlaylistP(txn, playlist);
        }
    }

    private void addPlaylistP(Transaction txn, Playlist playlist) {
        if (!this.containsPlaylist(playlist) && this.playlists.add(playlist)) {
            this.totalPlaylistCount = this.playlists.size();
            if (this.deletedPlaylists != null && this.deletedPlaylists.remove(playlist) && this.deletedPlaylists.isEmpty()) {
                this.deletedPlaylists = null;
            }
        }
    }

    public void removePlaylist(Transaction txn, final Playlist playlist) {
        if (this.masterPlaylist.equals(playlist)) {
            throw new DaapException("You cannot remove the master playlist.");
        }
        if (txn != null) {
            txn.addTxn(this, new Txn(){

                public void commit(Transaction txn) {
                    Database.this.removePlaylistP(txn, playlist);
                }
            });
        } else {
            this.removePlaylistP(txn, playlist);
        }
    }

    private void removePlaylistP(Transaction txn, Playlist playlist) {
        if (this.playlists.remove(playlist)) {
            this.totalPlaylistCount = this.playlists.size();
            if (this.deletedPlaylists == null) {
                this.deletedPlaylists = new HashSet<Playlist>();
            }
            this.deletedPlaylists.add(playlist);
        }
    }

    public int getPlaylistCount() {
        return this.playlists.size();
    }

    public boolean containsPlaylist(Playlist playlist) {
        return this.playlists.contains(playlist);
    }

    protected Object select(DaapRequest request) {
        if (request.isSongRequest()) {
            return this.getSong(request);
        }
        if (request.isDatabaseSongsRequest()) {
            return this.getDatabaseSongs(request);
        }
        if (request.isDatabasePlaylistsRequest()) {
            return this.getDatabasePlaylist(request);
        }
        if (request.isPlaylistSongsRequest()) {
            Playlist playlist = this.getPlaylist(request);
            if (playlist == null) {
                if (LOG.isInfoEnabled()) {
                    LOG.info("No playlist " + request.getContainerId() + " known in Database " + this.itemId);
                }
                return null;
            }
            return playlist.select(request);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("Unknown request: " + request);
        }
        return null;
    }

    public String toString() {
        return "Database(" + this.getItemId() + ", " + this.getName() + ")";
    }

    public int hashCode() {
        return (int)(this.getItemId() & Integer.MAX_VALUE);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Database)) {
            return false;
        }
        return ((Database)o).getItemId() == this.getItemId();
    }

    public Set getSongs() {
        HashSet<Song> songs = null;
        for (Playlist playlist : this.playlists) {
            if (playlist instanceof Folder) continue;
            if (songs == null) {
                songs = new HashSet<Song>(playlist.getSongs());
                continue;
            }
            songs.addAll(playlist.getSongs());
        }
        if (songs == null) {
            return Collections.EMPTY_SET;
        }
        return Collections.unmodifiableSet(songs);
    }

    public int getSongCount() {
        return this.getSongs().size();
    }

    public boolean containsSong(Song song) {
        for (Playlist playlist : this.playlists) {
            if (!playlist.containsSong(song)) continue;
            return true;
        }
        return false;
    }

    public void addSong(Transaction txn, Song song) {
        for (Playlist playlist : this.playlists) {
            if (playlist instanceof Folder) continue;
            playlist.addSong(txn, song);
        }
    }

    public void removeSong(Transaction txn, Song song) {
        for (Playlist playlist : this.playlists) {
            if (playlist instanceof Folder) continue;
            playlist.removeSong(txn, song);
        }
    }

    public Set<Playlist> getSongPlaylists(Song song) {
        HashSet<Playlist> ret = null;
        for (Playlist playlist : this.playlists) {
            if (!playlist.containsSong(song)) continue;
            if (ret == null) {
                ret = new HashSet<Playlist>();
            }
            ret.add(playlist);
        }
        if (ret != null) {
            return Collections.unmodifiableSet(ret);
        }
        return Collections.emptySet();
    }

    protected Song getSong(DaapRequest request) {
        for (Playlist playlist : this.playlists) {
            Song song;
            if (playlist instanceof Folder || (song = playlist.getSong(request)) == null) continue;
            return song;
        }
        return null;
    }

    protected Playlist getPlaylist(DaapRequest request) {
        long playlistId = request.getContainerId();
        for (Playlist playlist : this.playlists) {
            if (playlist.getItemId() != playlistId) continue;
            return playlist;
        }
        return null;
    }

    private DatabasePlaylists getDatabasePlaylist(DaapRequest request) {
        DatabasePlaylists databasePlaylists = new DatabasePlaylists();
        databasePlaylists.add(new Status(200L));
        databasePlaylists.add(new UpdateType(request.isUpdateType() ? 1 : 0));
        databasePlaylists.add(new SpecifiedTotalCount(this.totalPlaylistCount));
        databasePlaylists.add(new ReturnedCount(this.playlists.size()));
        Listing listing = new Listing();
        for (Playlist playlist : this.playlists) {
            ListingItem listingItem = new ListingItem();
            for (String key : request.getMeta()) {
                Chunk chunk = playlist.getChunk(key);
                if (chunk != null) {
                    listingItem.add(chunk);
                    continue;
                }
                if (!LOG.isInfoEnabled()) continue;
                LOG.info("Unknown chunk type: " + key);
            }
            listing.add(listingItem);
        }
        databasePlaylists.add(listing);
        if (request.isUpdateType() && this.deletedPlaylists != null) {
            DeletedIdListing deletedListing = new DeletedIdListing();
            for (Playlist playlist : this.deletedPlaylists) {
                deletedListing.add(new ItemId(playlist.getItemId()));
            }
            databasePlaylists.add(deletedListing);
        }
        return databasePlaylists;
    }

    private DatabaseSongs getDatabaseSongs(DaapRequest request) {
        DatabaseSongs databaseSongs = new DatabaseSongs();
        databaseSongs.add(new Status(200L));
        databaseSongs.add(new UpdateType(request.isUpdateType() ? 1 : 0));
        databaseSongs.add(new SpecifiedTotalCount(this.totalSongCount));
        Set songs = this.getSongs();
        databaseSongs.add(new ReturnedCount(songs.size()));
        Listing listing = new Listing();
        Iterator<Object> it = songs.iterator();
        while (it.hasNext()) {
            ListingItem listingItem = new ListingItem();
            Song song = (Song)it.next();
            for (String key : request.getMeta()) {
                Chunk chunk = song.getChunk(key);
                if (chunk != null) {
                    listingItem.add(chunk);
                    continue;
                }
                if (!LOG.isInfoEnabled()) continue;
                LOG.info("Unknown chunk type: " + key);
            }
            listing.add(listingItem);
        }
        databaseSongs.add(listing);
        if (request.isUpdateType() && this.deletedSongs != null) {
            DeletedIdListing deletedListing = new DeletedIdListing();
            for (Song song : this.deletedSongs) {
                deletedListing.add(song.getChunk("dmap.itemid"));
            }
            databaseSongs.add(deletedListing);
        }
        return databaseSongs;
    }
}

