/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.hashing;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.limewire.io.IOUtils;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;

public abstract class NonMetaDataHasher {
    protected static final Log LOG = LogFactory.getLog(NonMetaDataHasher.class);

    public abstract long getStartPosition() throws IOException;

    public abstract long getEndPosition() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void fillBuffer(ByteBuffer buffer, File file, int rearOffset) throws IOException {
        FileInputStream fis = null;
        buffer.rewind();
        try {
            int totalRead;
            fis = new FileInputStream(file);
            FileChannel fc = fis.getChannel();
            if (fc.size() >= (long)(buffer.capacity() + rearOffset)) {
                fc.position(fc.size() - (long)buffer.capacity() - (long)rearOffset);
            } else {
                fc.position(0L);
            }
            int read = 0;
            for (totalRead = 0; totalRead < buffer.capacity() && (long)totalRead < fc.size(); totalRead += read) {
                read = fc.read(buffer);
                if (read != 0 && read != -1) continue;
            }
            buffer.limit(totalRead);
        }
        catch (Throwable throwable) {
            IOUtils.close(fis);
            throw throwable;
        }
        IOUtils.close(fis);
    }
}

