/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.dht.db;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.ApplicationServices;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.PushEndpointFactory;
import com.limegroup.gnutella.dht.db.AbstractPushProxiesValue;
import com.limegroup.gnutella.dht.db.PushProxiesValue;
import com.limegroup.gnutella.dht.db.PushProxiesValueFactory;
import com.limegroup.gnutella.dht.db.PushProxiesValueForSelf;
import com.limegroup.gnutella.dht.db.PushProxiesValueImpl;
import java.util.Set;
import org.limewire.concurrent.AbstractLazySingletonProvider;
import org.limewire.io.IpPort;
import org.limewire.mojito.db.DHTValueType;
import org.limewire.mojito.exceptions.DHTValueException;
import org.limewire.mojito.routing.Version;

@Singleton
public class PushProxiesValueFactoryImpl
implements PushProxiesValueFactory {
    private final NetworkManager networkManager;
    private final PushEndpointFactory pushEndpointFactory;
    private final Provider<PushProxiesValue> lazySelf;
    private final ApplicationServices applicationServices;

    @Inject
    public PushProxiesValueFactoryImpl(NetworkManager networkManager, PushEndpointFactory pushEndpointFactory, ApplicationServices applicationServices) {
        this.networkManager = networkManager;
        this.pushEndpointFactory = pushEndpointFactory;
        this.applicationServices = applicationServices;
        this.lazySelf = new AbstractLazySingletonProvider<PushProxiesValue>(){

            @Override
            protected PushProxiesValue createObject() {
                return new PushProxiesValueForSelf(PushProxiesValueFactoryImpl.this.networkManager, PushProxiesValueFactoryImpl.this.pushEndpointFactory, PushProxiesValueFactoryImpl.this.applicationServices);
            }
        };
    }

    @Override
    public PushProxiesValue createDHTValue(DHTValueType type, Version version, byte[] value) throws DHTValueException {
        return this.createFromData(version, value);
    }

    @Override
    public PushProxiesValue createDHTValueForSelf() {
        return this.lazySelf.get();
    }

    AbstractPushProxiesValue createPushProxiesValue(Version version, byte[] guid, byte features, int fwtVersion, int port, Set<? extends IpPort> proxies) {
        return new PushProxiesValueImpl(version, guid, features, fwtVersion, port, proxies);
    }

    PushProxiesValue createFromData(Version version, byte[] data) throws DHTValueException {
        return new PushProxiesValueImpl(version, data);
    }
}

