/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.AbstractPushEndpoint;
import com.limegroup.gnutella.PushEndpoint;
import com.limegroup.gnutella.PushEndpointCache;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.limewire.io.GUID;
import org.limewire.io.IpPort;
import org.limewire.io.IpPortSet;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.service.ErrorService;

public class PushEndpointImpl
extends AbstractPushEndpoint {
    private final byte[] _clientGUID;
    private GUID _guid;
    private final int _features;
    private final int _fwtVersion;
    private Set<? extends IpPort> _proxies;
    private final IpPort _externalAddr;
    private final PushEndpointCache pushEndpointCache;
    private final NetworkInstanceUtils networkInstanceUtils;

    public PushEndpointImpl(byte[] guid, Set<? extends IpPort> proxies, byte features, int fwtVersion, IpPort addr, PushEndpointCache pushEndpointCache, NetworkInstanceUtils networkInstanceUtils) {
        this.pushEndpointCache = pushEndpointCache;
        this.networkInstanceUtils = networkInstanceUtils;
        this._features = features & 0xFFFFFFE0 | fwtVersion << 3;
        this._fwtVersion = fwtVersion;
        this._clientGUID = guid;
        this._guid = new GUID(this._clientGUID);
        this._proxies = proxies != null ? (proxies instanceof IpPortSet ? Collections.unmodifiableSet(proxies) : Collections.unmodifiableSet(new IpPortSet((Collection<? extends IpPort>)proxies))) : Collections.emptySet();
        this._externalAddr = addr;
        if (addr != null && addr.getAddress().equals("1.1.1.1")) {
            ErrorService.error(new IllegalStateException("constructing PEI w/ bogus IP!"));
        }
    }

    @Override
    public IpPort getValidExternalAddress() {
        IpPort ret = this.getIpPort();
        if (ret == null || !this.networkInstanceUtils.isValidExternalIpPort(ret)) {
            return null;
        }
        if (ret.getAddress().equals("1.1.1.1")) {
            return null;
        }
        return ret;
    }

    @Override
    public byte[] getClientGUID() {
        return this._clientGUID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<? extends IpPort> getProxies() {
        PushEndpointImpl pushEndpointImpl = this;
        synchronized (pushEndpointImpl) {
            if (this._proxies != null) {
                return this._proxies;
            }
        }
        PushEndpoint current = this.pushEndpointCache.getCached(this._guid);
        if (current == null) {
            return Collections.emptySet();
        }
        return current.getProxies();
    }

    @Override
    public int getFWTVersion() {
        PushEndpoint current = this.pushEndpointCache.getCached(this._guid);
        int currentVersion = current == null ? this._fwtVersion : current.getFWTVersion();
        return currentVersion;
    }

    @Override
    public byte getFeatures() {
        PushEndpoint current = this.pushEndpointCache.getCached(this._guid);
        int currentFeatures = current == null ? this._features : (int)current.getFeatures();
        return (byte)(currentFeatures & 0xFFFFFFE0);
    }

    private IpPort getIpPort() {
        PushEndpoint current = this.pushEndpointCache.getCached(this._guid);
        return current == null || current.getValidExternalAddress() == null ? this._externalAddr : current.getValidExternalAddress();
    }

    @Override
    public String getAddress() {
        IpPort addr = this.getIpPort();
        return addr != null ? addr.getAddress() : "1.1.1.1";
    }

    @Override
    public InetAddress getInetAddress() {
        IpPort addr = this.getIpPort();
        return addr != null ? addr.getInetAddress() : null;
    }

    @Override
    public int getPort() {
        IpPort addr = this.getIpPort();
        return addr != null ? addr.getPort() : 6346;
    }

    @Override
    public InetSocketAddress getInetSocketAddress() {
        IpPort addr = this.getIpPort();
        return addr != null ? addr.getInetSocketAddress() : null;
    }

    @Override
    public String getAddressDescription() {
        IpPort addr = this.getIpPort();
        return addr != null ? addr.getAddress() : null;
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    @Override
    public synchronized void updateProxies(boolean good) {
        this._guid = this.pushEndpointCache.updateProxiesFor(this._guid, this, good);
        this._proxies = null;
    }

    @Override
    public PushEndpoint createClone() {
        return new PushEndpointImpl(this._guid.bytes(), this.getProxies(), this.getFeatures(), this.getFWTVersion(), this.getIpPort(), this.pushEndpointCache, this.networkInstanceUtils);
    }
}

