/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.seawind.internal.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.Assert;
import org.json.JSONArray;
import org.json.JSONObject;
import org.xmind.core.IBoundary;
import org.xmind.core.IComment;
import org.xmind.core.ICommentManager;
import org.xmind.core.IControlPoint;
import org.xmind.core.IFileEntry;
import org.xmind.core.IHtmlNotesContent;
import org.xmind.core.IHyperlinkSpan;
import org.xmind.core.IIdentifiable;
import org.xmind.core.ILegend;
import org.xmind.core.IManifest;
import org.xmind.core.INotesContent;
import org.xmind.core.IParagraph;
import org.xmind.core.IPlainNotesContent;
import org.xmind.core.IRelationship;
import org.xmind.core.ISettingEntry;
import org.xmind.core.ISheet;
import org.xmind.core.ISheetSettings;
import org.xmind.core.ISpan;
import org.xmind.core.ISpanList;
import org.xmind.core.ISummary;
import org.xmind.core.ITextSpan;
import org.xmind.core.ITopic;
import org.xmind.core.ITopicExtension;
import org.xmind.core.ITopicExtensionElement;
import org.xmind.core.io.IInputSource;
import org.xmind.core.io.IStorage;
import org.xmind.core.marker.IMarker;
import org.xmind.core.marker.IMarkerGroup;
import org.xmind.core.marker.IMarkerSheet;
import org.xmind.core.plain.Boundary;
import org.xmind.core.plain.Relationship;
import org.xmind.core.plain.Sheet;
import org.xmind.core.plain.Summary;
import org.xmind.core.plain.Topic;
import org.xmind.core.plain.Workbook;
import org.xmind.core.style.IStyle;
import org.xmind.core.style.IStyled;
import org.xmind.core.util.FileUtils;
import org.xmind.core.util.HyperlinkUtils;
import org.xmind.core.util.ObjectRefManager;
import org.xmind.core.util.Ranges;
import org.xmind.seawind.internal.core.PathInfo;

public class SheetDeserializer {
    private Workbook workbook;
    private Map<Properties, IStyle> styleTable;

    public SheetDeserializer(Workbook workbook) {
        this.workbook = workbook;
        this.styleTable = new HashMap<Properties, IStyle>();
    }

    public void loadResources(IStorage resourceStorage) throws IOException {
        ObjectRefManager refManager = this.workbook.getAdapter(ObjectRefManager.class);
        IManifest manifest = this.workbook.getManifest();
        IInputSource source = resourceStorage.getInputSource();
        for (String entryPath : refManager.getRefsFor(this.workbook, "file-entry")) {
            IFileEntry entry;
            if (!entryPath.startsWith("resources/") || (entry = manifest.createFileEntry(entryPath, null)).isDirectory()) continue;
            PathInfo pathInfo = new PathInfo(entryPath);
            if (!source.hasEntry(pathInfo.hash)) continue;
            try (InputStream input = source.openEntryStream(pathInfo.hash);
                 OutputStream output = entry.openOutputStream();){
                FileUtils.transfer((InputStream)input, (OutputStream)output, (boolean)false);
            }
        }
    }

    public void deserialize(Sheet sheet, JSONObject sheetObject) throws IOException {
        JSONObject settingsObject;
        JSONObject legendObject;
        JSONObject rootTopicObject = sheetObject.optJSONObject("rootTopic");
        Assert.isNotNull((Object)rootTopicObject);
        ITopic rootTopic = this.parseTopic(rootTopicObject, null);
        sheet.replaceRootTopic(rootTopic);
        JSONArray relationshipArray = sheetObject.optJSONArray("relationships");
        if (relationshipArray != null) {
            for (Object relationshipArrayElement : relationshipArray) {
                if (!(relationshipArrayElement instanceof JSONObject)) continue;
                sheet.addRelationship(this.parseRelationship((JSONObject)relationshipArrayElement));
            }
        }
        if ((legendObject = sheetObject.optJSONObject("legend")) != null) {
            ILegend legend = sheet.getLegend();
            legend.setVisible("visible".equals(legendObject.optString("visibility", null)));
            JSONObject positionObject = legendObject.optJSONObject("position");
            if (positionObject != null) {
                legend.setPosition(positionObject.optInt("x", 0), positionObject.optInt("y", 0));
            }
            JSONObject markerMapObject = legendObject.optJSONObject("markers");
            JSONObject groupMapObject = legendObject.optJSONObject("groups");
            IMarkerSheet markerSheet = this.workbook.getMarkerSheet();
            if (groupMapObject != null) {
                Iterator groupIdIt = groupMapObject.keys();
                while (groupIdIt.hasNext()) {
                    String groupId = (String)groupIdIt.next();
                    JSONObject groupObject = groupMapObject.getJSONObject(groupId);
                    IMarkerGroup group = markerSheet.getMarkerGroup(groupId);
                    if (group == null) {
                        group = markerSheet.createMarkerGroupById(groupId);
                    }
                    group.setName(groupObject.optString("name"));
                    JSONArray markerArray = groupObject.optJSONArray("markers");
                    if (markerArray != null) {
                        for (Object markerArrayElement : markerArray) {
                            String markerId = (String)markerArrayElement;
                            JSONObject markerObject = markerMapObject.optJSONObject(markerId);
                            if (markerObject == null) continue;
                            IMarker marker = markerSheet.getMarker(markerId);
                            if (marker == null) {
                                String resourceURL = markerObject.optString("resource");
                                String resourcePath = resourceURL == null ? null : HyperlinkUtils.toAttachmentPath((String)resourceURL);
                                marker = markerSheet.createMarkerById(markerId, resourcePath);
                            }
                            if (marker.getParent() != null) continue;
                            group.addMarker(marker);
                        }
                    }
                    if (group.isEmpty() || group.getParent() != null) continue;
                    markerSheet.addMarkerGroup(group);
                }
            }
            if (markerMapObject != null) {
                Iterator markerIdIt = markerMapObject.keys();
                while (markerIdIt.hasNext()) {
                    String markerId = (String)markerIdIt.next();
                    JSONObject markerObject = markerMapObject.optJSONObject(markerId);
                    if (markerObject == null) continue;
                    legend.setMarkerDescription(markerId, markerObject.optString("name", null));
                }
            }
        }
        if ((settingsObject = sheetObject.optJSONObject("settings")) != null) {
            ISheetSettings settings = sheet.getSettings();
            Iterator settingPathIt = settingsObject.keys();
            while (settingPathIt.hasNext()) {
                String settingPath = (String)settingPathIt.next();
                JSONArray settingEntryArray = settingsObject.optJSONArray(settingPath);
                if (settingEntryArray == null) continue;
                for (Object settingEntryArrayElement : settingEntryArray) {
                    if (!(settingEntryArrayElement instanceof JSONObject)) continue;
                    JSONObject settingEntryObject = (JSONObject)settingEntryArrayElement;
                    ISettingEntry settingEntry = settings.createEntry(settingPath);
                    Iterator keyIt = settingEntryObject.keys();
                    while (keyIt.hasNext()) {
                        String key = (String)keyIt.next();
                        settingEntry.setAttribute(key, settingEntryObject.optString(key, null));
                    }
                    settings.addEntry(settingEntry);
                }
            }
        }
        this.deserializeStyle((IStyled)sheet, sheetObject);
        this.deserializeTheme(sheet, sheetObject);
    }

    private ITopic parseTopic(JSONObject topicObject, String type) {
        JSONArray commentArray;
        JSONArray extArray;
        JSONArray summaryArray;
        JSONArray boundaryArray;
        JSONObject childrenObject;
        JSONObject notesObject;
        JSONObject numberingObject;
        JSONArray markerRefArray;
        String topicId = topicObject.optString("id", null);
        Assert.isNotNull((Object)topicId);
        Topic topic = new Topic(this.workbook, topicId);
        topic.setTitleText(topicObject.optString("title", null));
        topic.setTitleWidth(topicObject.optInt("width", -1));
        topic.setFolded("folded".equals(topicObject.optString("branch", null)));
        this.deserializeTopicStructure(topicObject, topic, type);
        JSONObject positionObject = topicObject.optJSONObject("position");
        if (positionObject != null) {
            topic.setPosition(positionObject.optInt("x", 0), positionObject.optInt("y", 0));
        } else {
            topic.setPosition(null);
        }
        topic.setHyperlink(topicObject.optString("href", null));
        JSONArray labelArray = topicObject.optJSONArray("labels");
        if (labelArray != null) {
            HashSet<String> labels = new HashSet<String>();
            for (Object label : labelArray) {
                if (!(label instanceof String)) continue;
                labels.add((String)label);
            }
            topic.setLabels(labels);
        }
        if ((markerRefArray = topicObject.optJSONArray("markers")) != null) {
            for (Object markerRefObject : markerRefArray) {
                String markerId;
                if (!(markerRefObject instanceof JSONObject) || (markerId = ((JSONObject)markerRefObject).optString("markerId", null)) == null) continue;
                topic.addMarker(markerId);
            }
        }
        this.deserializeStyle((IStyled)topic, topicObject);
        JSONObject imageObject = topicObject.optJSONObject("image");
        if (imageObject != null) {
            topic.getImage().setSource(imageObject.optString("src", null));
            topic.getImage().setAlignment(imageObject.optString("align", null));
            topic.getImage().setWidth(imageObject.optInt("width", -1));
            topic.getImage().setHeight(imageObject.optInt("height", -1));
        }
        if ((numberingObject = topicObject.optJSONObject("numbering")) != null) {
            topic.getNumbering().setFormat(numberingObject.optString("numberFormat", null));
            topic.getNumbering().setDepth(numberingObject.optString("numberDepth", null));
            topic.getNumbering().setPrefix(numberingObject.optString("prefix", null));
            topic.getNumbering().setSuffix(numberingObject.optString("suffix", null));
            topic.getNumbering().setSeparator(numberingObject.optString("numberSeparator", null));
            String prepend = numberingObject.optString("prependingNumbers", null);
            if ("none".equals(prepend)) {
                topic.getNumbering().setPrependsParentNumbers(false);
            }
        }
        if ((notesObject = topicObject.optJSONObject("notes")) != null) {
            INotesContent htmlContent;
            JSONObject contentObject;
            JSONObject htmlObject;
            INotesContent plainContent;
            String textContent;
            JSONObject plainObject = notesObject.optJSONObject("plain");
            if (plainObject != null && (textContent = plainObject.optString("content", null)) != null && (plainContent = this.workbook.createNotesContent("plain")) instanceof IPlainNotesContent) {
                ((IPlainNotesContent)plainContent).setTextContent(textContent);
                topic.getNotes().setContent("plain", plainContent);
            }
            if ((htmlObject = notesObject.optJSONObject("html")) != null && (contentObject = htmlObject.optJSONObject("content")) != null && (htmlContent = this.workbook.createNotesContent("html")) instanceof IHtmlNotesContent) {
                this.deserializeHtmlNotesContent((IHtmlNotesContent)htmlContent, contentObject);
                topic.getNotes().setContent("html", htmlContent);
            }
        }
        if ((childrenObject = topicObject.optJSONObject("children")) != null) {
            Iterator types = childrenObject.keys();
            while (types.hasNext()) {
                String childType = (String)types.next();
                Iterator topicArray = childrenObject.optJSONArray(childType);
                Iterator iterator = topicArray.iterator();
                while (iterator.hasNext()) {
                    Iterator childObject = iterator.next();
                    ITopic childTopic = this.parseTopic((JSONObject)childObject, childType);
                    topic.add(childTopic, childType);
                }
            }
        }
        if ((boundaryArray = topicObject.optJSONArray("boundaries")) != null) {
            for (Object boundaryObject : boundaryArray) {
                if (!(boundaryObject instanceof JSONObject)) continue;
                topic.addBoundary(this.parseBoundary((JSONObject)boundaryObject));
            }
        }
        if ((summaryArray = topicObject.optJSONArray("summaries")) != null) {
            for (Object summaryObject : summaryArray) {
                if (!(summaryObject instanceof JSONObject)) continue;
                topic.addSummary(this.parseSummary((JSONObject)summaryObject));
            }
        }
        if ((extArray = topicObject.optJSONArray("extensions")) != null) {
            for (Object extObject : extArray) {
                if (!(extObject instanceof JSONObject)) continue;
                this.deserializeTopicExtension(topic, (JSONObject)extObject);
            }
        }
        if ((commentArray = topicObject.optJSONArray("comments")) != null) {
            for (Object commentObject : commentArray) {
                if (!(commentObject instanceof JSONObject)) continue;
                this.deserializeComment((IIdentifiable)topic, (JSONObject)commentObject);
            }
        }
        return topic;
    }

    private void deserializeTopicStructure(JSONObject topicObject, ITopic topic, String type) {
        String structureClass = topicObject.optString("structureClass", null);
        if ("detached".equals(type)) {
            if ("org.xmind.ui.map".equals(structureClass) || "org.xmind.ui.map.unbalanced".equals(structureClass)) {
                structureClass = "org.xmind.ui.map.floating";
            } else if ("org.xmind.ui.map.clockwise".equals(structureClass)) {
                structureClass = "org.xmind.ui.map.floating.clockwise";
            } else if ("org.xmind.ui.map.anticlockwise".equals(structureClass)) {
                structureClass = "org.xmind.ui.map.floating.anticlockwise";
            }
        }
        topic.setStructureClass(structureClass);
    }

    private void deserializeComment(IIdentifiable object, JSONObject commentObject) {
        String author = commentObject.optString("author", null);
        long creationTime = commentObject.optLong("creationTime", 0L);
        String objectId = object.getId();
        if (author == null) {
            return;
        }
        ICommentManager commentManager = this.workbook.getCommentManager();
        IComment comment = commentManager.createComment(author, creationTime, objectId);
        comment.setContent(commentObject.optString("content", null));
        commentManager.addComment(comment);
    }

    private void deserializeHtmlNotesContent(IHtmlNotesContent content, JSONObject contentObject) {
        JSONArray paragraphArray = contentObject.optJSONArray("paragraphs");
        if (paragraphArray != null) {
            for (Object paragraphArrayElement : paragraphArray) {
                if (!(paragraphArrayElement instanceof JSONObject)) continue;
                JSONObject paragraphObject = (JSONObject)paragraphArrayElement;
                IParagraph paragraph = content.createParagraph();
                this.deserializeStyle((IStyled)paragraph, paragraphObject);
                this.deserializeSpanList((ISpanList)paragraph, paragraphObject, content);
                content.addParagraph(paragraph);
            }
        }
    }

    private void deserializeSpanList(ISpanList spanList, JSONObject sourceObject, IHtmlNotesContent spanFactory) {
        JSONArray spanArray = sourceObject.optJSONArray("spans");
        if (spanArray == null || spanArray.length() == 0) {
            return;
        }
        for (Object spanArrayElement : spanArray) {
            ITextSpan span;
            if (!(spanArrayElement instanceof JSONObject)) continue;
            JSONObject spanObject = (JSONObject)spanArrayElement;
            String text = spanObject.optString("text", null);
            if (text != null) {
                span = spanFactory.createTextSpan(text);
            } else {
                String imageSource = spanObject.optString("image", null);
                if (imageSource != null) {
                    span = spanFactory.createImageSpan(imageSource);
                } else {
                    String href = spanObject.optString("href", null);
                    if (href == null) continue;
                    span = spanFactory.createHyperlinkSpan(href);
                    this.deserializeSpanList((ISpanList)((IHyperlinkSpan)span), spanObject, spanFactory);
                }
            }
            this.deserializeStyle((IStyled)span, spanObject);
            spanList.addSpan((ISpan)span);
        }
    }

    private IBoundary parseBoundary(JSONObject boundaryObject) {
        String id = boundaryObject.optString("id", null);
        Assert.isNotNull((Object)id);
        Boundary boundary = new Boundary(this.workbook, id);
        boundary.setTitleText(boundaryObject.optString("title", null));
        String range = boundaryObject.optString("range", null);
        if ("master".equals(range)) {
            boundary.setMasterBoundary(true);
        } else {
            boundary.setStartIndex(Ranges.parseStartIndex(range));
            boundary.setEndIndex(Ranges.parseEndIndex(range));
        }
        this.deserializeStyle((IStyled)boundary, boundaryObject);
        return boundary;
    }

    private ISummary parseSummary(JSONObject summaryObject) {
        String id = summaryObject.optString("id", null);
        Assert.isNotNull((Object)id);
        Summary summary = new Summary(this.workbook, id);
        summary.setTopicId(summaryObject.optString("topicId", null));
        String range = summaryObject.optString("range", null);
        summary.setStartIndex(Ranges.parseStartIndex(range));
        summary.setEndIndex(Ranges.parseEndIndex(range));
        this.deserializeStyle((IStyled)summary, summaryObject);
        return summary;
    }

    private IRelationship parseRelationship(JSONObject relObject) {
        String relId = relObject.optString("id", null);
        Assert.isNotNull((Object)relId);
        Relationship rel = new Relationship(this.workbook, relId);
        rel.setTitleText(relObject.optString("title", null));
        rel.setEnd1Id(relObject.optString("end1Id", null));
        rel.setEnd2Id(relObject.optString("end2Id", null));
        JSONObject controlPointMap = relObject.optJSONObject("controlPoints");
        if (controlPointMap != null) {
            Iterator indexKeys = controlPointMap.keys();
            while (indexKeys.hasNext()) {
                int index;
                String indexKey = (String)indexKeys.next();
                try {
                    index = Integer.parseInt(indexKey, 10);
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
                this.deserializeControlPoint(rel, index, controlPointMap.getJSONObject(indexKey));
            }
        }
        this.deserializeStyle((IStyled)rel, relObject);
        return rel;
    }

    private void deserializeControlPoint(IRelationship rel, int index, JSONObject controlPointObject) {
        boolean hasPosition = controlPointObject.has("x") || controlPointObject.has("y");
        boolean hasAngle = controlPointObject.has("angle");
        boolean hasAmount = controlPointObject.has("amount");
        if (!(hasPosition || hasAngle || hasAmount)) {
            return;
        }
        IControlPoint controlPoint = rel.getControlPoint(index);
        if (hasPosition) {
            controlPoint.setPosition(controlPointObject.optInt("x", 0), controlPointObject.optInt("y", 0));
        }
        if (hasAngle) {
            controlPoint.setPolarAngle(controlPointObject.optDouble("angle", 0.0));
        }
        if (hasAmount) {
            controlPoint.setPolarAmount(controlPointObject.optDouble("amount", 0.0));
        }
    }

    private void deserializeTopicExtension(ITopic topic, JSONObject extObject) {
        String providerName = extObject.optString("provider", null);
        Assert.isNotNull((Object)providerName);
        ITopicExtension ext = topic.createExtension(providerName);
        this.deserializeTopicExtensionElement(ext.getContent(), extObject);
        JSONArray resourceRefArray = extObject.optJSONArray("resourceRefs");
        if (resourceRefArray != null) {
            for (Object resourceRefArrayElement : resourceRefArray) {
                String refURL;
                if (!(resourceRefArrayElement instanceof String) || !HyperlinkUtils.isAttachmentURL((String)(refURL = (String)resourceRefArrayElement))) continue;
                ext.addResourceRef(ext.getOwnedWorkbook().createResourceRef("file-entry", HyperlinkUtils.toAttachmentPath((String)refURL)));
            }
        }
    }

    private void deserializeTopicExtensionElement(ITopicExtensionElement ele, JSONObject eleObject) {
        Object content;
        JSONObject attrMapObject = eleObject.optJSONObject("attrs");
        if (attrMapObject != null) {
            Iterator attrKeyIt = attrMapObject.keys();
            while (attrKeyIt.hasNext()) {
                String attrKey = (String)attrKeyIt.next();
                ele.setAttribute(attrKey, attrMapObject.getString(attrKey));
            }
        }
        if ((content = eleObject.opt("content")) instanceof String) {
            ele.setTextContent((String)content);
        } else if (content instanceof JSONArray) {
            JSONArray childElementArray = (JSONArray)content;
            int i = 0;
            while (i < childElementArray.length()) {
                JSONObject childElementObject = childElementArray.getJSONObject(i);
                if (childElementObject instanceof JSONObject) {
                    String childName = childElementObject.optString("name", null);
                    if ("org.xmind.ui.map.unbalanced".equals(eleObject.optString("provider")) && childName == null) {
                        childName = "right-number";
                    }
                    if ("org.xmind.ui.audionotes".equals(eleObject.optString("provider")) && childName == null) {
                        if (i == 0) {
                            childName = "duration";
                        } else if (i == 1) {
                            childName = "record-time";
                        } else if (i == 2) {
                            childName = "file-size";
                        }
                    }
                    if ("org.xmind.ui.ideafactory".equals(eleObject.optString("provider")) && childName == null) {
                        if (i == 0) {
                            childName = "groups";
                        } else if (i == 1) {
                            childName = "ideas";
                        }
                    }
                    if ("org.xmind.ui.ideafactory".equals(ele.getExtension().getProviderName()) && childName == null) {
                        String eleName = ele.getName();
                        if (eleName.equals("groups")) {
                            childName = "group";
                        } else if (eleName.equals("ideas")) {
                            childName = "idea";
                        }
                    }
                    Assert.isNotNull((Object)childName);
                    this.deserializeTopicExtensionElement((ITopicExtensionElement)ele.createChild(childName), childElementObject);
                }
                ++i;
            }
        }
    }

    private void deserializeStyle(IStyled styled, JSONObject sourceObject) {
        JSONObject styleObject = sourceObject.optJSONObject("style");
        if (styleObject == null) {
            return;
        }
        IStyle style = this.findOrCreateStyle(styleObject, "normal-styles");
        if (style == null) {
            return;
        }
        styled.setStyleId(style.getId());
    }

    private IStyle findOrCreateStyle(JSONObject styleObject, String groupName) {
        String type = styleObject.optString("type", null);
        if (type == null) {
            return null;
        }
        JSONObject propertiesObject = styleObject.optJSONObject("properties");
        if (propertiesObject == null) {
            return null;
        }
        IStyle style = this.workbook.getStyleSheet().createStyle(type);
        Properties properties = new Properties();
        properties.setProperty("$__TYPE__$", type);
        properties.setProperty("$__GROUP__$", groupName);
        Iterator keyIt = propertiesObject.keys();
        while (keyIt.hasNext()) {
            String key = (String)keyIt.next();
            String value = propertiesObject.getString(key);
            style.setProperty(key, value);
            properties.setProperty(key, value);
        }
        IStyle createdStyle = this.styleTable.get(properties);
        if (createdStyle != null) {
            this.workbook.getObjectRegistry().unregister((IIdentifiable)style);
            return createdStyle;
        }
        this.styleTable.put(properties, style);
        return style;
    }

    private void deserializeTheme(ISheet sheet, JSONObject sheetObject) {
        JSONObject themeObject = sheetObject.optJSONObject("theme");
        if (themeObject == null) {
            return;
        }
        IStyle theme = this.workbook.getStyleSheet().createStyle("theme");
        Properties properties = new Properties();
        properties.setProperty("$__TYPE__$", "theme");
        properties.setProperty("$__GROUP__$", "master-styles");
        Iterator keyIt = themeObject.keys();
        while (keyIt.hasNext()) {
            IStyle style;
            String key = (String)keyIt.next();
            JSONObject styleObject = themeObject.optJSONObject(key);
            if (styleObject == null || (style = this.findOrCreateStyle(styleObject, "automatic-styles")) == null) continue;
            theme.setDefaultStyleId(key, style.getId());
            properties.setProperty(key, style.getId());
        }
        IStyle createdTheme = this.styleTable.get(properties);
        if (createdTheme != null) {
            this.workbook.getObjectRegistry().unregister((IIdentifiable)theme);
            theme = createdTheme;
        } else {
            this.styleTable.put(properties, theme);
        }
        sheet.setThemeId(theme.getId());
    }
}

