/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.plain;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xmind.core.ISettingEntry;
import org.xmind.core.ISheet;
import org.xmind.core.ISheetSettings;
import org.xmind.core.IWorkbook;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.plain.SettingEntry;
import org.xmind.core.plain.Sheet;

public class SheetSettings
implements ISheetSettings {
    private final Sheet ownerSheet;
    private final Map<String, List<ISettingEntry>> entryMap;

    public SheetSettings(Sheet ownerSheet) {
        this.ownerSheet = ownerSheet;
        this.entryMap = new HashMap<String, List<ISettingEntry>>();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (IWorkbook.class.equals(adapter)) {
            return adapter.cast(this.getOwnedWorkbook());
        }
        if (ISheet.class.equals(adapter)) {
            return adapter.cast(this.getOwnedSheet());
        }
        return null;
    }

    public ISheet getOwnedSheet() {
        return this.ownerSheet;
    }

    public IWorkbook getOwnedWorkbook() {
        return this.ownerSheet.getOwnedWorkbook();
    }

    public boolean isOrphan() {
        return this.ownerSheet.isOrphan();
    }

    public List<ISettingEntry> getEntries(String path) {
        List<ISettingEntry> entryList = this.entryMap.get(path);
        if (entryList == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(entryList);
    }

    public ISettingEntry createEntry(String path) {
        return new SettingEntry(this.ownerSheet.getOwnedWorkbook(), path);
    }

    public void addEntry(ISettingEntry entry) {
        if (entry == null || entry.getOwnedWorkbook() != this.getOwnedWorkbook()) {
            throw new IllegalArgumentException();
        }
        String path = entry.getPath();
        if (path == null) {
            throw new IllegalArgumentException();
        }
        List<ISettingEntry> entryList = this.entryMap.get(path);
        if (entryList == null) {
            entryList = new ArrayList<ISettingEntry>();
            this.entryMap.put(path, entryList);
        }
        entryList.add(entry);
        if (entry instanceof SettingEntry) {
            ((SettingEntry)entry).setTargetSheet(this.ownerSheet);
            if (!this.isOrphan()) {
                ((SettingEntry)entry).onParented();
            }
        }
        for (String key : entry.getAttributeKeys()) {
            CoreEvent event = new CoreEvent((ICoreEventSource)this.ownerSheet, "sheetSettings", (Object)key, null, (Object)entry.getAttribute(key));
            event.setData((Object)path);
            this.ownerSheet.getCoreEventSupport().dispatch((ICoreEventSource)this.ownerSheet, event);
        }
    }

    public void removeEntry(ISettingEntry entry) {
        if (entry == null || entry.getOwnedWorkbook() != this.getOwnedWorkbook()) {
            throw new IllegalArgumentException();
        }
        String path = entry.getPath();
        if (path == null) {
            throw new IllegalArgumentException();
        }
        List<ISettingEntry> entryList = this.entryMap.get(path);
        if (entryList == null) {
            return;
        }
        if (!entryList.contains(entry)) {
            return;
        }
        if (entry instanceof SettingEntry) {
            if (!this.isOrphan()) {
                ((SettingEntry)entry).onOrphan();
            }
            ((SettingEntry)entry).setTargetSheet(null);
        }
        entryList.remove(entry);
        if (entryList.isEmpty()) {
            this.entryMap.remove(path);
        }
        for (String key : entry.getAttributeKeys()) {
            CoreEvent event = new CoreEvent((ICoreEventSource)this.ownerSheet, "sheetSettings", (Object)key, (Object)entry.getAttribute(key), null);
            event.setData((Object)path);
            this.ownerSheet.getCoreEventSupport().dispatch((ICoreEventSource)this.ownerSheet, event);
        }
    }

    public Set<String> getPaths() {
        return Collections.unmodifiableSet(this.entryMap.keySet());
    }

    protected void onParented() {
        for (List<ISettingEntry> entryList : this.entryMap.values()) {
            for (ISettingEntry entry : entryList) {
                if (!(entry instanceof SettingEntry)) continue;
                ((SettingEntry)entry).onParented();
            }
        }
    }

    protected void onOrphan() {
        for (List<ISettingEntry> entryList : this.entryMap.values()) {
            for (ISettingEntry entry : entryList) {
                if (!(entry instanceof SettingEntry)) continue;
                ((SettingEntry)entry).onOrphan();
            }
        }
    }
}

