/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt2.viewer;

import org.eclipse.draw2d.AncestorListener;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.FreeformListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.LayeredPane;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.gef.GEF;
import org.xmind.gef.ILayerManager;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.ui.gantt2.gefext.GraphicalRootEditPart;
import org.xmind.ui.gantt2.viewer.BackgroundLayout;
import org.xmind.ui.gantt2.viewer.TaskTreeViewer;

public class TaskTreeRootPart
extends GraphicalRootEditPart
implements ILayerManager,
AncestorListener {
    protected Viewport createViewport() {
        Viewport viewport = super.createViewport();
        viewport.setContentsTracksWidth(true);
        return viewport;
    }

    protected void addLayers(LayeredPane layeredPane) {
        Layer backgroundItemLayer = new Layer();
        backgroundItemLayer.setLayoutManager((LayoutManager)new XYLayout());
        layeredPane.add((IFigure)backgroundItemLayer, TaskTreeViewer.LAYER_BACKGROUND_ITEM);
        Layer backgroundLineLayer = new Layer();
        backgroundLineLayer.setLayoutManager((LayoutManager)new XYLayout());
        layeredPane.add((IFigure)backgroundLineLayer, TaskTreeViewer.LAYER_BACKGROUND_LINE);
        Layer backgroundLayer = new Layer();
        backgroundLayer.setLayoutManager((LayoutManager)new BackgroundLayout());
        layeredPane.add((IFigure)backgroundLayer, GEF.LAYER_BACKGROUND);
        final FreeformLayer contentsLayer = new FreeformLayer();
        contentsLayer.setLayoutManager((LayoutManager)new FreeformLayout());
        layeredPane.add((IFigure)contentsLayer, GEF.LAYER_CONTENTS);
        contentsLayer.addFreeformListener(new FreeformListener(){

            public void notifyFreeformExtentChanged() {
                Rectangle bounds = new Rectangle(contentsLayer.getFreeformExtent());
                ((TaskTreeViewer)TaskTreeRootPart.this.getViewer()).setHeight(bounds.height);
            }
        });
    }

    protected void addChildView(IPart child, int index) {
        super.addChildView(child, index);
        IFigure contentsFigure = ((IGraphicalPart)child).getFigure();
        this.getContentPane().setConstraint(contentsFigure, (Object)new Rectangle(0, 0, -1, -1));
        contentsFigure.addAncestorListener((AncestorListener)this);
        this.getBackgroundLayout().setContents(contentsFigure);
    }

    private BackgroundLayout getBackgroundLayout() {
        return (BackgroundLayout)this.getLayer(GEF.LAYER_BACKGROUND).getLayoutManager();
    }

    protected void removeChildView(IPart child) {
        IFigure contentsFigure = ((IGraphicalPart)child).getFigure();
        contentsFigure.removeAncestorListener((AncestorListener)this);
        if (contentsFigure == this.getBackgroundLayout().getContents()) {
            this.getBackgroundLayout().setContents(null);
        }
        super.removeChildView(child);
    }

    public void ancestorAdded(IFigure ancestor) {
    }

    public void ancestorMoved(IFigure ancestor) {
        this.getLayer(GEF.LAYER_BACKGROUND).revalidate();
    }

    public void ancestorRemoved(IFigure ancestor) {
    }
}

