/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.org.freehep.graphicsio.font;

import java.awt.Font;
import java.awt.font.TextAttribute;
import java.io.IOException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import org.xmind.org.freehep.graphics2d.font.CharTable;
import org.xmind.org.freehep.graphics2d.font.FontUtilities;
import org.xmind.org.freehep.graphics2d.font.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FontTable {
    private Hashtable<String, Entry> table = new Hashtable();

    public abstract CharTable getEncodingTable();

    protected abstract void firstRequest(Entry var1, boolean var2, String var3) throws IOException;

    protected abstract String createFontReference(Font var1);

    protected abstract Font substituteFont(Font var1);

    public String fontReference(Font font, boolean embed, String embedAs) {
        String key = this.getKey(font = this.substituteFont(font));
        Entry e = this.table.get(key);
        if (e == null) {
            e = new Entry(font, this.getEncodingTable(font));
            try {
                this.firstRequest(e, embed, embedAs);
            }
            catch (IOException exc) {
                exc.printStackTrace();
            }
            this.table.put(key, e);
        }
        return e.ref;
    }

    private String getKey(Font font) {
        Hashtable<TextAttribute, Object> attributes = FontUtilities.getAttributes(font);
        StringBuffer result = new StringBuffer(font.getName());
        result.append("[WEIGHT:");
        result.append(attributes.get(TextAttribute.WEIGHT));
        result.append("]");
        result.append("[POSTURE:");
        result.append(attributes.get(TextAttribute.POSTURE));
        result.append("]");
        return result.toString();
    }

    public static void normalize(Map<TextAttribute, Object> attributes) {
        String family = (String)attributes.get(TextAttribute.FAMILY);
        if (family.toLowerCase().endsWith(".bold")) {
            attributes.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
            int pos = family.toLowerCase().indexOf(".bold");
            family = family.substring(0, pos);
        } else if (family.toLowerCase().endsWith(".italic")) {
            attributes.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
            int pos = family.toLowerCase().indexOf(".italic");
            family = family.substring(0, pos);
        } else if (family.toLowerCase().endsWith(".plain")) {
            int pos = family.toLowerCase().indexOf(".plain");
            family = family.substring(0, pos);
        }
        family = String.valueOf(family.substring(0, 1).toUpperCase()) + family.substring(1, family.length());
        attributes.put(TextAttribute.FAMILY, family);
    }

    public Collection<Entry> getEntries() {
        return this.table.values();
    }

    private CharTable getEncodingTable(Font font) {
        String fontname = font.getName().toLowerCase();
        if (fontname.indexOf("symbol") >= 0) {
            return Lookup.getInstance().getTable("Symbol");
        }
        if (fontname.indexOf("zapfdingbats") >= 0) {
            return Lookup.getInstance().getTable("Zapfdingbats");
        }
        return this.getEncodingTable();
    }

    protected class Entry {
        private Font font;
        private String ref;
        private CharTable encoding;
        private boolean written;

        private Entry(Font f, CharTable encoding) {
            Hashtable<TextAttribute, Object> attributes = FontUtilities.getAttributes(f);
            attributes.put(TextAttribute.SIZE, new Float(1000.0));
            attributes.remove(TextAttribute.TRANSFORM);
            attributes.remove(TextAttribute.SUPERSCRIPT);
            this.font = new Font(attributes);
            this.ref = FontTable.this.createFontReference(this.font);
            this.encoding = encoding;
            this.written = false;
        }

        public Font getFont() {
            return this.font;
        }

        public String getReference() {
            return this.ref;
        }

        protected void setReference(String ref) {
            this.ref = ref;
        }

        public CharTable getEncoding() {
            return this.encoding;
        }

        public void setWritten(boolean written) {
            this.written = written;
        }

        public boolean isWritten() {
            return this.written;
        }

        public String toString() {
            return String.valueOf(this.ref) + "=" + this.font;
        }
    }
}

