/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.evernote.export;

import com.evernote.clients.NoteStoreClient;
import com.evernote.edam.error.EDAMNotFoundException;
import com.evernote.edam.error.EDAMSystemException;
import com.evernote.edam.error.EDAMUserException;
import com.evernote.edam.type.Data;
import com.evernote.edam.type.LazyMap;
import com.evernote.edam.type.Note;
import com.evernote.edam.type.Notebook;
import com.evernote.edam.type.Resource;
import com.evernote.edam.type.ResourceAttributes;
import com.evernote.thrift.TException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.widgets.Display;
import org.xmind.core.Core;
import org.xmind.core.CoreException;
import org.xmind.core.IMeta;
import org.xmind.core.INotesContent;
import org.xmind.core.IPlainNotesContent;
import org.xmind.core.ISerializer;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.core.util.FileUtils;
import org.xmind.core.util.HyperlinkUtils;
import org.xmind.gef.util.Properties;
import org.xmind.ui.evernote.EvernotePlugin;
import org.xmind.ui.internal.evernote.EvernoteMessages;
import org.xmind.ui.mindmap.GhostShellProvider;
import org.xmind.ui.mindmap.IMindMapViewer;
import org.xmind.ui.mindmap.MindMap;
import org.xmind.ui.mindmap.MindMapExtractor;
import org.xmind.ui.mindmap.MindMapImageExporter;
import org.xmind.ui.util.ImageFormat;
import org.xmind.ui.util.MindMapUtils;
import org.xmind.ui.viewers.ICompositeProvider;

public class EvernoteExporter {
    private static final String SECTION_NAME = "org.xmind.ui.evernote.export";
    private static final String EVERNOTE_TAG = "Evernote";
    private static final String NOTE_GUID_TAG = "Evernote/NoteGuid";
    private static final String SHEET_ID_TAG = "Evernote/SheetGuid";
    private static final String RESOURCE_OVERVIEW = "Overview";
    private static final String RESOURCE_XMIND_FILE = "XMindFile";
    private static final int TITLE_LEVEL = -1;
    private static final int ROOT_TOPIC_LEVEL = 0;
    private static Map<String, String> resourceHashs = new HashMap<String, String>();
    private IMindMapViewer viewer;
    private ITopic rootTopic;
    private NoteStoreClient noteStore;
    private List<EvernoteExportPart> parts;
    private IDialogSettings settings;
    private Note note;

    public EvernoteExporter(IMindMapViewer viewer, NoteStoreClient noteStore) {
        this.viewer = viewer;
        this.rootTopic = viewer.getCentralTopic();
        this.noteStore = noteStore;
        this.parts = new ArrayList<EvernoteExportPart>();
    }

    public void export() throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        this.init();
        String localNoteGuid = this.getMetaData(NOTE_GUID_TAG);
        this.note = this.getNote(localNoteGuid);
        if (localNoteGuid != null && localNoteGuid.equals(this.note.getGuid())) {
            this.update(this.note);
        } else {
            this.write(this.note);
        }
        this.note = this.noteStore.updateNote(this.note);
        this.end();
    }

    private void init() {
        if (this.getBoolean("includeFile")) {
            this.append(new AttachmentPart(this.rootTopic, this.viewer));
        }
        this.append(new TitlePart(this.rootTopic, -1));
        if (this.getBoolean("includeImage")) {
            this.append(new OverviewPart(this.rootTopic));
        }
        if (this.getBoolean("includeText")) {
            this.appendTopic(this.rootTopic, 0);
        }
    }

    private void write(Note note) throws EDAMUserException, EDAMSystemException, TException, EDAMNotFoundException {
        StringBuffer content = new StringBuffer();
        this.writeHeader(content);
        this.writeContent(note, content);
        this.writeWaterMark(content);
        this.writeFooter(content);
        note.setContent(content.toString());
    }

    private void writeContent(Note note, StringBuffer content) {
        for (EvernoteExportPart part : this.parts) {
            part.write(note, content);
        }
    }

    private void update(Note note) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        String content = this.updateContent(note);
        note.setContent(content);
    }

    private String updateContent(Note note) {
        StringBuffer content = new StringBuffer(note.getContent());
        for (EvernoteExportPart part : this.parts) {
            part.update(note, content);
            content = part.getContent();
        }
        return content.toString();
    }

    private void end() throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        this.recordResourceMarkers();
        this.saveInfoToMetaData();
        this.clear();
    }

    private void clear() {
        this.parts = null;
    }

    private void appendTopic(ITopic topic, int level) {
        this.append(new TitlePart(topic, level));
        this.appendTopicContent(topic, level);
    }

    private void appendTopicContent(ITopic topic, int level) {
        this.append(new NotesPart(topic, level));
        int nextLevel = level + 1;
        for (ITopic subTopic : topic.getChildren("attached")) {
            this.appendTopic(subTopic, nextLevel);
        }
        for (ITopic subTopic : topic.getChildren("detached")) {
            this.appendTopic(subTopic, nextLevel);
        }
    }

    private void append(EvernoteExportPart part) {
        if (this.parts == null) {
            this.parts = new ArrayList<EvernoteExportPart>();
        }
        this.parts.add(part);
    }

    private boolean getBoolean(String key) {
        if (this.settings == null) {
            this.settings = this.getSettings();
        }
        return this.settings.getBoolean(key);
    }

    private IDialogSettings getSettings() {
        return EvernotePlugin.getDialogSettings(SECTION_NAME);
    }

    private Note getNote(String noteGuid) throws EDAMUserException, EDAMSystemException, TException, EDAMNotFoundException {
        String notebookName = this.getSettings().get("notebook");
        boolean isSameSheet = this.rootTopic.getOwnedSheet().getId().equals(this.getMetaData(SHEET_ID_TAG));
        if (noteGuid != null && isSameSheet) {
            try {
                Note note = this.noteStore.getNote(noteGuid, true, true, true, true);
                if (notebookName != null && !"".equals(notebookName)) {
                    Notebook notebook = this.noteStore.getNotebook(note.getNotebookGuid());
                    if (!notebookName.equals(notebook.getName())) {
                        note = this.createNote(notebookName);
                    } else if (!note.isActive()) {
                        note = this.createNote(notebookName);
                    }
                }
                return note;
            }
            catch (Exception exception) {}
        }
        return this.createNote(notebookName);
    }

    private Note createNote(String notebookName) throws EDAMUserException, EDAMSystemException, TException, EDAMNotFoundException {
        Notebook notebook = this.getNotebook(notebookName);
        Note note = new Note();
        note.setNotebookGuid(notebook.getGuid());
        note.setTitle(this.getNoteTitle());
        note.setContent(this.getSimpleNoteContent());
        return this.noteStore.createNote(note);
    }

    private Notebook getNotebook(String notebookName) throws EDAMUserException, EDAMSystemException, TException {
        if (notebookName == null || "".equals(notebookName.trim())) {
            return this.noteStore.getDefaultNotebook();
        }
        for (Notebook notebook : this.noteStore.listNotebooks()) {
            if (!notebookName.equals(notebook.getName())) continue;
            return notebook;
        }
        return this.createNotebook(notebookName);
    }

    private Notebook createNotebook(String notebookName) throws EDAMUserException, EDAMSystemException, TException {
        Notebook notebook = new Notebook();
        notebook.setName(notebookName);
        return this.noteStore.createNotebook(notebook);
    }

    private String getNoteTitle() {
        String str = this.rootTopic.getTitleText();
        if (str == null || "".equals(str)) {
            str = EvernoteMessages.EvernoteExporter_Note_untitled;
        }
        String format = str.replaceAll("\\r\\n|\\r|\\n", " ").trim();
        char[] value = format.toCharArray();
        StringBuffer title = new StringBuffer();
        char[] cArray = value;
        int n = value.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c >= ' ' && c != '\u007f') {
                title.append(c);
            }
            ++n2;
        }
        if (title.length() > 255) {
            return title.substring(0, 255);
        }
        return title.toString();
    }

    private void recordResourceMarkers() throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        if (this.getBoolean("includeImage")) {
            this.recordResourceMarker(RESOURCE_OVERVIEW);
        }
        if (this.getBoolean("includeFile")) {
            this.recordResourceMarker(RESOURCE_XMIND_FILE);
        }
    }

    private void recordResourceMarker(String resourceName) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        String resourceGuid = this.findResourceGuid(this.note, resourceHashs.get(resourceName));
        if (resourceGuid != null) {
            this.setApplicationData(resourceGuid, resourceName);
        }
    }

    private void saveInfoToMetaData() {
        ISheet sheet = this.rootTopic.getOwnedSheet();
        if (this.note != null && sheet != null) {
            IMeta meta = this.rootTopic.getOwnedWorkbook().getMeta();
            meta.setValue(NOTE_GUID_TAG, this.note.getGuid());
            meta.setValue(SHEET_ID_TAG, sheet.getId());
        }
    }

    private String getMetaData(String key) {
        IMeta meta = this.rootTopic.getOwnedWorkbook().getMeta();
        return meta.getValue(key);
    }

    private String findResourceGuid(Note note, String resourceDataHash) {
        if (note.isSetResources()) {
            for (Resource r : note.getResources()) {
                String noteResourceHash;
                if (!r.isSetData() || !r.getData().isSetBodyHash() || !(noteResourceHash = this.bytesToHex(r.getData().getBodyHash())).equals(resourceDataHash)) continue;
                return r.getGuid();
            }
        }
        return null;
    }

    private String bytesToHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte hashByte = byArray[n2];
            int intVal = 0xFF & hashByte;
            if (intVal < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(intVal));
            ++n2;
        }
        return sb.toString();
    }

    private void setApplicationData(String guid, String key) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        this.setApplicationData(guid, key, key);
    }

    private void setApplicationData(String guid, String key, String value) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        this.noteStore.setResourceApplicationDataEntry(guid, key, value);
    }

    private void writeHeader(StringBuffer content) {
        content.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        content.append("<!DOCTYPE en-note SYSTEM \"http://xml.evernote.com/pub/enml2.dtd\">");
        content.append("<en-note>");
    }

    private void writeWaterMark(StringBuffer content) {
        SimpleDateFormat format = new SimpleDateFormat("MMMM dd, yyyy");
        String date = format.format(Calendar.getInstance().getTime());
        content.append("<div style=\"text-align:right;font-size:12px;color:rgb(153,153,153)\">");
        content.append("<span>" + date + ". Created by XMind" + "</span>");
        content.append("</div>");
    }

    private void writeFooter(StringBuffer content) {
        content.append("</en-note>");
    }

    private String getSimpleNoteContent() {
        StringBuffer content = new StringBuffer();
        this.writeHeader(content);
        this.writeWaterMark(content);
        this.writeFooter(content);
        return content.toString();
    }

    private static String formatString(String text) {
        char[] value = text.toCharArray();
        StringBuffer sb = new StringBuffer();
        char[] cArray = value;
        int n = value.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c >= ' ' && c != '\u007f') {
                sb.append(c);
            } else if (c == '\r' || c == '\n') {
                sb.append(c);
            } else {
                sb.append(" ");
            }
            ++n2;
        }
        return sb.toString();
    }

    private class AttachmentPart
    extends EvernoteExportPart {
        private static final String MIME_TYPE = "application/octet-stream";
        private final IMindMapViewer viewer;
        private MindMapExtractor extractor;
        private IWorkbook workbook;
        private File tempFolder;

        public AttachmentPart(ITopic topic, IMindMapViewer viewer) {
            super(topic);
            this.viewer = viewer;
        }

        @Override
        protected void write() {
            Resource resource = this.getResource();
            if (resource == null) {
                return;
            }
            String hashHex = this.bytesToHex(resource.getData().getBodyHash());
            this.writeResource(resource, hashHex);
            resourceHashs.put(EvernoteExporter.RESOURCE_XMIND_FILE, hashHex);
            this.note.addToResources(resource);
        }

        @Override
        protected void update() {
            Resource resource = this.getResource();
            if (resource == null) {
                return;
            }
            String newHash = this.bytesToHex(resource.getData().getBodyHash());
            String oldHash = this.findResourceHash(EvernoteExporter.RESOURCE_XMIND_FILE);
            if (newHash == null || oldHash == null) {
                return;
            }
            this.updateResource(oldHash, newHash);
            this.updateData(resource, newHash);
        }

        private void writeResource(Resource resource, String hashHex) {
            this.content.append(this.getResourceContent(resource.getMime(), hashHex));
        }

        private void updateResource(String oldHash, String newHash) {
            String newContentStr = this.content.toString().replace(oldHash, newHash);
            this.content = new StringBuffer(newContentStr);
        }

        private void updateData(Resource resource, String newHash) {
            resourceHashs.put(EvernoteExporter.RESOURCE_XMIND_FILE, newHash);
            this.note.addToResources(resource);
        }

        private File getXMindFile() {
            this.extractor = new MindMapExtractor(this.viewer);
            try {
                this.workbook = this.extractor.extract();
                this.trimWorkbook();
                this.generatePreview();
                this.saveInfoToMetaData(this.workbook);
                if (this.tempFolder == null) {
                    this.tempFolder = new File(this.getTempDir(), "evernote");
                }
                this.tempFolder.mkdirs();
                File tempFile = new File(this.tempFolder, String.valueOf(UUID.randomUUID().toString()) + ".xmind");
                if (!tempFile.exists()) {
                    tempFile.createNewFile();
                }
                ISerializer serializer = Core.getWorkbookBuilder().newSerializer();
                serializer.setWorkbook(this.workbook);
                FileOutputStream output = new FileOutputStream(tempFile);
                try {
                    serializer.setOutputStream((OutputStream)output);
                    serializer.serialize(null);
                }
                finally {
                    ((OutputStream)output).close();
                }
                File file = tempFile;
                return file;
            }
            catch (IOException iOException) {
                return null;
            }
            catch (CoreException coreException) {
                return null;
            }
            finally {
                this.clearTemp();
            }
        }

        private void trimWorkbook() {
            for (ISheet sheet : this.workbook.getSheets()) {
                this.trimWorkbook(sheet.getRootTopic());
            }
        }

        private void trimWorkbook(ITopic topic) {
            String hyperlink = topic.getHyperlink();
            if (hyperlink != null) {
                if (HyperlinkUtils.isAttachmentURL((String)hyperlink)) {
                    topic.setHyperlink(null);
                }
                if (HyperlinkUtils.getProtocolName((String)hyperlink) != null && HyperlinkUtils.getProtocolName((String)hyperlink).equals("file")) {
                    topic.setHyperlink(null);
                }
                if (HyperlinkUtils.isInternalURL((String)hyperlink) && this.workbook.findTopic(hyperlink.substring(hyperlink.indexOf(35) + 1)) == null) {
                    topic.setHyperlink(null);
                }
            }
            if (topic.getExtension("org.xmind.ui.audionotes") != null) {
                topic.deleteExtension("org.xmind.ui.audionotes");
            }
            for (ITopic subTopic : topic.getAllChildren()) {
                this.trimWorkbook(subTopic);
            }
        }

        private void generatePreview() {
            final Display display = Display.getDefault();
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    MindMapImageExporter exporter = new MindMapImageExporter(display);
                    exporter.setSource((Object)new MindMap(AttachmentPart.this.workbook.getPrimarySheet()), null, null);
                    exporter.setTargetWorkbook(AttachmentPart.this.workbook);
                    exporter.export();
                }
            });
        }

        private Resource getResource() {
            File xmind = this.getXMindFile();
            if (xmind != null && xmind.exists()) {
                return this.insertFileToResource(xmind, this.getResourceName(), MIME_TYPE);
            }
            return null;
        }

        private String getResourceName() {
            String format = EvernoteExporter.this.rootTopic.getTitleText().replaceAll("\\r\\n|\\r|\\n", " ");
            char[] value = format.toCharArray();
            StringBuffer title = new StringBuffer();
            char[] cArray = value;
            int n = value.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (c >= ' ') {
                    title.append(c);
                }
                ++n2;
            }
            title.append(".xmind");
            return title.toString();
        }

        private void clearTemp() {
            if (this.extractor != null) {
                this.extractor.delete();
                this.extractor = null;
            }
        }

        private void saveInfoToMetaData(IWorkbook workbook) {
            ISheet sheet = (ISheet)workbook.getSheets().get(0);
            if (this.note != null && sheet != null) {
                IMeta meta = workbook.getMeta();
                meta.setValue(EvernoteExporter.NOTE_GUID_TAG, this.note.getGuid());
                meta.setValue(EvernoteExporter.SHEET_ID_TAG, sheet.getId());
            }
        }
    }

    private abstract class EvernoteExportPart {
        protected final String AND = "&amp;";
        protected final String SPACE = "&nbsp;";
        protected final String LESS_THAN = "&lt;";
        protected final String GREATER_THAN = "&gt;";
        protected final String ALIGN_LEFT = "left";
        protected final String ALIGN_CENTER = "center";
        protected final String ALIGN_RIGHT = "right";
        protected Note note;
        protected ITopic topic;
        protected StringBuffer content;
        private File tempDir;
        private final String TEMP_PATH = "export/evernote";
        private final String IMAGE_PATH = "image";

        public EvernoteExportPart(ITopic topic) {
            this.topic = topic;
        }

        public void write(Note note, StringBuffer content) {
            this.note = note;
            this.content = content;
            this.write();
        }

        public void update(Note note, StringBuffer content) {
            this.note = note;
            this.content = content;
            this.update();
        }

        protected abstract void write();

        protected abstract void update();

        protected File getTempDir() {
            if (this.tempDir == null) {
                this.tempDir = this.createTempDir();
            }
            return this.tempDir;
        }

        private File createTempDir() {
            String id = String.format("%1$tY%1$tm%1$td%1$tH%1$tM%1$tS", System.currentTimeMillis());
            File dir = new File(Core.getWorkspace().getTempDir("export/evernote"), id);
            return FileUtils.ensureDirectory((File)dir);
        }

        protected File getImageDir() {
            return new File(this.getTempDir(), "image");
        }

        protected Data readFileAsData(File file) throws Exception {
            int len;
            FileInputStream in = new FileInputStream(file);
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            byte[] block = new byte[10240];
            while ((len = in.read(block)) >= 0) {
                byteOut.write(block, 0, len);
            }
            in.close();
            byte[] body = byteOut.toByteArray();
            Data data = new Data();
            data.setSize(body.length);
            data.setBodyHash(MessageDigest.getInstance("MD5").digest(body));
            data.setBody(body);
            return data;
        }

        protected String bytesToHex(byte[] bytes) {
            StringBuilder sb = new StringBuilder();
            byte[] byArray = bytes;
            int n = bytes.length;
            int n2 = 0;
            while (n2 < n) {
                byte hashByte = byArray[n2];
                int intVal = 0xFF & hashByte;
                if (intVal < 16) {
                    sb.append('0');
                }
                sb.append(Integer.toHexString(intVal));
                ++n2;
            }
            return sb.toString();
        }

        protected Resource insertFileToResource(File file, String fileName, String mimeType) {
            Data data = null;
            try {
                data = this.readFileAsData(file);
            }
            catch (Exception exception) {
                return null;
            }
            Resource resource = new Resource();
            resource.setData(data);
            resource.setMime(mimeType);
            ResourceAttributes attributes = new ResourceAttributes();
            String name = fileName.replaceAll("\\r\\n|\\r|\\n", " ");
            attributes.setFileName(name);
            resource.setAttributes(attributes);
            return resource;
        }

        protected String getResourceContent(String mimeType, String hashHex) {
            return "<div><en-media type=\"" + mimeType + "\" hash=\"" + hashHex + "\"/></div>";
        }

        protected String getOverviewContent(String mimeType, String hashHex) {
            return "<div style=\"text-align:center\"><en-media type=\"" + mimeType + "\" hash=\"" + hashHex + "\"/></div>";
        }

        protected String findResourceHash(String resourceKey) {
            if (resourceKey == null) {
                return null;
            }
            List resources = this.note.getResources();
            if (resources == null) {
                return null;
            }
            for (Resource r : resources) {
                LazyMap map;
                ResourceAttributes ra = r.getAttributes();
                if (ra == null || (map = ra.getApplicationData()) == null) continue;
                for (String key : map.getKeysOnly()) {
                    if (!resourceKey.equals(key)) continue;
                    return this.bytesToHex(r.getData().getBodyHash());
                }
            }
            return null;
        }

        protected String getPrefix(int level) {
            if (level == 1) {
                return "";
            }
            String str = "&nbsp;";
            int maxPrefix = level <= 5 ? level : 5;
            int i = 1;
            while (i < maxPrefix) {
                str = String.valueOf(str) + str;
                ++i;
            }
            return str;
        }

        protected void writeText(String text, String align, double lineHeight, int fontSize) {
            this.content.append("<div style=\"");
            this.content.append("text-align:" + align + ";\">");
            this.content.append("<span style=\"");
            this.content.append("line-height:" + lineHeight + ";");
            this.content.append("font-size:" + fontSize + "px;\">");
            this.content.append(text);
            this.content.append("</span></div>");
        }

        protected String formatText(String text) {
            return EvernoteExporter.formatString(text.replaceAll("&", "&amp;").replaceAll(">", "&gt;").replaceAll("<", "&lt;"));
        }

        public StringBuffer getContent() {
            return this.content;
        }
    }

    private class NotesPart
    extends EvernoteExportPart {
        private final int level;

        public NotesPart(ITopic topic, int level) {
            super(topic);
            this.level = level;
        }

        @Override
        protected void write() {
            String notes = this.getPlainText();
            if (notes == null) {
                return;
            }
            StringBuffer topicText = new StringBuffer();
            topicText.append(this.getPrefix(this.level));
            topicText.append(this.formatText(notes));
            this.writeText(topicText.toString(), "left", 1.0, 13);
        }

        @Override
        protected void update() {
        }

        private String getPlainText() {
            INotesContent content = this.topic.getNotes().getContent("plain");
            if (content != null && content instanceof IPlainNotesContent) {
                return ((IPlainNotesContent)content).getTextContent();
            }
            return null;
        }
    }

    private class OverviewPart
    extends EvernoteExportPart {
        private static final String MIME_TYPE = "image/png";
        private static final String OVERVIEW_NAME = "overview.png";
        private GhostShellProvider overviewExportShellProvider;

        public OverviewPart(ITopic topic) {
            super(topic);
        }

        @Override
        protected void write() {
            Resource resource = this.getResource();
            if (resource == null) {
                return;
            }
            String hashHex = this.bytesToHex(resource.getData().getBodyHash());
            this.writeOverview(resource, hashHex);
            resourceHashs.put(EvernoteExporter.RESOURCE_OVERVIEW, hashHex);
            this.note.addToResources(resource);
        }

        @Override
        protected void update() {
            Resource resource = this.getResource();
            if (resource == null) {
                return;
            }
            String newHash = this.bytesToHex(resource.getData().getBodyHash());
            String oldHash = this.findResourceHash(EvernoteExporter.RESOURCE_OVERVIEW);
            if (newHash == null || oldHash == null) {
                return;
            }
            this.updateOverview(oldHash, newHash);
            this.updateData(resource, newHash);
        }

        private void writeOverview(Resource resource, String hashHex) {
            this.content.append(this.getOverviewContent(resource.getMime(), hashHex));
        }

        private void updateOverview(String oldHash, String newHash) {
            String newContent = this.content.toString().replace(oldHash, newHash);
            this.content = new StringBuffer(newContent);
        }

        private void updateData(Resource resource, String newHash) {
            resourceHashs.put(EvernoteExporter.RESOURCE_OVERVIEW, newHash);
            this.note.addToResources(resource);
        }

        private File createOverviewDir() {
            File file = new File(this.getImageDir(), String.valueOf(this.topic.getId()) + (String)ImageFormat.PNG.getExtensions().get(0));
            FileUtils.ensureFileParent((File)file);
            final MindMapImageExporter imgExporter = this.createOverviewExporter();
            imgExporter.setTargetFile(file);
            this.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    imgExporter.export();
                }
            });
            return file;
        }

        private MindMapImageExporter createOverviewExporter() {
            if (this.overviewExportShellProvider == null) {
                this.overviewExportShellProvider = new GhostShellProvider(this.getDisplay());
            }
            Properties properties = new Properties();
            MindMapImageExporter imgExporter = new MindMapImageExporter(this.getDisplay());
            imgExporter.setSource((Object)new MindMap(this.topic.getOwnedSheet(), this.topic), (ICompositeProvider)this.overviewExportShellProvider, properties, null);
            return imgExporter;
        }

        private Display getDisplay() {
            return Display.getDefault();
        }

        private Resource getResource() {
            File overview = this.createOverviewDir();
            Resource resource = this.insertFileToResource(overview, OVERVIEW_NAME, MIME_TYPE);
            return resource;
        }
    }

    private class TitlePart
    extends EvernoteExportPart {
        private final int level;

        public TitlePart(ITopic topic, int level) {
            super(topic);
            this.level = level;
        }

        @Override
        protected void write() {
            if (this.level == -1) {
                this.writeTitle();
                return;
            }
            if (this.level == 0) {
                this.writeRootTopic();
                return;
            }
            this.writeTopic();
        }

        @Override
        protected void update() {
        }

        private void writeTitle() {
            String title = this.formatText(this.topic.getTitleText());
            this.writeText(title, "center", 3.0, 25);
        }

        private void writeRootTopic() {
            this.content.append("<h4 style=\"line-height:1.5;font-size=14px\">" + this.formatText(this.topic.getTitleText()) + "</h4>");
        }

        private void writeTopic() {
            StringBuffer topicText = new StringBuffer();
            topicText.append(this.getPrefix(this.level));
            topicText.append(this.getNumbering());
            topicText.append(this.formatText(this.topic.getTitleText()));
            this.writeText(topicText.toString(), "left", 2.0, 14);
        }

        private String getNumbering() {
            String numbering = MindMapUtils.getFullNumberingText((ITopic)this.topic, (String)"org.xmind.numbering.arabic", (String)"org.xmind.numbering.separator.dot");
            if (numbering != null) {
                numbering = String.valueOf(numbering) + " ";
                return numbering;
            }
            return "";
        }
    }
}

