/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.handlers.HandlerUtil;
import org.xmind.ui.properties.IPropertyDescriptor;
import org.xmind.ui.properties.IPropertyEditingEntry;
import org.xmind.ui.properties.IPropertySource;

public class CopyPropertyValueHandler
extends AbstractHandler {
    private ISelectionProvider selectionProvider;

    public CopyPropertyValueHandler() {
        this(null);
    }

    public CopyPropertyValueHandler(ISelectionProvider selectionProvider) {
        this.selectionProvider = selectionProvider;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.copyPropertyValue(event);
        return null;
    }

    private void copyPropertyValue(ExecutionEvent event) {
        ISelection selection;
        ISelection iSelection = selection = this.selectionProvider != null ? this.selectionProvider.getSelection() : HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection == null || !(selection instanceof IStructuredSelection)) {
            return;
        }
        for (Object element : ((IStructuredSelection)selection).toList()) {
            if (!(element instanceof IPropertyEditingEntry)) continue;
            IPropertyEditingEntry entry = (IPropertyEditingEntry)element;
            this.copyValueFromEntry(entry);
            return;
        }
    }

    private void copyValueFromEntry(IPropertyEditingEntry entry) {
        IPropertySource source = (IPropertySource)entry.getAdapter(IPropertySource.class);
        IPropertyDescriptor descriptor = (IPropertyDescriptor)entry.getAdapter(IPropertyDescriptor.class);
        if (source != null && descriptor != null) {
            Object value = source.getPropertyValue(descriptor.getId());
            if (value == null) {
                value = "__default__";
            }
            if (value instanceof String) {
                Clipboard clipboard = new Clipboard(Display.getCurrent());
                clipboard.setContents(new Object[]{value}, new Transfer[]{TextTransfer.getInstance()});
                clipboard.dispose();
            }
        }
    }
}

