/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.sharing;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.xmind.core.command.ICommand;
import org.xmind.core.command.ICommandHandler;
import org.xmind.core.command.arguments.ArrayMapper;
import org.xmind.core.command.arguments.Attributes;
import org.xmind.core.internal.sharing.Base64;
import org.xmind.core.internal.sharing.LocalNetworkSharing;
import org.xmind.core.internal.sharing.LocalNetworkSharingService;
import org.xmind.core.internal.sharing.RemoteSharedLibrary;
import org.xmind.core.internal.sharing.RemoteSharedMap;
import org.xmind.core.sharing.ISharedMap;
import org.xmind.core.sharing.SharingEvent;

public class SharingEventCommandHandler
implements ICommandHandler {
    public IStatus execute(IProgressMonitor monitor, ICommand command, String[] matches) {
        if (matches.length < 1) {
            return new Status(2, "org.xmind.core.sharing", 400, "Missing event type.", null);
        }
        String type = matches[0];
        this.handleRemoteEvent(type, command);
        return Status.OK_STATUS;
    }

    private void handleRemoteEvent(String type, ICommand command) {
        Attributes attrs;
        LocalNetworkSharingService service = (LocalNetworkSharingService)LocalNetworkSharing.getDefault().getSharingService();
        String remoteSymbolicName = command.getArgument("remote");
        if (remoteSymbolicName == null) {
            return;
        }
        RemoteSharedLibrary remoteLibrary = (RemoteSharedLibrary)service.findRemoteLibrary(remoteSymbolicName);
        if (remoteLibrary == null) {
            return;
        }
        SharingEvent.Type eventType = SharingEvent.Type.valueOf(type);
        if (eventType == null) {
            return;
        }
        RemoteSharedMap map = null;
        if (eventType == SharingEvent.Type.SHARED_MAP_ADDED || eventType == SharingEvent.Type.SHARED_MAP_UPDATED) {
            String mapID = command.getArgument("map");
            if (mapID != null) {
                String mapName = command.getArgument("name");
                byte[] thumbnailData = Base64.base64ToByteArray(command.getArgument("thumbnail"));
                boolean missing = Boolean.parseBoolean(command.getArgument("missing"));
                String time = command.getArgument("modified-time");
                long modifiedTime = 0L;
                if (time != null) {
                    modifiedTime = Long.parseLong(time);
                }
                if ((map = (RemoteSharedMap)remoteLibrary.findMapByID(mapID)) == null) {
                    map = new RemoteSharedMap(remoteLibrary.getRemoteCommandService(), remoteLibrary, mapID, mapName, thumbnailData, missing);
                    map.setResourceModifiedTime(modifiedTime);
                    remoteLibrary.addMap(map);
                } else {
                    map.setResourceName(mapName);
                    map.setMissing(missing);
                    map.setThumbnailData(thumbnailData);
                    map.setResourceModifiedTime(modifiedTime);
                    map.invalidateResourceCache();
                }
            }
        } else if (eventType == SharingEvent.Type.SHARED_MAP_REMOVED) {
            ISharedMap mapToRemove;
            String mapID = command.getArgument("map");
            if (mapID != null && (mapToRemove = remoteLibrary.findMapByID(mapID)) != null) {
                remoteLibrary.removeMap(mapToRemove);
            }
        } else if (eventType == SharingEvent.Type.LIBRARY_NAME_CHANGED) {
            String name = command.getArgument("name");
            remoteLibrary.setName(name == null ? "" : name);
            service.getContactManager().updateContactName(remoteLibrary.getContactID(), name);
        } else if (eventType == SharingEvent.Type.CONTACT_ADDED && !(attrs = command.getArguments()).isEmpty()) {
            ArrayMapper mapsReader = new ArrayMapper(attrs.getRawMap(), "maps");
            ArrayList<ISharedMap> maps = new ArrayList<ISharedMap>(mapsReader.getSize());
            while (mapsReader.hasNext()) {
                mapsReader.next();
                String mapID = (String)mapsReader.get("map");
                String mapName = (String)mapsReader.get("name");
                String thumbnailData = (String)mapsReader.get("thumbnail");
                String missing = (String)mapsReader.get("missing");
                long modifiedTime = 0L;
                String time = (String)mapsReader.get("modified-time");
                if (time != null) {
                    modifiedTime = Long.parseLong(time);
                }
                map = new RemoteSharedMap(remoteLibrary.getRemoteCommandService(), remoteLibrary, mapID, mapName, Base64.base64ToByteArray(thumbnailData), Boolean.parseBoolean(missing));
                map.setResourceModifiedTime(modifiedTime);
                maps.add(map);
            }
            remoteLibrary.addMaps(maps);
            map = null;
        }
        service.fireSharingEvent(new SharingEvent(eventType, remoteLibrary, map));
    }
}

