/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.draw2d.geometry;

import java.io.Serializable;
import org.eclipse.draw2d.geometry.Point;
import org.xmind.gef.draw2d.geometry.Geometry;
import org.xmind.gef.draw2d.geometry.PrecisionDimension;
import org.xmind.gef.draw2d.geometry.PrecisionInsets;
import org.xmind.gef.draw2d.geometry.PrecisionRectangle;

public class PrecisionPoint
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 4518124297995254542L;
    public static final PrecisionPoint SINGLETON = new PrecisionPoint();
    public double x;
    public double y;

    public PrecisionPoint() {
    }

    public PrecisionPoint(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public PrecisionPoint(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public PrecisionPoint(Point copy) {
        this(copy.x, copy.y);
    }

    public PrecisionPoint(PrecisionPoint p) {
        this(p.x, p.y);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PrecisionPoint)) {
            return false;
        }
        PrecisionPoint p = (PrecisionPoint)obj;
        return this.x == p.x && this.y == p.y;
    }

    public PrecisionRectangle getExpanded(PrecisionInsets ins) {
        return ins.getBounds(this);
    }

    public PrecisionRectangle getExpanded(double top, double left, double bottom, double right) {
        return new PrecisionRectangle(this.x - left, this.y - top, left + right, top + bottom);
    }

    public double getAngle() {
        return Geometry.getAngle(this.x, this.y);
    }

    public double getAngle(PrecisionPoint p) {
        return Geometry.getAngle(this.x - p.x, this.y - p.y);
    }

    public PrecisionPoint getCopy() {
        return new PrecisionPoint(this.x, this.y);
    }

    public PrecisionDimension getDifference(PrecisionPoint p) {
        return new PrecisionDimension(this.x - p.x, this.y - p.y);
    }

    public double getDistance(PrecisionPoint pt) {
        return Math.sqrt(this.getDistance2(pt));
    }

    public double getDistance2(PrecisionPoint pt) {
        double i = pt.x - this.x;
        double j = pt.y - this.y;
        return i * i + j * j;
    }

    public double getXYDistance(PrecisionPoint p) {
        return Math.abs(this.x - p.x) + Math.abs(this.y - p.y);
    }

    public Point toDraw2DPoint() {
        return PrecisionPoint.toDraw2DPoint(this.x, this.y);
    }

    public static Point toDraw2DPoint(double x, double y) {
        return new Point((int)Math.floor(x + 1.0E-9), (int)Math.floor(y + 1.0E-9));
    }

    public Point toRoundedDraw2DPoint() {
        return new Point((int)Math.round(this.x + 1.0E-9), (int)Math.round(this.y + 1.0E-9));
    }

    public PrecisionPoint getMoved(double angle, double distance) {
        return this.getCopy().move(angle, distance);
    }

    public PrecisionPoint getNegated() {
        return this.getCopy().negate();
    }

    public PrecisionPoint getScaled(double amount) {
        return this.getCopy().scale(amount);
    }

    public PrecisionPoint getScaled(double xAmount, double yAmount) {
        return this.getCopy().scale(xAmount, yAmount);
    }

    public PrecisionPoint getTranslated(double dx, double dy) {
        return this.getCopy().translate(dx, dy);
    }

    public PrecisionPoint getTranslated(PrecisionDimension d) {
        return this.getCopy().translate(d);
    }

    public PrecisionPoint getTranslated(PrecisionPoint p) {
        return this.getCopy().translate(p);
    }

    public PrecisionPoint getTransposed() {
        return this.getCopy().transpose();
    }

    public PrecisionPoint move(double angle, double distance) {
        this.x += distance * Math.cos(angle);
        this.y += distance * Math.sin(angle);
        return this;
    }

    public PrecisionPoint negate() {
        this.x = -this.x;
        this.y = -this.y;
        return this;
    }

    public PrecisionPoint translate(double dx, double dy) {
        this.x += dx;
        this.y += dy;
        return this;
    }

    public PrecisionPoint translate(PrecisionDimension d) {
        return this.translate(d.width, d.height);
    }

    public PrecisionPoint translate(PrecisionPoint p) {
        return this.translate(p.x, p.y);
    }

    public PrecisionPoint scale(double amount) {
        return this.scale(amount, amount);
    }

    public PrecisionPoint scale(double xAmount, double yAmount) {
        this.x *= xAmount;
        this.y *= yAmount;
        return this;
    }

    public PrecisionPoint setLocation(double x, double y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public PrecisionPoint setLocation(Point p) {
        return this.setLocation(p.x, p.y);
    }

    public PrecisionPoint setLocation(PrecisionPoint p) {
        return this.setLocation(p.x, p.y);
    }

    public PrecisionPoint move(PrecisionPoint dest, double xAmount, double yAmount) {
        this.x = this.x * (1.0 - xAmount) + dest.x * xAmount;
        this.y = this.y * (1.0 - yAmount) + dest.y * yAmount;
        return this;
    }

    public PrecisionPoint move(PrecisionPoint dest, double amount) {
        return this.move(dest, amount, amount);
    }

    public PrecisionPoint getMoved(PrecisionPoint dest, double xAmount, double yAmount) {
        return this.getCopy().move(dest, xAmount, yAmount);
    }

    public PrecisionPoint getMoved(PrecisionPoint dest, double amount) {
        return this.getCopy().move(dest, amount);
    }

    public PrecisionPoint getCenter(PrecisionPoint dest) {
        return this.getMoved(dest, 0.5);
    }

    public String toString() {
        return "PrecisionPoint(" + this.x + ", " + this.y + ")";
    }

    public PrecisionPoint transpose() {
        double temp = this.x;
        this.x = this.y;
        this.y = temp;
        return this;
    }
}

