/*
 * Decompiled with CFR 0.152.
 */
package com.apple.dnssd;

import com.apple.dnssd.BrowseListener;
import com.apple.dnssd.DNSSDException;
import com.apple.dnssd.DNSSDRecordRegistrar;
import com.apple.dnssd.DNSSDRegistration;
import com.apple.dnssd.DNSSDService;
import com.apple.dnssd.DomainListener;
import com.apple.dnssd.QueryListener;
import com.apple.dnssd.RegisterListener;
import com.apple.dnssd.RegisterRecordListener;
import com.apple.dnssd.ResolveListener;
import com.apple.dnssd.TXTRecord;

public abstract class DNSSD {
    public static final int MORE_COMING = 1;
    public static final int DEFAULT = 4;
    public static final int NO_AUTO_RENAME = 8;
    public static final int SHARED = 16;
    public static final int UNIQUE = 32;
    public static final int BROWSE_DOMAINS = 64;
    public static final int REGISTRATION_DOMAINS = 128;
    public static final int MAX_DOMAIN_NAME = 1009;
    public static final int ALL_INTERFACES = 0;
    public static final int LOCALHOST_ONLY = -1;
    protected static DNSSD fInstance;

    static {
        try {
            String name = System.getProperty("com.apple.dnssd.DNSSD");
            if (name == null) {
                name = "com.apple.dnssd.AppleDNSSD";
            }
            fInstance = (DNSSD)Class.forName(name).newInstance();
        }
        catch (Exception e) {
            throw new InternalError("cannot instantiate DNSSD" + e);
        }
    }

    public static DNSSDService browse(int flags, int ifIndex, String regType, String domain, BrowseListener listener) throws DNSSDException {
        return DNSSD.getInstance()._makeBrowser(flags, ifIndex, regType, domain, listener);
    }

    public static DNSSDService browse(String regType, BrowseListener listener) throws DNSSDException {
        return DNSSD.browse(0, 0, regType, "", listener);
    }

    public static DNSSDService resolve(int flags, int ifIndex, String serviceName, String regType, String domain, ResolveListener listener) throws DNSSDException {
        return DNSSD.getInstance()._resolve(flags, ifIndex, serviceName, regType, domain, listener);
    }

    public static DNSSDRegistration register(int flags, int ifIndex, String serviceName, String regType, String domain, String host, int port, TXTRecord txtRecord, RegisterListener listener) throws DNSSDException {
        return DNSSD.getInstance()._register(flags, ifIndex, serviceName, regType, domain, host, port, txtRecord, listener);
    }

    public static DNSSDRegistration register(String serviceName, String regType, int port, RegisterListener listener) throws DNSSDException {
        return DNSSD.register(0, 0, serviceName, regType, null, null, port, null, listener);
    }

    public static DNSSDRecordRegistrar createRecordRegistrar(RegisterRecordListener listener) throws DNSSDException {
        return DNSSD.getInstance()._createRecordRegistrar(listener);
    }

    public static DNSSDService queryRecord(int flags, int ifIndex, String serviceName, int rrtype, int rrclass, QueryListener listener) throws DNSSDException {
        return DNSSD.getInstance()._queryRecord(flags, ifIndex, serviceName, rrtype, rrclass, listener);
    }

    public static DNSSDService enumerateDomains(int flags, int ifIndex, DomainListener listener) throws DNSSDException {
        return DNSSD.getInstance()._enumerateDomains(flags, ifIndex, listener);
    }

    public static String constructFullName(String serviceName, String regType, String domain) throws DNSSDException {
        return DNSSD.getInstance()._constructFullName(serviceName, regType, domain);
    }

    public static void reconfirmRecord(int flags, int ifIndex, String fullName, int rrtype, int rrclass, byte[] rdata) {
        DNSSD.getInstance()._reconfirmRecord(flags, ifIndex, fullName, rrtype, rrclass, rdata);
    }

    public static String getNameForIfIndex(int ifIndex) {
        return DNSSD.getInstance()._getNameForIfIndex(ifIndex);
    }

    public static int getIfIndexForName(String ifName) {
        return DNSSD.getInstance()._getIfIndexForName(ifName);
    }

    protected DNSSD() {
    }

    protected static final DNSSD getInstance() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("getDNSSDInstance"));
        }
        return fInstance;
    }

    protected abstract DNSSDService _makeBrowser(int var1, int var2, String var3, String var4, BrowseListener var5) throws DNSSDException;

    protected abstract DNSSDService _resolve(int var1, int var2, String var3, String var4, String var5, ResolveListener var6) throws DNSSDException;

    protected abstract DNSSDRegistration _register(int var1, int var2, String var3, String var4, String var5, String var6, int var7, TXTRecord var8, RegisterListener var9) throws DNSSDException;

    protected abstract DNSSDRecordRegistrar _createRecordRegistrar(RegisterRecordListener var1) throws DNSSDException;

    protected abstract DNSSDService _queryRecord(int var1, int var2, String var3, int var4, int var5, QueryListener var6) throws DNSSDException;

    protected abstract DNSSDService _enumerateDomains(int var1, int var2, DomainListener var3) throws DNSSDException;

    protected abstract String _constructFullName(String var1, String var2, String var3) throws DNSSDException;

    protected abstract void _reconfirmRecord(int var1, int var2, String var3, int var4, int var5, byte[] var6);

    protected abstract String _getNameForIfIndex(int var1);

    protected abstract int _getIfIndexForName(String var1);
}

