/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.mapshot;

import java.io.File;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.xmind.ui.internal.mapshot.MapShot;
import org.xmind.ui.internal.mapshot.Messages;

public class TargetFolderDialog
extends TitleAreaDialog
implements Listener {
    private static String lastFolderPath = null;
    private Button saveToLocalCheck;
    private Text targetFolderInput;
    private Button browseWidget;
    private Button rememberCheck;
    private String targetFolderPath;
    private String initTargetFolderPath;
    private AsyncValidator validator;

    public TargetFolderDialog(Shell parentShell) {
        super(parentShell);
        this.setBlockOnOpen(true);
    }

    protected boolean isResizable() {
        return true;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.TargetFolderDialog_windowTitle);
    }

    public void create() {
        super.create();
        this.setTitle(Messages.TargetFolderDialog_title);
        this.setTitleImage(null);
        this.setMessage(Messages.TargetFolderDialog_description);
        if ("".equals(this.targetFolderInput.getText())) {
            this.validate(false);
            this.getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    TargetFolderDialog.this.openBrowseDialog();
                }
            });
        } else {
            this.validate(true);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite contentArea = new Composite(composite, 0);
        contentArea.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 7;
        gridLayout.marginHeight = 7;
        gridLayout.verticalSpacing = 5;
        gridLayout.horizontalSpacing = 5;
        contentArea.setLayout((Layout)gridLayout);
        this.createSaveToLocalGroup(contentArea);
        Label blank = new Label(contentArea, 0);
        blank.setLayoutData((Object)new GridData(1, 0x1000000, false, true));
        ((GridData)blank.getLayoutData()).minimumHeight = 1;
        ((GridData)blank.getLayoutData()).heightHint = 32;
        Label label = new Label(contentArea, 258);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.createRememberCheck(contentArea);
        return composite;
    }

    private void createSaveToLocalGroup(Composite parent) {
        this.createSaveToLocalCheck(parent);
        this.createTargetFolderInputBar(parent);
    }

    private void createSaveToLocalCheck(Composite parent) {
        this.saveToLocalCheck = new Button(parent, 32);
        this.saveToLocalCheck.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.saveToLocalCheck.setText(Messages.TargetFolderDialog_SaveToLocal_text);
        this.saveToLocalCheck.setSelection(MapShot.getDefault().getPreferenceStore().getBoolean("SAVE_TO_LOCAL_FILE"));
        this.saveToLocalCheck.addListener(13, (Listener)this);
    }

    private void createTargetFolderInputBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.widthHint = -1;
        gridData.heightHint = -1;
        gridData.horizontalIndent = 16;
        composite.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 5;
        composite.setLayout((Layout)gridLayout);
        this.createTargetFolderInput(composite);
        this.createBrowseWidget(composite);
    }

    private void createTargetFolderInput(Composite parent) {
        this.targetFolderInput = new Text(parent, 2052);
        this.targetFolderInput.setLayoutData((Object)new GridData(4, 4, true, false));
        if (lastFolderPath != null) {
            this.targetFolderInput.setText(lastFolderPath);
        } else if (this.initTargetFolderPath != null) {
            this.targetFolderInput.setText(this.targetFolderPath);
        }
        this.targetFolderPath = this.targetFolderInput.getText();
        this.targetFolderInput.addListener(24, (Listener)this);
        this.targetFolderInput.addListener(15, (Listener)this);
    }

    private void createBrowseWidget(Composite parent) {
        this.browseWidget = new Button(parent, 8);
        this.browseWidget.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.browseWidget.setText(Messages.TargetFolderDialog_Browse_text);
        this.browseWidget.addListener(13, (Listener)this);
    }

    private void createRememberCheck(Composite parent) {
        this.rememberCheck = new Button(parent, 32);
        this.rememberCheck.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.rememberCheck.setText(Messages.TargetFolderDialog_Remember_text);
        Label label = new Label(parent, 64);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ((GridData)label.getLayoutData()).horizontalIndent = 16;
        label.setText(Messages.TargetFolderDialog_Remember_description);
    }

    private void setOkEnabled(boolean enabled) {
        Button button = this.getButton(0);
        if (button != null && !button.isDisposed()) {
            button.setEnabled(enabled);
        }
    }

    protected void okPressed() {
        boolean saveToLocal = this.saveToLocalCheck.getSelection();
        if (this.rememberCheck.getSelection()) {
            IPreferenceStore prefStore = MapShot.getDefault().getPreferenceStore();
            prefStore.setValue("SAVE_TO_LOCAL_FILE", saveToLocal);
            if (saveToLocal) {
                prefStore.setValue("TARGET_FOLDER", this.getTargetFolderPath());
            }
            lastFolderPath = null;
        } else if (saveToLocal && this.targetFolderPath != null && !"".equals(this.targetFolderPath)) {
            lastFolderPath = this.targetFolderPath;
        }
        if (saveToLocal) {
            super.okPressed();
        } else {
            this.setReturnCode(1);
            this.close();
        }
    }

    public void setTargetFolderPath(String path) {
        this.targetFolderPath = path;
        if (this.targetFolderInput != null && !this.targetFolderInput.isDisposed()) {
            if (path == null) {
                path = "";
            }
            this.targetFolderInput.setText(path);
        } else {
            this.initTargetFolderPath = path;
        }
    }

    public String getTargetFolderPath() {
        if (this.targetFolderPath == null) {
            return "";
        }
        return this.targetFolderPath;
    }

    protected boolean isSaveToLocalFile() {
        return this.saveToLocalCheck != null && !this.saveToLocalCheck.isDisposed() && this.saveToLocalCheck.getSelection();
    }

    public void handleEvent(Event event) {
        if (event.widget == this.saveToLocalCheck) {
            boolean enabled = this.saveToLocalCheck.getSelection();
            this.targetFolderInput.setEnabled(enabled);
            this.browseWidget.setEnabled(enabled);
            this.validate(true);
        } else if (event.widget == this.targetFolderInput) {
            if (event.type == 24) {
                new AsyncValidator().schedule(this.targetFolderInput.getDisplay());
                this.targetFolderPath = this.targetFolderInput.getText();
            } else if (event.type == 15) {
                this.targetFolderInput.selectAll();
            }
        } else if (event.widget == this.browseWidget) {
            this.openBrowseDialog();
        }
    }

    private void openBrowseDialog() {
        String homePath;
        File homeDir;
        String initPath = this.getTargetFolderPath();
        if ("".equals(initPath) && this.isValidDirectory(homeDir = new File(homePath = System.getProperty("user.home")))) {
            File desktopDir = new File(homeDir, "Desktop");
            initPath = this.isValidDirectory(desktopDir) ? desktopDir.getAbsolutePath() : homeDir.getAbsolutePath();
        }
        DirectoryDialog dialog = new DirectoryDialog(this.getShell(), 4096);
        dialog.setFilterPath(initPath);
        dialog.setText(Messages.TargetFolderDialog_windowTitle);
        dialog.setMessage(Messages.TargetFolderDialog_BrowseDialog_message);
        String path = dialog.open();
        if (path == null) {
            return;
        }
        this.setTargetFolderPath(path);
    }

    private boolean isValidDirectory(File dir) {
        return dir.exists() && dir.isDirectory() && dir.canRead() && dir.canWrite();
    }

    private void validate(boolean showMessage) {
        if (this.targetFolderInput == null || this.targetFolderInput.isDisposed()) {
            return;
        }
        String path = this.targetFolderInput.getText();
        File file = path == null || "".equals(path) ? null : new File(path);
        String errorMessage = null;
        if (this.isSaveToLocalFile()) {
            if (!this.exists(file)) {
                errorMessage = Messages.TargetFolderDialog_PathNotFound_message;
            } else if (!this.isDirectory(file)) {
                errorMessage = Messages.TargetFolderDialog_PathNotDirectory_message;
            } else if (!this.isAvailable(file)) {
                errorMessage = Messages.TargetFolderDialog_PathNotAvailable_message;
            }
        }
        this.setOkEnabled(errorMessage == null);
        if (showMessage) {
            this.setErrorMessage(errorMessage);
        }
        if (this.validator != null) {
            this.validator.cancel();
            this.validator = null;
        }
    }

    private boolean isAvailable(File file) {
        return file.canRead() && file.canWrite();
    }

    private boolean isDirectory(File file) {
        return file.isDirectory();
    }

    private boolean exists(File file) {
        return file != null && file.exists();
    }

    protected class AsyncValidator
    implements Runnable {
        private boolean canceled = false;
        private boolean showMessage = true;

        protected AsyncValidator() {
        }

        public void updateOKButton() {
            boolean oldValue = this.showMessage;
            this.showMessage = false;
            this.run();
            this.showMessage = oldValue;
        }

        public void run() {
            if (this.canceled) {
                return;
            }
            TargetFolderDialog.this.validate(this.showMessage);
        }

        public void cancel() {
            this.canceled = true;
        }

        public void schedule(Display display) {
            if (TargetFolderDialog.this.validator != null) {
                TargetFolderDialog.this.validator.cancel();
                TargetFolderDialog.this.validator = null;
            }
            TargetFolderDialog.this.validator = this;
            display.timerExec(100, (Runnable)this);
        }
    }
}

