/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.notes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.xmind.core.IHtmlNotesContent;
import org.xmind.core.IHyperlinkSpan;
import org.xmind.core.IImageSpan;
import org.xmind.core.INotesContent;
import org.xmind.core.IParagraph;
import org.xmind.core.IPlainNotesContent;
import org.xmind.core.ISpan;
import org.xmind.core.ITextSpan;
import org.xmind.core.internal.dom.NumberUtils;
import org.xmind.core.style.IStyle;
import org.xmind.core.style.IStyled;
import org.xmind.ui.internal.notes.NotesConstants;
import org.xmind.ui.internal.notes.RichDocumentNotesAdapter;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.resources.FontUtils;
import org.xmind.ui.richtext.Hyperlink;
import org.xmind.ui.richtext.IRichDocument;
import org.xmind.ui.richtext.ImagePlaceHolder;
import org.xmind.ui.richtext.LineStyle;
import org.xmind.ui.richtext.RichDocument;
import org.xmind.ui.richtext.RichTextUtils;
import org.xmind.ui.style.StyleUtils;

public class RichDocumentBuilder {
    private static boolean DEBUG = false;
    private RichDocumentNotesAdapter adapter;
    private IRichDocument result;
    private StringBuilder totalText = new StringBuilder();
    private List<StyleRange> textStyles = new ArrayList<StyleRange>();
    private List<LineStyle> lineStyles = new ArrayList<LineStyle>();
    private List<ImagePlaceHolder> images = new ArrayList<ImagePlaceHolder>();
    private List<Hyperlink> hyperlinks = new ArrayList<Hyperlink>();
    private int lineIndex = 0;
    private int totalOffset = 0;
    private Stack<LineStyle> lineStyleStack = new Stack();
    private Stack<StyleRange> textStyleStack = new Stack();
    private StringBuilder currentLine = null;
    private StyleRange lastTextStyle = null;

    public RichDocumentBuilder(RichDocumentNotesAdapter adapter) {
        this.adapter = adapter;
    }

    public void build(INotesContent content) {
        if (content == null) {
            if (DEBUG) {
                System.out.println("empty content");
            }
            this.result = new RichDocument();
            return;
        }
        if (content instanceof IPlainNotesContent) {
            String text = ((IPlainNotesContent)content).getTextContent();
            if (text == null || "".equals(text)) {
                if (DEBUG) {
                    System.out.println("empty plain content");
                }
                this.result = new RichDocument();
                return;
            }
            if (DEBUG) {
                System.out.println("plain content");
            }
            this.result = new RichDocument(text);
            return;
        }
        if (!(content instanceof IHtmlNotesContent)) {
            if (DEBUG) {
                System.out.println("unknown content format");
            }
            this.result = new RichDocument();
            return;
        }
        IHtmlNotesContent html = (IHtmlNotesContent)content;
        this.readContent(html);
        if (this.endsWith(this.totalText, NotesConstants.LINE_DELIMITER)) {
            if (DEBUG) {
                System.out.println("-- delete last line delimiter -- ");
            }
            this.deleteLastLineDelimiter();
        }
        this.result = new RichDocument(this.totalText.toString());
        this.result.setTextStyles(this.textStyles.toArray(new StyleRange[this.textStyles.size()]));
        this.result.setLineStyles(this.lineStyles.toArray(new LineStyle[this.lineStyles.size()]));
        this.result.setImages(this.images.toArray(new ImagePlaceHolder[this.images.size()]));
        this.result.setHyperlinks(this.hyperlinks.toArray(new Hyperlink[this.hyperlinks.size()]));
        if (DEBUG) {
            System.out.println(this.result.get());
            System.out.println(Arrays.toString(this.result.getTextStyles()));
            System.out.println(Arrays.toString(this.result.getLineStyles()));
            System.out.println(Arrays.toString(this.result.getImages()));
            System.out.println(Arrays.toString(this.result.getHyperlinks()));
        }
    }

    private boolean endsWith(StringBuilder sb, String s) {
        if (s.length() == 0 || sb.length() < s.length()) {
            return false;
        }
        int i = 0;
        while (i < s.length()) {
            char c2;
            char c = sb.charAt(sb.length() - i - 1);
            if (c != (c2 = s.charAt(s.length() - i - 1))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void deleteLastLineDelimiter() {
        int length = NotesConstants.LENGTH_DELIMITER;
        this.totalText.delete(this.totalText.length() - length, this.totalText.length());
        if (this.lastTextStyle != null && this.lastTextStyle.start + this.lastTextStyle.length == this.totalOffset) {
            if (this.lastTextStyle.length <= length) {
                this.textStyles.remove(this.lastTextStyle);
            } else {
                this.lastTextStyle.length -= length;
            }
        }
    }

    private void readContent(IHtmlNotesContent html) {
        for (IParagraph p : html.getParagraphs()) {
            this.readParagraph(p);
        }
    }

    private void readParagraph(IParagraph p) {
        LineStyle currentLineStyle;
        if (this.currentLine != null) {
            this.endLine();
        }
        if (DEBUG) {
            System.out.println("start line: " + this.lineIndex);
        }
        if ((currentLineStyle = this.createLineStyle(p)) != null) {
            currentLineStyle.lineIndex = this.lineIndex;
            this.lineStyles.add(currentLineStyle);
            if (DEBUG) {
                System.out.println("line style added: " + currentLineStyle);
            }
        }
        this.lineStyleStack.push(currentLineStyle);
        if (DEBUG) {
            System.out.println("line style pushed: " + currentLineStyle);
        }
        this.currentLine = new StringBuilder();
        this.readParagraphContent(p);
        this.endLine();
        this.lineStyleStack.pop();
    }

    private LineStyle createLineStyle(IParagraph p) {
        LineStyle currentLineStyle = this.newLineStyle();
        IStyle style = this.getStyle((IStyled)p);
        if (style != null) {
            String alignment = style.getProperty("fo:text-align");
            if (DEBUG) {
                System.out.println("alingment: " + alignment);
            }
            if (alignment != null) {
                currentLineStyle.alignment = this.toSWTAlignment(alignment);
            }
            String bulletStyle = style.getProperty("fo:text-bullet");
            if (DEBUG) {
                System.out.println("bulletStyle: " + bulletStyle);
            }
            if (bulletStyle != null) {
                currentLineStyle.bulletStyle = this.getBulletStyle(bulletStyle);
            }
        } else if (DEBUG) {
            System.out.println("no line style");
        }
        return currentLineStyle;
    }

    private String getBulletStyle(String bulletStyle) {
        if ("bullet".equals(bulletStyle)) {
            return "bullet";
        }
        if ("number".equals(bulletStyle)) {
            return "number";
        }
        return "none";
    }

    private void readParagraphContent(IParagraph p) {
        for (ISpan span : p.getSpans()) {
            if (span instanceof IImageSpan) {
                this.readImage((IImageSpan)span);
                continue;
            }
            if (span instanceof ITextSpan) {
                this.readText((ITextSpan)span);
                continue;
            }
            if (!(span instanceof IHyperlinkSpan)) continue;
            this.readHyperlink((IHyperlinkSpan)span);
        }
    }

    private void endLine() {
        if (DEBUG) {
            System.out.println("end line: " + this.lineIndex);
        }
        this.sumLineIndent();
        this.appendLineDelimiter();
        ++this.lineIndex;
        this.currentLine = null;
    }

    private void ensureLineStart() {
        if (this.currentLine != null) {
            return;
        }
        LineStyle currentLineStyle = this.newLineStyle();
        currentLineStyle.lineIndex = this.lineIndex;
        if (!this.lineStyleStack.isEmpty()) {
            this.lineStyleStack.pop();
        }
        this.lineStyleStack.push(currentLineStyle);
        this.currentLine = new StringBuilder();
    }

    private void appendLineDelimiter() {
        this.totalText.append(NotesConstants.LINE_DELIMITER);
        if (this.lastTextStyle != null && this.lastTextStyle.start + this.lastTextStyle.length == this.totalOffset) {
            this.lastTextStyle.length += NotesConstants.LENGTH_DELIMITER;
        }
        this.totalOffset += NotesConstants.LENGTH_DELIMITER;
    }

    private void sumLineIndent() {
        if (this.currentLine == null) {
            return;
        }
        if (this.lineStyleStack.isEmpty()) {
            return;
        }
        int indent = this.calcIndentCount(this.currentLine);
        LineStyle lastLineStyle = this.lineStyleStack.peek();
        lastLineStyle.indent = indent;
    }

    private LineStyle newLineStyle() {
        LineStyle lastLineStyle;
        LineStyle lineStyle = lastLineStyle = this.lineStyleStack.isEmpty() ? null : this.lineStyleStack.peek();
        if (DEBUG) {
            System.out.println("last line style: " + lastLineStyle);
        }
        if (lastLineStyle == null) {
            return (LineStyle)RichTextUtils.DEFAULT_LINE_STYLE.clone();
        }
        return (LineStyle)lastLineStyle.clone();
    }

    private StyleRange newTextStyle() {
        StyleRange lastTextStyle;
        StyleRange styleRange = lastTextStyle = this.textStyleStack.isEmpty() ? null : this.textStyleStack.peek();
        if (lastTextStyle == null) {
            return null;
        }
        return (StyleRange)lastTextStyle.clone();
    }

    private void readImage(IImageSpan span) {
        Image image;
        String uri = span.getSource();
        if (uri != null && (image = this.adapter.getImageFromUrl(uri)) != null) {
            this.ensureLineStart();
            String s = "\ufffc";
            int length = s.length();
            this.totalText.append(s);
            this.currentLine.append(s);
            StyleRange style = (StyleRange)RichTextUtils.DEFAULT_STYLE.clone();
            style.start = this.totalOffset;
            style.length = length;
            Rectangle rect = image.getBounds();
            style.metrics = new GlyphMetrics(rect.height, 0, rect.width);
            ImagePlaceHolder imagePlaceHolder = new ImagePlaceHolder(this.totalOffset, image);
            this.images.add(imagePlaceHolder);
            if (!RichTextUtils.merge((StyleRange)style, (StyleRange)this.lastTextStyle)) {
                this.textStyles.add(style);
                this.lastTextStyle = style;
            }
            this.totalOffset += length;
        }
    }

    private void readHyperlink(IHyperlinkSpan span) {
        String urlString = span.getHref();
        int start = this.totalOffset;
        for (ISpan s : span.getSpans()) {
            if (s instanceof ITextSpan) {
                this.readText((ITextSpan)s);
                continue;
            }
            if (!(s instanceof IImageSpan)) continue;
            this.readImage((IImageSpan)s);
        }
        int length = this.totalOffset - start;
        Hyperlink hyperlink = new Hyperlink(start, length, urlString);
        this.hyperlinks.add(hyperlink);
    }

    private void readText(ITextSpan span) {
        StyleRange textStyle = this.createTextStyle(this.getStyle((IStyled)span));
        this.textStyleStack.push(textStyle);
        this.appendText(span.getTextContent(), textStyle);
        this.textStyleStack.pop();
    }

    private void appendText(String text, StyleRange textStyle) {
        this.ensureLineStart();
        int length = text.length();
        this.totalText.append(text);
        this.currentLine.append(text);
        if (textStyle != null) {
            textStyle.start = this.totalOffset;
            textStyle.length = length;
            if (!RichTextUtils.merge((StyleRange)textStyle, (StyleRange)this.lastTextStyle)) {
                this.textStyles.add(textStyle);
                this.lastTextStyle = textStyle;
            }
        }
        this.totalOffset += length;
    }

    private StyleRange createTextStyle(IStyle style) {
        boolean italic;
        StyleRange textStyle = this.newTextStyle();
        if (style == null) {
            return textStyle;
        }
        String name = style.getProperty("fo:font-family");
        String availableFontName = FontUtils.getAAvailableFontNameFor((String)name);
        String string = name = availableFontName != null ? availableFontName : name;
        if ("$system$".equals(name)) {
            name = JFaceResources.getDefaultFont().getFontData()[0].getName();
        }
        String height = style.getProperty("fo:font-size");
        String weight = style.getProperty("fo:font-weight");
        String fontStyle = style.getProperty("fo:font-style");
        String foreground = style.getProperty("fo:color");
        String background = style.getProperty("fo:background-color");
        String decoration = style.getProperty("fo:text-decoration");
        if (name == null && height == null && weight == null && fontStyle == null && foreground == null && background == null && decoration == null) {
            return textStyle;
        }
        if (name == null) {
            name = RichTextUtils.DEFAULT_FONT_DATA.getName();
        }
        int size = NumberUtils.safeParseInt((String)StyleUtils.trimNumber(height), (int)RichTextUtils.DEFAULT_FONT_DATA.getHeight());
        boolean bold = weight != null && weight.contains("bold");
        boolean bl = italic = fontStyle != null && fontStyle.contains("italic");
        if (textStyle == null) {
            textStyle = new StyleRange();
        }
        textStyle.font = FontUtils.getFont((String)name, (int)size, (boolean)bold, (boolean)italic);
        textStyle.foreground = ColorUtils.getColor((String)foreground);
        textStyle.background = ColorUtils.getColor((String)background);
        textStyle.underline = decoration != null && decoration.contains("underline");
        textStyle.strikeout = decoration != null && decoration.contains("line-through");
        return textStyle;
    }

    private int toSWTAlignment(String value) {
        if ("center".equals(value)) {
            return 0x1000000;
        }
        if ("right".equals(value)) {
            return 131072;
        }
        return 16384;
    }

    private int calcIndentCount(StringBuilder line) {
        int indent = 0;
        int i = 0;
        while (i < line.length()) {
            char c = line.charAt(i);
            if (c != '\t') {
                return indent;
            }
            ++indent;
            ++i;
        }
        return indent;
    }

    private IStyle getStyle(IStyled styled) {
        String styleId = styled.getStyleId();
        if (styleId != null) {
            return this.adapter.getWorkbook().getStyleSheet().findStyle(styleId);
        }
        return null;
    }

    public IRichDocument getResult() {
        return this.result;
    }
}

