/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.handlers;

import java.net.URI;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.xmind.ui.IEditorHistory;
import org.xmind.ui.internal.dialogs.DialogMessages;
import org.xmind.ui.mindmap.MindMapUI;

public class ClearWorkbookHistoryHandler
extends AbstractHandler
implements IEditorHistory.IEditorHistoryListener {
    public ClearWorkbookHistoryHandler() {
        MindMapUI.getEditorHistory().addEditorHistoryListener(this);
        this.setBaseEnabled(this.calcEnabledState());
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.doExecute(event);
        return null;
    }

    private void doExecute(ExecutionEvent event) {
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        if (shell == null || shell.isDisposed()) {
            return;
        }
        if (!MessageDialog.openConfirm((Shell)shell, (String)DialogMessages.ConfirmClearRecentFileListDialog_title, (String)DialogMessages.ConfirmClearRecentFileListDialog_message)) {
            return;
        }
        MindMapUI.getEditorHistory().clear();
    }

    @Override
    public void editorHistoryChanged() {
        this.setBaseEnabled(this.calcEnabledState());
    }

    private boolean calcEnabledState() {
        int itemsToShow = WorkbenchPlugin.getDefault().getPreferenceStore().getInt("RECENT_FILES");
        if (itemsToShow <= 0) {
            return false;
        }
        URI[] items = MindMapUI.getEditorHistory().getRecentInputURIs(itemsToShow);
        return items.length != 0;
    }
}

