/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editor;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.MindMapUIPlugin;

public class OverviewCheckContribution
extends ContributionItem
implements IPropertyChangeListener,
Listener {
    private static final String SHOW_OVERVIEW = "show_overview.png";
    private static final String HIDE_OVERVIEW = "hide_overview.png";
    private IPreferenceStore ps = MindMapUIPlugin.getDefault().getPreferenceStore();
    private Control control;
    private ToolItem check;
    private ResourceManager resources;

    public void fill(ToolBar parent, int index) {
        Composite composite = new Composite((Composite)parent, 0);
        this.resources = new LocalResourceManager(JFaceResources.getResources(), (Control)composite);
        this.check = index < 0 ? new ToolItem(parent, 8) : new ToolItem(parent, 8, index++);
        this.check.setImage((Image)this.resources.get((DeviceResourceDescriptor)this.getImageDescriptor(HIDE_OVERVIEW)));
        this.check.setToolTipText(MindMapMessages.OverviewCheck_Overview_ON);
        this.check.addListener(13, (Listener)this);
        this.updateCheck();
        this.ps.removePropertyChangeListener((IPropertyChangeListener)this);
        this.ps.addPropertyChangeListener((IPropertyChangeListener)this);
        this.control = composite;
    }

    private void updateCheck() {
        boolean value = this.getValue();
        this.check.setImage((Image)this.resources.get((DeviceResourceDescriptor)this.getImageDescriptor(value ? HIDE_OVERVIEW : SHOW_OVERVIEW)));
        this.check.setToolTipText(value ? MindMapMessages.OverviewCheck_Overview_OFF : MindMapMessages.OverviewCheck_Overview_ON);
    }

    private boolean getValue() {
        return this.ps.getBoolean("showOverview");
    }

    public void handleEvent(Event event) {
        if (event.widget == this.check) {
            event.display.timerExec(10, new Runnable(){

                @Override
                public void run() {
                    OverviewCheckContribution.this.changeStatus(!OverviewCheckContribution.this.getValue());
                }
            });
        }
    }

    public void propertyChange(final PropertyChangeEvent event) {
        if (this.control == null || this.control.isDisposed()) {
            return;
        }
        this.control.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                OverviewCheckContribution.this.update(event.getProperty());
            }
        });
    }

    public void update(String id) {
        if (this.check == null || this.check.isDisposed() || this.ps == null) {
            return;
        }
        if (id == null || "showOverview".equals(id)) {
            this.updateCheck();
        }
    }

    private void changeStatus(boolean value) {
        this.ps.setValue("showOverview", value);
    }

    public void dispose() {
        if (this.check != null) {
            this.check.dispose();
            this.check = null;
        }
        this.control = null;
        if (this.ps != null) {
            this.ps.removePropertyChangeListener((IPropertyChangeListener)this);
            this.ps = null;
        }
    }

    private ImageDescriptor getImageDescriptor(String path) {
        URL url;
        try {
            url = new URL("platform:/plugin/org.xmind.ui.mindmap/$nl$/icons/" + path);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        URL locatedURL = FileLocator.find((URL)url);
        if (locatedURL != null) {
            url = locatedURL;
        }
        return ImageDescriptor.createFromURL((URL)url);
    }
}

