/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.e4handlers;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.dialogs.DialogUtils;
import org.xmind.ui.mindmap.IWorkbookRef;
import org.xmind.ui.mindmap.IWorkbookRefFactory;
import org.xmind.ui.mindmap.MindMapUI;

public class OpenWorkbooksHandler {
    private static final List<String> NO_URIS = Collections.emptyList();
    private static final String LOCAL_FILE_SCHEME = "file";
    private static final String SEAWIND_FILE_SCHEME = "seawind";

    @Inject
    public void execute(IWorkbenchWindow window, ParameterizedCommand command) {
        String uri = (String)command.getParameterMap().get("org.xmind.ui.command.openWorkbook.uri");
        OpenWorkbooksHandler.execute(window, uri);
    }

    public static void execute(IWorkbenchWindow window, String uri) {
        OpenWorkbooksHandler.execute(window, uri == null ? NO_URIS : Arrays.asList(uri));
    }

    public static void execute(IWorkbenchWindow window, List<String> uris) {
        if (window == null) {
            return;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return;
        }
        if (uris.isEmpty()) {
            List<File> files = DialogUtils.openXMindFiles(Display.getDefault().getActiveShell(), 2);
            uris = new ArrayList<String>(files.size());
            for (File file : files) {
                uris.add(file.toURI().toString());
            }
        }
        IEditorPart lastEditor = null;
        for (String uri : uris) {
            IEditorPart editor;
            if (uri == null || (editor = OpenWorkbooksHandler.openMindMapEditor(page, uri)) == null) continue;
            lastEditor = editor;
        }
        if (lastEditor != null) {
            page.activate(lastEditor);
        }
    }

    private static IEditorPart openMindMapEditor(final IWorkbenchPage page, final String uri) {
        final IEditorPart[] editor = new IEditorPart[1];
        SafeRunner.run((ISafeRunnable)new SafeRunnable(){

            public void run() throws Exception {
                if (uri == null || "".equals(uri)) {
                    return;
                }
                URI workbookURI = URI.create(uri);
                IWorkbookRefFactory factory = MindMapUIPlugin.getDefault().getWorkbookRefFactory();
                IWorkbookRef workbookRef = factory.createWorkbookRef(workbookURI, null);
                if (!workbookRef.exists()) {
                    OpenWorkbooksHandler.showFileNotFoundDialog(workbookURI);
                    return;
                }
                IEditorInput input = MindMapUI.getEditorInputFactory().createEditorInput(workbookURI);
                editor[0] = page.openEditor(input, "org.xmind.ui.MindMapEditor", false);
            }
        });
        return editor[0];
    }

    private static void showFileNotFoundDialog(URI uri) {
        Assert.isNotNull((Object)uri);
        String scheme = uri.getScheme();
        if (scheme == null || "".equalsIgnoreCase(scheme)) {
            return;
        }
        if (LOCAL_FILE_SCHEME.equalsIgnoreCase(scheme)) {
            MessageDialog.openWarning(null, (String)MindMapMessages.FileNotExistDialog_Title, (String)MindMapMessages.FileNotExistDialog_Message);
        } else if (SEAWIND_FILE_SCHEME.equalsIgnoreCase(scheme)) {
            MessageDialog.openWarning(null, (String)MindMapMessages.CloudFileNotExistDialog_Title, (String)MindMapMessages.CloudFileNotExistDialog_Message);
        }
    }
}

