/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.decorations;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.xmind.gef.draw2d.geometry.Geometry;
import org.xmind.gef.draw2d.graphics.Path;
import org.xmind.ui.internal.decorations.SegmentedBoundaryDecoration;

public class TensionBoundaryDecoration
extends SegmentedBoundaryDecoration {
    private static final float f = 0.5f;
    private static final float c1 = 0.25f;
    private static final float c2 = 0.75f;
    private float topInset;
    private float leftInset;
    private float bottomInset;
    private float rightInset;

    public TensionBoundaryDecoration() {
    }

    public TensionBoundaryDecoration(String id) {
        super(id);
    }

    @Override
    protected float getMarginAmount() {
        return 0.2f;
    }

    @Override
    public void validate(IFigure figure) {
        super.validate(figure);
        Insets ins = figure.getInsets();
        this.topInset = (float)ins.top * 0.5f;
        this.leftInset = (float)ins.left * 0.5f;
        this.bottomInset = (float)ins.bottom * 0.5f;
        this.rightInset = (float)ins.right * 0.5f;
    }

    @Override
    protected void sketchBottomSegment(IFigure figure, Path shape, float x, float y, float bottom, int index) {
        shape.cubicTo(x - this.hstep * 0.25f, y - this.bottomInset, x - this.hstep * 0.75f, y - this.bottomInset, x - this.hstep, y);
    }

    @Override
    protected void sketchLeftSegment(IFigure figure, Path shape, float x, float y, float left, int index) {
        shape.cubicTo(x + this.leftInset, y - this.vstep * 0.25f, x + this.leftInset, y - this.vstep * 0.75f, x, y - this.vstep);
    }

    @Override
    protected void sketchRightSegment(IFigure figure, Path shape, float x, float y, float right, int index) {
        shape.cubicTo(x - this.rightInset, y + this.vstep * 0.25f, x - this.rightInset, y + this.vstep * 0.75f, x, y + this.vstep);
    }

    @Override
    protected void sketchTopSegment(IFigure figure, Path shape, float x, float y, float top, int index) {
        shape.cubicTo(x + this.hstep * 0.25f, y + this.topInset, x + this.hstep * 0.75f, y + this.topInset, x + this.hstep, y);
    }

    @Override
    public Insets getPreferredInsets(IFigure figure, int width, int height) {
        return Geometry.add((Insets)super.getPreferredInsets(figure, width, height), (int)10);
    }
}

