/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.actions;

import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.xmind.core.ITopic;
import org.xmind.core.marker.IMarker;
import org.xmind.core.marker.IMarkerGroup;
import org.xmind.core.marker.IMarkerRef;
import org.xmind.gef.ISourceProvider;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.CompoundCommand;
import org.xmind.gef.command.ICommandStack;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.ui.commands.AddMarkerCommand;
import org.xmind.ui.commands.CommandMessages;
import org.xmind.ui.commands.DeleteMarkerCommand;
import org.xmind.ui.util.MarkerImageDescriptor;

public class GroupMarkers
extends ContributionItem {
    private ISelectionProvider selectionProvider;
    private IMarkerRef sourceMarkerRef;

    public GroupMarkers() {
        this.setId("org.xmind.ui.markerGroup");
    }

    public void setSelectionProvider(ISelectionProvider selectionProvider) {
        this.selectionProvider = selectionProvider;
    }

    public boolean isVisible() {
        return this.sourceMarkerRef != null;
    }

    public void setSourceMarkerRef(IMarkerRef sourceMarkerRef) {
        this.sourceMarkerRef = sourceMarkerRef;
    }

    public boolean isDynamic() {
        return true;
    }

    public void fill(Menu menu, int index) {
        IMarkerGroup group;
        if (this.sourceMarkerRef == null) {
            return;
        }
        ITopic topic = this.sourceMarkerRef.getParent();
        String sourceMarkerId = this.sourceMarkerRef.getMarkerId();
        IMarker sourceMarker = topic.getOwnedWorkbook().getMarkerSheet().findMarker(sourceMarkerId);
        if (sourceMarker != null && (group = sourceMarker.getParent()) != null && !group.isHidden()) {
            for (IMarker marker : group.getMarkers()) {
                if (marker.isHidden()) continue;
                String targetMarkerId = marker.getId();
                new ActionContributionItem((IAction)new ReplaceMarkerAction(topic, sourceMarkerId, targetMarkerId)).fill(menu, index++);
            }
            new Separator().fill(menu, index++);
            new ActionContributionItem((IAction)new DeleteMarkerAction(topic, sourceMarkerId)).fill(menu, index++);
        }
    }

    private class DeleteMarkerAction
    extends Action {
        private ITopic topic;
        private String sourceMarkerId;

        public DeleteMarkerAction(ITopic topic, String sourceMarkerId) {
            this.topic = topic;
            this.sourceMarkerId = sourceMarkerId;
            this.setText(CommandMessages.Command_Delete);
        }

        public void run() {
            ICommandStack cs;
            IEditorPart editor;
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (page != null && (editor = page.getActiveEditor()) instanceof IGraphicalEditor && (cs = ((IGraphicalEditor)editor).getCommandStack()) != null) {
                Command cmd = this.createRemoveMarkerCommand();
                cs.execute(cmd);
            }
        }

        private Command createRemoveMarkerCommand() {
            return new CompoundCommand(CommandMessages.Command_DeleteMarker, new Command[]{new DeleteMarkerCommand(this.topic, this.sourceMarkerId)});
        }
    }

    private class ReplaceMarkerAction
    extends Action {
        private ITopic topic;
        private String sourceMarkerId;
        private String targetMarkerId;

        public ReplaceMarkerAction(ITopic topic, String sourceMarkerId, String targetMarkerId) {
            this.topic = topic;
            this.sourceMarkerId = sourceMarkerId;
            this.targetMarkerId = targetMarkerId;
            this.setText(topic.getOwnedSheet().getLegend().getMarkerDescription(targetMarkerId));
            this.setImageDescriptor(MarkerImageDescriptor.createFromMarker(topic.getOwnedWorkbook().getMarkerSheet().findMarker(targetMarkerId), 16, 16));
            boolean sameMarker = sourceMarkerId.equals(targetMarkerId);
            this.setEnabled(!sameMarker);
            this.setChecked(sameMarker);
        }

        public void run() {
            if (!this.isEnabled()) {
                return;
            }
            IGraphicalEditor page = (IGraphicalEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            ICommandStack cs = page.getCommandStack();
            if (cs != null) {
                Command cmd = this.createReplaceMarkerCommand();
                cs.execute(cmd);
                if (cmd instanceof ISourceProvider) {
                    this.select(((ISourceProvider)cmd).getSources());
                }
            }
        }

        private void select(List<Object> sources) {
            if (GroupMarkers.this.selectionProvider != null) {
                GroupMarkers.this.selectionProvider.setSelection((ISelection)new StructuredSelection(sources));
            }
        }

        private Command createReplaceMarkerCommand() {
            return new CompoundCommand(CommandMessages.Command_ReplaceMarker, new Command[]{new DeleteMarkerCommand(this.topic, this.sourceMarkerId), new AddMarkerCommand(this.topic, this.targetMarkerId)});
        }
    }
}

