/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.odg.geom;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.IllegalPathStateException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;

public class EnhancedPath
extends ArrayList<Segment>
implements Shape {
    private transient GeneralPath generalPath;
    private transient Rectangle2D.Double bounds;
    private int windingRule = 0;

    @Override
    public Rectangle getBounds() {
        return this.getBounds2D().getBounds();
    }

    @Override
    public Rectangle2D getBounds2D() {
        if (this.bounds == null) {
            // empty if block
        }
        return (Rectangle2D.Double)this.bounds.clone();
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        this.validatePath();
        return this.generalPath.contains(x, y, w, h);
    }

    @Override
    public boolean contains(Point2D p) {
        this.validatePath();
        return this.generalPath.contains(p);
    }

    @Override
    public boolean contains(double x, double y) {
        this.validatePath();
        return this.generalPath.contains(x, y);
    }

    @Override
    public boolean contains(Rectangle2D r) {
        this.validatePath();
        return this.generalPath.contains(r);
    }

    @Override
    public boolean intersects(Rectangle2D r) {
        this.validatePath();
        return this.generalPath.intersects(r);
    }

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        this.validatePath();
        return this.generalPath.intersects(x, y, w, h);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        this.validatePath();
        return this.generalPath.getPathIterator(at);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        this.validatePath();
        return this.generalPath.getPathIterator(at, flatness);
    }

    public void validatePath() {
        if (this.generalPath == null) {
            this.generalPath = this.toGeneralPath();
        }
    }

    public void invalidatePath() {
        this.generalPath = null;
        this.bounds = null;
    }

    public GeneralPath toGeneralPath() {
        GeneralPath gp = new GeneralPath();
        return gp;
    }

    public void moveTo(Object xm1, Object ym1) {
        this.add(new Segment(SegType.MOVETO, xm1, ym1));
    }

    public void lineTo(Object x1, Object y1) {
        if (this.size() == 0 || ((Segment)this.get((int)(this.size() - 1))).type == SegType.CLOSE) {
            throw new IllegalPathStateException("lineTo is only allowed when a path segment is open");
        }
        this.add(new Segment(SegType.LINETO, x1, y1));
    }

    public void close() {
        if (this.size() == 0 || ((Segment)this.get((int)(this.size() - 1))).type == SegType.CLOSE) {
            throw new IllegalPathStateException("close is only allowed when a path segment is open");
        }
        this.add(new Segment(SegType.CLOSE, new Object[0]));
    }

    public void quadTo(Object x1, Object y1, Object x2, Object y2) {
        if (this.size() == 0 || ((Segment)this.get((int)(this.size() - 1))).type == SegType.CLOSE) {
            throw new IllegalPathStateException("quadTo is only allowed when a path segment is open");
        }
        this.add(new Segment(SegType.QUADTO, x1, y1, x2, y2));
    }

    public void curveTo(Object x1, Object y1, Object x2, Object y2, Object x3, Object y3) {
        if (this.size() == 0 || ((Segment)this.get((int)(this.size() - 1))).type == SegType.CLOSE) {
            throw new IllegalPathStateException("curveTo is only allowed when a path segment is open");
        }
        this.add(new Segment(SegType.CURVETO, x1, y1, x2, y2, x3, y3));
    }

    public void arcTo(Object x1, Object y1, Object x2, Object y2, Object x3, Object y3, Object x4, Object y4) {
        if (this.size() == 0) {
            throw new IllegalPathStateException("arcTo only allowed when not empty");
        }
        this.add(new Segment(SegType.ARCTO, x1, y1, x2, y2, x3, y3, x4, y4));
    }

    public void clockwiseArcTo(Object x1, Object y1, Object x2, Object y2, Object x3, Object y3, Object x4, Object y4) {
        if (this.size() == 0) {
            throw new IllegalPathStateException("clockwiseArcTo only allowed when not empty");
        }
        this.add(new Segment(SegType.CLOCKWISE_ARCTO, x1, y1, x2, y2, x3, y3, x4, y4));
    }

    public void ellipseTo(Object x, Object y, Object w, Object h, Object t0, Object t1) {
        if (this.size() == 0 || ((Segment)this.get((int)(this.size() - 1))).type == SegType.CLOSE) {
            throw new IllegalPathStateException("ellipseTo is only allowed when a path segment is open");
        }
        this.add(new Segment(SegType.ELLIPSETO, x, y, w, h, t0, t1));
    }

    public void quadrantXTo(Object x, Object y) {
        if (this.size() == 0 || ((Segment)this.get((int)(this.size() - 1))).type == SegType.CLOSE) {
            throw new IllegalPathStateException("quadrantXTo is only allowed when a path segment is open");
        }
        this.add(new Segment(SegType.QUADRANT_XTO, x, y));
    }

    public void quadrantYTo(Object x, Object y) {
        if (this.size() == 0 || ((Segment)this.get((int)(this.size() - 1))).type == SegType.CLOSE) {
            throw new IllegalPathStateException("quadrantYTo is only allowed when a path segment is open");
        }
        this.add(new Segment(SegType.QUADRANT_YTO, x, y));
    }

    public void setWindingRule(int newValue) {
        if (newValue != this.windingRule) {
            this.invalidatePath();
            int oldValue = this.windingRule;
            this.windingRule = newValue;
        }
    }

    public int getWindingRule() {
        return this.windingRule;
    }

    public static class Segment
    implements Cloneable {
        public SegType type;
        public double[] coords = new double[8];
        public String[] modifiers = new String[8];

        public Segment() {
            this.type = SegType.LINETO;
        }

        public Segment(SegType type, Object ... coordOrModifier) {
            this.type = type;
            for (int i = 0; i < coordOrModifier.length; ++i) {
                if (coordOrModifier[i] instanceof Double) {
                    this.coords[i] = (Double)coordOrModifier[i];
                    continue;
                }
                this.modifiers[i] = (String)coordOrModifier[i];
            }
        }

        public Segment(Segment that) {
            this.setTo(that);
        }

        public void setTo(Segment that) {
            this.type = that.type;
            System.arraycopy(that.coords, 0, this.coords, 0, that.type.getLen());
            System.arraycopy(that.modifiers, 0, this.modifiers, 0, that.type.getLen());
        }

        public Object clone() {
            try {
                Segment that = (Segment)super.clone();
                that.coords = (double[])this.coords.clone();
                that.modifiers = (String[])this.modifiers.clone();
                return that;
            }
            catch (CloneNotSupportedException e) {
                InternalError error = new InternalError();
                error.initCause(e);
                throw error;
            }
        }

        public int hashCode() {
            return this.type.hashCode() << 24 | Arrays.hashCode(this.coords) & 0xFFF0000 | Arrays.hashCode(this.modifiers) & 0xFFFF;
        }

        public boolean equals(Object o) {
            if (o instanceof Segment) {
                Segment that = (Segment)o;
                return that.type == this.type && Arrays.equals(that.coords, this.coords) && Arrays.equals(that.modifiers, this.modifiers);
            }
            return false;
        }
    }

    public static enum SegType {
        MOVETO(2),
        LINETO(2),
        CURVETO(6),
        QUADTO(4),
        CLOSE(0),
        ELLIPSETO(6),
        ARCTO(8),
        CLOCKWISE_ARCTO(8),
        QUADRANT_XTO(2),
        QUADRANT_YTO(2);

        private int len;

        private SegType(int len) {
            this.len = len;
        }

        int getLen() {
            return this.len;
        }
    }
}

